/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.protocal.util;

import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import net.buffalo.protocal.ProtocolException;

public class DateUtil {
    public static String toUTCString(long time) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTimeInMillis(time);
        StringBuffer buffer = new StringBuffer();
        buffer.append(cal.get(1));
        buffer.append(DateUtil.leadingZero(cal.get(2) + 1));
        buffer.append(DateUtil.leadingZero(cal.get(5)));
        buffer.append("T");
        buffer.append(DateUtil.leadingZero(cal.get(11)));
        buffer.append(DateUtil.leadingZero(cal.get(12)));
        buffer.append(DateUtil.leadingZero(cal.get(13)));
        buffer.append("Z");
        return buffer.toString();
    }

    public static String leadingZero(int num) {
        return num < 10 ? "0" + num : String.valueOf(num);
    }

    public static Date fromUTCString(String string) {
        if (string == null || !Pattern.matches("^\\d{8}T\\d{6}Z$", string)) {
            throw new ProtocolException("date format error: " + string);
        }
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, Integer.valueOf(string.substring(0, 4)));
        cal.set(2, Integer.valueOf(string.substring(4, 6)) - 1);
        cal.set(5, Integer.valueOf(string.substring(6, 8)));
        cal.set(11, Integer.valueOf(string.substring(9, 11)));
        cal.set(12, Integer.valueOf(string.substring(11, 13)));
        cal.set(13, Integer.valueOf(string.substring(13, 15)));
        return cal.getTime();
    }
}

