/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.cp.eip.sso.EntryStateEnum;
import com.kingdee.eas.cp.eip.sso.LdapEntryCollection;
import com.kingdee.eas.cp.eip.sso.LdapEntryFacadeFactory;
import com.kingdee.eas.cp.eip.sso.LdapEntryFactory;
import com.kingdee.eas.cp.eip.sso.LdapEntryInfo;
import com.kingdee.eas.cp.eip.sso.client.AbstractLdapEntryListUI;
import com.kingdee.eas.cp.eip.sso.client.CheckListLF;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.AbstractCheckList;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class LdapEntryListUI
extends AbstractLdapEntryListUI {
    private static final Logger logger = CoreUIObject.getLogger(LdapEntryListUI.class);
    private AbstractCheckList cl = new CheckListLF();
    private String resourcestr = "com.kingdee.eas.cp.eip.sso.UserSyncResource";
    HashMap ctx = new HashMap();
    private Iterator it = null;
    private DefaultKingdeeTreeNode virtualRoot1;
    private DefaultKingdeeTreeNode ouTreeNode;
    private DefaultKingdeeTreeNode userTreeNode;
    private DefaultKingdeeTreeNode principalshipTreeNode;
    private DefaultKingdeeTreeNode groupsTreeNode;

    @Override
    public void actionActive_actionPerformed(ActionEvent e) throws Exception {
        super.actionActive_actionPerformed(e);
        this.submitUpdateState(EntryStateEnum.SSO_DEFAULT.toString());
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        super.actionClear_actionPerformed(e);
        this.submitUpdateState(EntryStateEnum.SSO_CLEAR.toString());
    }

    @Override
    public void actionRuDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionRuDelete_actionPerformed(e);
        this.submitUpdateState(EntryStateEnum.SSO_DELETE.toString());
    }

    private void submitUpdateState(String state) {
        try {
            List list = this.cl.getSelctList(this.tblMain, "id");
            if (list.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)this.resourcestr, (String)"pleaseselectduiliejilu"));
            } else {
                String message = null;
                if (EntryStateEnum.SSO_DEFAULT.toString().equals(state)) {
                    message = EASResource.getString((String)this.resourcestr, (String)"entrystateactive");
                }
                if (EntryStateEnum.SSO_CLEAR.toString().equals(state)) {
                    message = EASResource.getString((String)this.resourcestr, (String)"entrystateclear");
                }
                if (EntryStateEnum.SSO_DELETE.toString().equals(state)) {
                    message = EASResource.getString((String)this.resourcestr, (String)"entrystatedelete");
                }
                if (MsgBox.showConfirm2((String)message) == 0) {
                    LdapEntryFactory.getRemoteInstance().entryAlignmentActive(list, state);
                    this.actionRefresh_actionPerformed(null);
                }
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void importAction_actionPerformed(ActionEvent e) throws Exception {
        super.importAction_actionPerformed(e);
        DefaultKingdeeTreeNode selectNode = this.getSelectNode();
        if (selectNode != null) {
            HashMap map = null;
            if (MsgBox.showConfirm2((String)EASResource.getString((String)this.resourcestr, (String)"ldapentryimporttmp")) == 0) {
                DefaultKingdeeTreeNode virtualRoot1 = (DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot()).getChildAt(0);
                if (selectNode.equals(virtualRoot1)) {
                    map = LdapEntryFacadeFactory.getRemoteInstance().importLdapAll();
                    this.actionRefresh_actionPerformed(null);
                } else {
                    map = selectNode.getUserObject() instanceof LdapEntryInfo ? LdapEntryFacadeFactory.getRemoteInstance().importEntryInfo((LdapEntryInfo)selectNode.getUserObject()) : LdapEntryFacadeFactory.getRemoteInstance().importEntryType(selectNode.getUserObject().toString());
                    this.actionRefresh_actionPerformed(null);
                }
                if (map != null) {
                    String success = "";
                    success = map.get("SUCCESS") == null ? "0" : map.get("SUCCESS").toString();
                    String lost = "";
                    lost = map.get("LOST") == null ? "0" : map.get("LOST").toString();
                    MsgBox.showInfo((String)(EASResource.getString((String)this.resourcestr, (String)"ldapimportsuccess") + " " + success + " " + EASResource.getString((String)this.resourcestr, (String)"ldapimportentry") + "\n" + EASResource.getString((String)this.resourcestr, (String)"ldapimportlost") + " " + lost + " " + EASResource.getString((String)this.resourcestr, (String)"ldapimportentry")));
                }
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)this.resourcestr, (String)"pleasecheckentrytreenode"));
        }
    }

    @Override
    public void importAllAction_actionPerformed(ActionEvent e) throws Exception {
        super.importAllAction_actionPerformed(e);
        if (MsgBox.showConfirm2((String)EASResource.getString((String)this.resourcestr, (String)"ldapentryimporttmp")) == 0) {
            HashMap map = LdapEntryFacadeFactory.getRemoteInstance().importLdapAll();
            if (map != null) {
                String success = "";
                success = map.get("SUCCESS") == null ? "0" : map.get("SUCCESS").toString();
                String lost = "";
                lost = map.get("LOST") == null ? "0" : map.get("LOST").toString();
                MsgBox.showInfo((String)(EASResource.getString((String)this.resourcestr, (String)"ldapimportsuccess") + " " + success + " " + EASResource.getString((String)this.resourcestr, (String)"ldapimportentry") + "\n" + EASResource.getString((String)this.resourcestr, (String)"ldapimportlost") + " " + lost + " " + EASResource.getString((String)this.resourcestr, (String)"ldapimportentry")));
            }
            this.actionRefresh_actionPerformed(null);
        }
    }

    private void initTree() {
        try {
            LdapEntryCollection entryCol = LdapEntryFacadeFactory.getRemoteInstance().getTreeLdapEntryInfo();
            this.it = entryCol.iterator();
            String type = null;
            String strType = null;
            boolean isClUOUTree = true;
            boolean isClUUserTree = true;
            boolean isClUPrinTree = true;
            boolean isClUGroupTree = true;
            while (this.it.hasNext()) {
                LdapEntryInfo info = (LdapEntryInfo)this.it.next();
                type = info.getType();
                strType = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                if (strType.equals("orgunit")) {
                    if (isClUOUTree) {
                        isClUOUTree = false;
                        this.ouTreeNode.removeAllChildren();
                    }
                    this.addLdapPreceptNode(this.ouTreeNode, info);
                }
                if (strType.equals("user")) {
                    if (isClUUserTree) {
                        isClUUserTree = false;
                        this.userTreeNode.removeAllChildren();
                    }
                    this.addLdapPreceptNode(this.userTreeNode, info);
                }
                if (strType.equals("principalship")) {
                    if (isClUPrinTree) {
                        isClUPrinTree = false;
                        this.principalshipTreeNode.removeAllChildren();
                    }
                    this.addLdapPreceptNode(this.principalshipTreeNode, info);
                }
                if (!strType.equals("groups")) continue;
                if (isClUGroupTree) {
                    isClUGroupTree = false;
                    this.groupsTreeNode.removeAllChildren();
                }
                this.addLdapPreceptNode(this.groupsTreeNode, info);
            }
            if (isClUOUTree) {
                this.ouTreeNode.removeAllChildren();
            }
            if (isClUUserTree) {
                this.userTreeNode.removeAllChildren();
            }
            if (isClUPrinTree) {
                this.principalshipTreeNode.removeAllChildren();
            }
            if (isClUGroupTree) {
                this.groupsTreeNode.removeAllChildren();
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        KingdeeTreeModel treeModel = (KingdeeTreeModel)this.kDTree1.getModel();
        treeModel.reload((TreeNode)this.ouTreeNode);
        treeModel.reload((TreeNode)this.userTreeNode);
        treeModel.reload((TreeNode)this.principalshipTreeNode);
        treeModel.reload((TreeNode)this.groupsTreeNode);
        this.kDTree1.setSelectionNode((DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot()).getChildAt(0));
    }

    private void addLdapPreceptNode(DefaultKingdeeTreeNode virtualRoot, LdapEntryInfo info) {
        if (info.getState() != null && !info.getState(LocaleUtils.getLocale((String)"L2")).equals(STConverter.tc2sc((String)EntryStateEnum.SSO_DELETE.toString()))) {
            String title = info.getName();
            DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode();
            childNode.setText(title);
            childNode.setUserObject((Object)info);
            virtualRoot.add((MutableTreeNode)childNode);
        }
    }

    private DefaultKingdeeTreeNode searchNode(DefaultKingdeeTreeNode virtualRoot, Object ob) {
        DefaultKingdeeTreeNode childNode = null;
        if (ob instanceof LdapEntryInfo) {
            for (int i = 0; i < virtualRoot.getChildCount() && !ob.equals((childNode = (DefaultKingdeeTreeNode)virtualRoot.getChildAt(i)).getUserObject()); ++i) {
            }
        }
        if (childNode == null) {
            childNode = new DefaultKingdeeTreeNode();
        }
        return childNode;
    }

    private DefaultKingdeeTreeNode addLdapPreceptNode(DefaultKingdeeTreeNode virtualRoot, String title, Object ob) {
        DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode((Object)virtualRoot);
        childNode.setText(title);
        childNode.setUserObject(ob);
        ((DefaultMutableTreeNode)virtualRoot.getChildAt(0)).add((MutableTreeNode)childNode);
        this.kDTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                LdapEntryListUI.this.onSelectedValueChangedForTree(e);
            }
        });
        this.kDTree1.setModel((TreeModel)new KingdeeTreeModel((TreeNode)virtualRoot));
        this.kDTree1.setRootVisible(false);
        this.kDTree1.getSelectionModel().setSelectionMode(1);
        this.kDTree1.setSelectionNode(childNode);
        return childNode;
    }

    private void initTable() {
        DefaultKingdeeTreeNode selectNode = this.getSelectNode();
        FilterInfo filter = new FilterInfo();
        String fileStr = null;
        if (selectNode != null) {
            DefaultKingdeeTreeNode virtualRoot1 = (DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot()).getChildAt(0);
            if (selectNode.equals(virtualRoot1)) {
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)EntryStateEnum.SSO_DELETE.toString(), CompareType.NOTEQUALS));
                filter.setMaskString("#0");
                this.mainQuery = new EntityViewInfo();
                this.mainQuery.setFilter(filter);
                this.tblMain.removeRows();
            } else {
                if (selectNode.getUserObject() instanceof LdapEntryInfo) {
                    LdapEntryInfo linfo = (LdapEntryInfo)selectNode.getUserObject();
                    String name = selectNode.getText();
                    if (name.indexOf("(") != -1) {
                        name = name.substring(0, name.indexOf("("));
                    }
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + linfo.getNumber() + "%"), CompareType.LIKE));
                } else {
                    if (selectNode.getUserObject().toString().equals("orgunit")) {
                        fileStr = EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"orgunit") + "(" + selectNode.getUserObject().toString() + ")";
                    }
                    if (selectNode.getUserObject().toString().equals("user")) {
                        fileStr = EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"user") + "(" + selectNode.getUserObject().toString() + ")";
                    }
                    if (selectNode.getUserObject().toString().equals("principalship")) {
                        fileStr = EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"principalship") + "(" + selectNode.getUserObject().toString() + ")";
                    }
                    if (selectNode.getUserObject().toString().equals("groups")) {
                        fileStr = EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"groups") + "(" + selectNode.getUserObject().toString() + ")";
                    }
                    filter.getFilterItems().add(new FilterItemInfo("type", (Object)fileStr, CompareType.EQUALS));
                }
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)EntryStateEnum.SSO_DELETE.toString(), CompareType.NOTEQUALS));
                SorterItemInfo sorterItemInfo = new SorterItemInfo("createtime");
                sorterItemInfo.setSortType(SortType.ASCEND);
                filter.setMaskString("#0 and #1");
                this.mainQuery = new EntityViewInfo();
                this.mainQuery.getSorter().add(sorterItemInfo);
                this.mainQuery.setFilter(filter);
                this.tblMain.removeRows();
            }
        }
    }

    protected void onSelectedValueChangedForTree(TreeSelectionEvent e) {
        this.initTable();
    }

    private DefaultKingdeeTreeNode getSelectNode() {
        TreePath path = this.kDTree1.getSelectionPath();
        DefaultKingdeeTreeNode selectNode = null;
        if (path != null) {
            selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        }
        return selectNode;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((String)EASResource.getString((String)this.resourcestr, (String)"ldapentrydeletetemp")) == 0) {
            LdapEntryFacadeFactory.getRemoteInstance().delLdapEntry(this.cl.getSelctList(this.tblMain, "id"));
            this.actionRefresh_actionPerformed(null);
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initTree();
        this.initTable();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionPublishReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublishReport_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    protected String getEditUIName() {
        return LdapEntryListUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LdapEntryFactory.getRemoteInstance();
    }

    private void initRootTree() {
        DefaultKingdeeTreeNode virtualRoot = new DefaultKingdeeTreeNode((Object)"root");
        DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode((Object)virtualRoot);
        childNode.setText(EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"entrylisttreename"));
        virtualRoot.add((MutableTreeNode)childNode);
        this.kDTree1.setModel((TreeModel)new KingdeeTreeModel((TreeNode)virtualRoot));
        this.kDTree1.setRootVisible(false);
        this.kDTree1.getSelectionModel().setSelectionMode(1);
        this.kDTree1.setSelectionNode(childNode);
        this.virtualRoot1 = (DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot();
        this.ouTreeNode = this.addLdapPreceptNode(this.virtualRoot1, EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"orgunit"), "orgunit");
        this.userTreeNode = this.addLdapPreceptNode(this.virtualRoot1, EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"user"), "user");
        this.principalshipTreeNode = this.addLdapPreceptNode(this.virtualRoot1, EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"principalship"), "principalship");
        this.groupsTreeNode = this.addLdapPreceptNode(this.virtualRoot1, EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"groups"), "groups");
        this.initTree();
        this.kDTree1.setSelectionNode((DefaultKingdeeTreeNode)this.virtualRoot1.getChildAt(0));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initRootTree();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)EntryStateEnum.SSO_DELETE.toString(), CompareType.NOTEQUALS));
        filter.setMaskString("#0");
        SorterItemInfo sorterItemInfo = new SorterItemInfo("createtime");
        sorterItemInfo.setSortType(SortType.ASCEND);
        this.mainQuery = new EntityViewInfo();
        this.mainQuery.getSorter().add(sorterItemInfo);
        this.mainQuery.setFilter(filter);
        this.tblMain.removeRows();
        this.btnLdapImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnLdapImportAll.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnAddNew.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnView.setEnabled(false);
        this.kDWActive.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.kDWClear.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.kDWDelete.setIcon(EASResource.getIcon((String)"imgTbtn_analyze"));
    }
}

