/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.cp.eip.sso.ILdapEntryFacade;
import com.kingdee.eas.cp.eip.sso.IUserSyncHandleFacade;
import com.kingdee.eas.cp.eip.sso.LdapEntryFacadeFactory;
import com.kingdee.eas.cp.eip.sso.UserSyncHandleFacadeFactory;
import com.kingdee.eas.cp.eip.sso.client.AbstractLdapMapUI;
import com.kingdee.eas.cp.eip.sso.client.CheckListLF;
import com.kingdee.eas.cp.eip.sso.client.LdapEntryTypeUI;
import com.kingdee.eas.cp.eip.sso.client.LdapMapListUI;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.AbstractCheckList;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapControlInfo;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapEasInfo;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapPreceptInfo;
import com.kingdee.eas.cp.eip.sso.user.UserResource;
import com.kingdee.eas.cp.eip.sso.util.LdapTypeDescription;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class LdapMapUI
extends AbstractLdapMapUI {
    private static final Logger logger = CoreUIObject.getLogger(LdapMapUI.class);
    private AbstractCheckList cl = new CheckListLF();
    private IUIWindow currOrgTreeDialog;
    private static String ldapNumber;
    private static String ldapName;
    private static String ldapType;
    public static final String LDAPNUMBER = "ldapNumber";
    public static final String LDAPNAME = "ldapName";
    public static final String LDAPTYPE = "ldapType";
    private LdapControlInfo lcInfo = null;
    HashMap ctx = new HashMap();
    private static String state;
    private static KDComboBox cobMaping;
    private boolean isSave = false;
    private HashMap mappingMap = null;
    private boolean isCloseMag = false;

    public LdapMapUI() throws Exception {
        this.ctx.put("Owner", this);
    }

    public LdapMapUI(Frame owner, HashMap map) throws Exception {
        this.ctx.put("Owner", this);
        state = (String)map.get("state");
        ldapName = map.get(LDAPNAME).toString();
        ldapType = map.get(LDAPTYPE).toString();
    }

    public LdapMapUI(IUIObject owner, HashMap map) throws Exception {
        this.ctx.put("Owner", owner);
        state = (String)map.get("state");
        ldapName = map.get(LDAPNAME).toString();
        ldapType = map.get(LDAPTYPE).toString();
    }

    public void show() {
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            this.currOrgTreeDialog = uiFactory.create(LdapMapUI.class.getName(), (Map)this.ctx);
            this.currOrgTreeDialog.show();
        }
        catch (BOSException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.isCloseMag = false;
        this.tblDef.checkParsed();
        this.tblMaping.checkParsed();
        this.tblMV.checkParsed();
        this.tblObjectClass.checkParsed();
        this.initControl();
        this.initData();
        if (state.equals(OprtState.ADDNEW)) {
            this.btnUpd.setEnabled(false);
        }
    }

    private void initControl() {
        this.btnDefAdd.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnDefDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnMPAdd.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnMPDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnMVAdd.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnMVDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnObjAdd.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnObjDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRef.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnUpd.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.tblDef.setBorder(null);
        this.tblDef.setBorder((Border)new LineBorder(Color.gray));
        String strType = null;
        strType = EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)ldapType);
        this.txtType.setText(strType);
        this.txtType.setEnabled(false);
        try {
            this.btnRef_mouseClicked(null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (state.equals(OprtState.ADDNEW) || state.equals(OprtState.EDIT)) {
            this.setControlEnable(true);
        } else if (state.equals(OprtState.VIEW)) {
            this.setControlEnable(false);
        }
    }

    private void setControlEnable(boolean isEnable) {
        this.btnDefAdd.setEnabled(isEnable);
        this.btnDefDel.setEnabled(isEnable);
        this.btnMPAdd.setEnabled(isEnable);
        this.btnMPDel.setEnabled(isEnable);
        this.btnMVAdd.setEnabled(isEnable);
        this.btnMVDel.setEnabled(isEnable);
        this.btnObjAdd.setEnabled(isEnable);
        this.btnObjDel.setEnabled(isEnable);
        this.btnRef.setEnabled(isEnable);
        this.txtDN.setEnabled(isEnable);
        this.txtPDN.setEnabled(isEnable);
        this.txtPWD.setEnabled(isEnable);
        this.txtRDN.setEnabled(isEnable);
        this.tblDef.setEnabled(isEnable);
        this.tblMaping.setEnabled(isEnable);
        this.tblMV.setEnabled(isEnable);
        this.tblObjectClass.setEnabled(isEnable);
        this.txtID.setEnabled(isEnable);
        this.cbSwitch.setEnabled(isEnable);
        this.cobConnect.setEnabled(isEnable);
        if (!isEnable) {
            Color color = new Color(232, 232, 227);
            this.tblObjectClass.getColumn(0).getStyleAttributes().setBackground(color);
            this.tblMV.getColumn(0).getStyleAttributes().setBackground(color);
            this.tblMaping.getColumn(0).getStyleAttributes().setBackground(color);
            this.tblMaping.getColumn(1).getStyleAttributes().setBackground(color);
            this.tblDef.getColumn(0).getStyleAttributes().setBackground(color);
            this.tblDef.getColumn(1).getStyleAttributes().setBackground(color);
        } else {
            Color color = new Color(252, 251, 223);
            Color color1 = new Color(255, 255, 255);
            Color color2 = new Color(232, 232, 227);
            this.tblObjectClass.getColumn(0).getStyleAttributes().setBackground(color);
            this.tblMV.getColumn(0).getStyleAttributes().setBackground(color);
            this.tblMaping.getColumn(0).getStyleAttributes().setBackground(color2);
            this.tblMaping.getColumn(1).getStyleAttributes().setBackground(color);
            this.tblDef.getColumn(0).getStyleAttributes().setBackground(color1);
            this.tblDef.getColumn(1).getStyleAttributes().setBackground(color1);
        }
    }

    private void initData() throws EASBizException, BOSException {
        HashMap map = LdapEntryFacadeFactory.getRemoteInstance().readLdapEntryMap();
        Map.Entry entry2 = null;
        Map.Entry entry12 = null;
        LdapPreceptInfo ldapPreceptItem = null;
        LdapControlInfo item = null;
        LdapEasInfo ldapEasInfo2 = null;
        IRow row = null;
        block0: for (Map.Entry entry2 : map.entrySet()) {
            ldapPreceptItem = (LdapPreceptInfo)entry2.getValue();
            if (!ldapPreceptItem.getName().equals(ldapName)) continue;
            if (ldapPreceptItem.getLdapProperty() == null) break;
            for (Map.Entry entry12 : ldapPreceptItem.getLdapProperty().entrySet()) {
                Iterator it2;
                int i;
                item = (LdapControlInfo)entry12.getValue();
                if (!entry12.getKey().toString().equals(ldapType)) continue;
                this.lcInfo = item;
                this.txtDN.setText(item.getDn());
                this.txtPDN.setText(item.getParent());
                this.txtPWD.setText(item.getEasEntryPwd());
                this.txtRDN.setText(item.getRelativelyName());
                this.txtID.setText(item.getEasEntryID());
                if (item.getImportSwitch().equals("false")) {
                    this.cbSwitch.setSelected(false);
                } else {
                    this.cbSwitch.setSelected(true);
                }
                for (i = 0; i < this.cobConnect.getItemCount() && !this.cobConnect.getItemAt(i).toString().equals(item.getAdduction()); ++i) {
                }
                if (i == this.cobConnect.getItemCount()) {
                    this.cobConnect.setSelectedIndex(0);
                } else {
                    this.cobConnect.setSelectedIndex(i);
                }
                if (item.getObjectClass() != null) {
                    it2 = item.getObjectClass().iterator();
                    while (it2.hasNext()) {
                        this.tblObjectClass.addRow().getCell(0).setValue((Object)it2.next().toString());
                    }
                }
                if (item.getMustValue() != null) {
                    it2 = item.getMustValue().iterator();
                    while (it2.hasNext()) {
                        this.tblMV.addRow().getCell(0).setValue((Object)it2.next().toString());
                    }
                }
                if (item.getDefValue() != null) {
                    for (LdapEasInfo ldapEasInfo2 : item.getDefValue()) {
                        row = this.tblDef.addRow();
                        row.getCell(0).setValue((Object)ldapEasInfo2.getKeyName());
                        row.getCell(1).setValue((Object)ldapEasInfo2.getKeyValue());
                    }
                }
                if (item.getMapValue() == null) break block0;
                it2 = item.getMapValue().iterator();
                while (it2.hasNext()) {
                    boolean isSet = true;
                    ldapEasInfo2 = (LdapEasInfo)it2.next();
                    for (int j = 0; j < this.tblMaping.getRowCount(); ++j) {
                        String str = this.tblMaping.getRow(j).getCell(0).getValue().toString();
                        str = str.substring(str.indexOf("(") + 1, str.length() - 1);
                        if (!ldapEasInfo2.getKeyValue().equals(str)) continue;
                        this.tblMaping.getRow(j).getCell(1).setValue((Object)ldapEasInfo2.getKeyName());
                        if (this.mappingMap == null) {
                            this.mappingMap = new HashMap();
                        }
                        this.mappingMap.put(ldapEasInfo2.getKeyName(), String.valueOf(j));
                        isSet = false;
                    }
                    if (!isSet) continue;
                    row = this.tblMaping.addRow();
                    row.getCell(0).setValue((Object)ldapEasInfo2.getKeyValue());
                    row.getCell(1).setValue((Object)ldapEasInfo2.getKeyName());
                }
                break block0;
            }
        }
    }

    @Override
    protected void btnRef_mouseClicked(MouseEvent e) throws Exception {
        super.btnRef_mouseClicked(e);
        this.cobConnect.removeAllItems();
        HashMap map = null;
        IUserSyncHandleFacade iUserSyncHandleFacade = UserSyncHandleFacadeFactory.getRemoteInstance();
        map = iUserSyncHandleFacade.getAllUserNode();
        Iterator it = map.entrySet().iterator();
        Map.Entry entry2 = null;
        UserResource userResource = null;
        while (it.hasNext()) {
            entry2 = it.next();
            userResource = (UserResource)entry2.getValue();
            if (!userResource.getResourceType().toString().equalsIgnoreCase("ldap")) continue;
            this.cobConnect.addItem((Object)entry2.getKey().toString());
        }
        this.tblMaping.checkParsed();
        IRow row = null;
        Color color = new Color(232, 232, 227);
        cobMaping = new KDComboBox();
        HashMap mapEas = LdapTypeDescription.getTypeDescription(ldapType);
        if (mapEas != null && mapEas.size() != 0) {
            for (Map.Entry entry2 : mapEas.entrySet()) {
                row = this.tblMaping.addRow();
                String str = LdapMapListUI.getSystemStr(entry2.getValue().toString()) + "(" + entry2.getKey().toString() + ")";
                cobMaping.addItem((Object)str);
                row.getCell(0).setValue((Object)str);
                row.getCell(0).getStyleAttributes().setBackground(color);
            }
        }
    }

    @Override
    protected void btnDefAdd_mouseClicked(MouseEvent e) throws Exception {
        super.btnDefAdd_mouseClicked(e);
        if (this.btnDefAdd.isEnabled()) {
            this.addRow(this.tblDef);
        }
    }

    @Override
    protected void btnDefDel_mouseClicked(MouseEvent e) throws Exception {
        super.btnDefDel_mouseClicked(e);
        if (this.btnDefDel.isEnabled()) {
            this.delRow(this.tblDef, -1);
        }
    }

    @Override
    protected void btnMPAdd_mouseClicked(MouseEvent e) throws Exception {
        super.btnMPAdd_mouseClicked(e);
        IRow row = null;
        Color color = new Color(252, 251, 223);
        if (this.btnMPAdd.isEnabled()) {
            row = this.addRow(this.tblMaping);
            KDTDefaultCellEditor itemEditor = null;
            itemEditor = new KDTDefaultCellEditor((JComboBox)cobMaping);
            row.getCell(0).setEditor((ICellEditor)itemEditor);
            row.getCell(0).getStyleAttributes().setLocked(false);
            row.getCell(0).getStyleAttributes().setBackground(color);
        }
    }

    @Override
    protected void btnMPDel_actionPerformed(ActionEvent e) throws Exception {
        super.btnMPDel_actionPerformed(e);
        if (this.btnMPDel.isEnabled()) {
            this.delRow(this.tblMaping, LdapTypeDescription.getTypeDescriptionLong(ldapType) - 1);
        }
    }

    @Override
    protected void btnMVAdd_mouseClicked(MouseEvent e) throws Exception {
        super.btnMVAdd_mouseClicked(e);
        if (this.btnMVAdd.isEnabled()) {
            this.addRow(this.tblMV);
        }
    }

    @Override
    protected void btnMVDel_mouseClicked(MouseEvent e) throws Exception {
        super.btnMVDel_mouseClicked(e);
        if (this.btnMVDel.isEnabled()) {
            this.delRow(this.tblMV, -1);
        }
    }

    @Override
    protected void btnObjAdd_mouseClicked(MouseEvent e) throws Exception {
        super.btnObjAdd_mouseClicked(e);
        if (this.btnObjAdd.isEnabled()) {
            this.addRow(this.tblObjectClass);
        }
    }

    @Override
    protected void btnObjDel_mouseClicked(MouseEvent e) throws Exception {
        super.btnObjDel_mouseClicked(e);
        if (this.btnObjDel.isEnabled()) {
            this.delRow(this.tblObjectClass, -1);
        }
    }

    private IRow addRow(KDTable table) {
        return table.addRow();
    }

    private void delRow(KDTable table, int numRow) {
        List list = this.cl.backspinList(table);
        Iterator it = list.iterator();
        int tempnum = 0;
        while (it.hasNext()) {
            tempnum = Integer.parseInt(it.next().toString());
            if (tempnum > numRow) {
                table.removeRow(tempnum);
                continue;
            }
            IRow row = table.getRow(tempnum);
            int numcol = table.getColumnCount() - 1;
            row.getCell(numcol).setValue((Object)"");
        }
    }

    @Override
    protected void btnCancel_mouseClicked(MouseEvent e) throws Exception {
        super.btnCancel_mouseClicked(e);
        this.getUIWindow().close();
    }

    @Override
    protected void btnOK_mouseClicked(MouseEvent e) throws Exception {
        super.btnOK_mouseClicked(e);
    }

    public static boolean isLegal(String str) {
        String regor = "^.*[|~|`|\\||{|}|\\[|\\]|\uff5e|\uff40|\uff01|\u00b7|\uff03|\uffe5\uff5c\uff05|\u2026\u2026|\u2014|\uff0a|\u3002|\uff1f||!|/|@|#|$|%|^|&|*|<|>|?|'|\\\\|].*$";
        Pattern p = Pattern.compile(regor);
        Matcher m = p.matcher(str);
        boolean result = m.find();
        return result;
    }

    public boolean destroyWindow() {
        try {
            ((LdapMapListUI)((Object)this.getUIContext().get("Owner"))).onLoad();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return super.destroyWindow();
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        this.isCloseMag = false;
        HashMap map = new HashMap();
        LdapEntryTypeUI lentry = new LdapEntryTypeUI((IUIObject)this, map);
        lentry.show();
        if (lentry.getData()[1] != null) {
            ldapName = lentry.getData()[0];
            ldapType = lentry.getData()[1];
            state = OprtState.ADDNEW;
            this.setControlEnable(true);
            this.initControlNull();
            this.btnUpd.setEnabled(false);
        }
    }

    private void initControlNull() throws Exception {
        this.txtDN.setText("");
        this.txtPDN.setText("");
        this.txtPWD.setText("");
        this.txtRDN.setText("");
        this.tblDef.removeRows();
        this.tblMV.removeRows();
        this.tblObjectClass.removeRows();
        this.cobConnect.removeAllItems();
        this.tblMaping.removeRows();
        int num = LdapTypeDescription.getTypeDescriptionLong(ldapType) - 1;
        for (int i = 0; i < this.tblMaping.getRowCount(); ++i) {
            if (i < num) {
                this.tblMaping.getRow(i).getCell(1).setValue((Object)"");
                continue;
            }
            this.tblMaping.removeRow(i);
        }
        this.txtID.setText("");
        this.cbSwitch.setSelected(false);
        this.btnRef_mouseClicked(null);
    }

    @Override
    public void actionDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionDown_actionPerformed(e);
        this.initControlNull();
        Map.Entry entry = null;
        Map.Entry entry1 = null;
        Iterator it = LdapEntryFacadeFactory.getRemoteInstance().readLdapEntryMap().entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            LdapPreceptInfo item = (LdapPreceptInfo)entry.getValue();
            if (!item.getName().equals(ldapName)) continue;
            if (!it.hasNext() || (item = (LdapPreceptInfo)(entry = it.next()).getValue()).getLdapProperty().size() == 0) break;
            Iterator it1 = item.getLdapProperty().entrySet().iterator();
            entry1 = it1.next();
            ldapType = (String)entry1.getKey();
            ldapName = item.getName();
            break;
        }
        this.initData();
        this.btnUpd.setEnabled(true);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        ControlUtilities.checkFocusAndCommit();
        super.actionSave_actionPerformed(e);
        this.isSave = true;
        if (!state.equals(OprtState.VIEW)) {
            String str1;
            String str;
            int i;
            LdapEasInfo ldapEasInfo;
            ILdapEntryFacade ldap = LdapEntryFacadeFactory.getRemoteInstance();
            LdapPreceptInfo ldapPreceptItem = new LdapPreceptInfo();
            LdapControlInfo item = new LdapControlInfo();
            if (this.txtDN.getText() != null && this.txtDN.getText().length() != 0) {
                if (!LdapMapUI.isLegal(this.txtDN.getText())) {
                    item.setDn(this.txtDN.getText());
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapPreceptDNisspecial"));
                    this.txtDN.requestFocus();
                    SysUtil.abort();
                }
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapPreceptDNisNull"));
                this.txtDN.requestFocus();
                SysUtil.abort();
            }
            if (this.txtRDN.getText() != null && this.txtRDN.getText().length() != 0) {
                if (!LdapMapUI.isLegal(this.txtRDN.getText())) {
                    item.setRelativelyName(this.txtRDN.getText());
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapPreceptRDNisspecial"));
                    this.txtRDN.requestFocus();
                    SysUtil.abort();
                }
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapPreceptRDNisNull"));
                this.txtRDN.requestFocus();
                SysUtil.abort();
            }
            if (this.txtID.getText() != null && this.txtID.getText().length() != 0) {
                if (!LdapMapUI.isLegal(this.txtID.getText())) {
                    item.setEasRelativelyName(this.txtID.getText());
                    item.setEasEntryID(this.txtID.getText());
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapPreceptEASisisspecial"));
                    this.txtID.requestFocus();
                    SysUtil.abort();
                }
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapPreceptEASIDisNull"));
                this.txtID.requestFocus();
                SysUtil.abort();
            }
            item.setAdduction(this.cobConnect.getSelectedItem().toString());
            if (this.cbSwitch.isSelected()) {
                item.setImportSwitch("true");
            } else {
                item.setImportSwitch("false");
            }
            if (this.txtPDN.getText() != null && this.txtPDN.getText().length() != 0) {
                if (!LdapMapUI.isLegal(this.txtPDN.getText())) {
                    item.setParent(this.txtPDN.getText());
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapPreceptfdnshuxingisrepeat"));
                    this.txtPDN.requestFocus();
                    SysUtil.abort();
                }
            } else {
                item.setParent("");
            }
            if (this.txtPWD.getText() != null && this.txtPWD.getText().length() != 0) {
                if (!LdapMapUI.isLegal(this.txtPWD.getText())) {
                    item.setEasEntryPwd(this.txtPWD.getText());
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapPreceptfpwdisrepeat"));
                    this.txtPWD.requestFocus();
                    SysUtil.abort();
                }
            } else {
                item.setEasEntryPwd("");
            }
            ArrayList<String> ayObject = null;
            ArrayList<LdapEasInfo> ayMaping = null;
            ArrayList<String> ayMV = null;
            ArrayList<LdapEasInfo> ayDefault = null;
            if (this.tblObjectClass.getRowCount() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapPreceptObjectisNull"));
                SysUtil.abort();
            } else {
                ayObject = new ArrayList<String>();
                for (int i2 = 0; i2 < this.tblObjectClass.getRowCount(); ++i2) {
                    if (this.tblObjectClass.getRow(i2).getCell(0).getValue() == null) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapPreceptObjectisNull"));
                        SysUtil.abort();
                        continue;
                    }
                    String str2 = this.tblObjectClass.getRow(i2).getCell(0).getValue().toString();
                    if (!LdapMapUI.isLegal(str2)) {
                        ayObject.add(str2);
                        continue;
                    }
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapPreceptObjectisspecial"));
                    SysUtil.abort();
                }
            }
            boolean isNull = false;
            boolean isInfo = true;
            if (this.tblMaping.getRowCount() != 0) {
                ayMaping = new ArrayList<LdapEasInfo>();
                ldapEasInfo = null;
                for (i = 0; i < this.tblMaping.getRowCount(); ++i) {
                    if (this.tblMaping.getRow(i).getCell(1).getValue() != null && this.tblMaping.getRow(i).getCell(0).getValue() != null) {
                        ldapEasInfo = new LdapEasInfo();
                        str = this.tblMaping.getRow(i).getCell(0).getValue().toString();
                        str1 = this.tblMaping.getRow(i).getCell(1).getValue().toString();
                        if (!LdapMapUI.isLegal(str1)) {
                            str = str.substring(str.indexOf("(") + 1, str.length() - 1);
                            ldapEasInfo.setKeyValue(str);
                            ldapEasInfo.setKeyName(str1);
                            ayMaping.add(ldapEasInfo);
                        } else {
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapPreceptMapingisspecial"));
                            SysUtil.abort();
                        }
                        isInfo = false;
                        continue;
                    }
                    isNull = true;
                }
            }
            if (isInfo && isNull) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapPreceptMapingisNull"));
                SysUtil.abort();
            }
            if (this.tblMV.getRowCount() != 0) {
                ayMV = new ArrayList<String>();
                for (int i3 = 0; i3 < this.tblMV.getRowCount(); ++i3) {
                    String str3 = this.tblMV.getRow(i3).getCell(0).getValue().toString();
                    if (!LdapMapUI.isLegal(str3)) {
                        ayMV.add(str3);
                        continue;
                    }
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapPreceptMustisspecial"));
                    SysUtil.abort();
                }
            }
            if (this.tblDef.getRowCount() != 0) {
                ayDefault = new ArrayList<LdapEasInfo>();
                ldapEasInfo = null;
                for (i = 0; i < this.tblDef.getRowCount(); ++i) {
                    if (this.tblDef.getRow(i).getCell(1).getValue() == null || this.tblDef.getRow(i).getCell(0).getValue() == null) continue;
                    ldapEasInfo = new LdapEasInfo();
                    str = this.tblDef.getRow(i).getCell(0).getValue().toString();
                    str1 = this.tblDef.getRow(i).getCell(1).getValue().toString();
                    if (!LdapMapUI.isLegal(str) && !LdapMapUI.isLegal(str1)) {
                        ldapEasInfo.setKeyName(str);
                        ldapEasInfo.setKeyValue(str1);
                        ayDefault.add(ldapEasInfo);
                        continue;
                    }
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapPreceptDefaultisspecial"));
                    SysUtil.abort();
                }
            }
            item.setMustValue(ayMV);
            item.setDefValue(ayDefault);
            item.setObjectClass(ayObject);
            item.setMapValue(ayMaping);
            HashMap map = ldap.readLdapEntryMap();
            Map.Entry entry = null;
            Iterator it = map.entrySet().iterator();
            HashMap LdapPropertyTemp = null;
            while (it.hasNext()) {
                entry = it.next();
                LdapPreceptInfo ldaptemp = (LdapPreceptInfo)entry.getValue();
                if (!ldaptemp.getName().equals(ldapName)) continue;
                ldapNumber = ldaptemp.getNumber();
                ldapPreceptItem.setName(ldaptemp.getName());
                ldapPreceptItem.setNumber(ldaptemp.getNumber());
                ldapPreceptItem.setState(ldaptemp.getState());
                LdapPropertyTemp = ldaptemp.getLdapProperty();
                break;
            }
            try {
                LdapPropertyTemp.remove(ldapType);
            }
            catch (RuntimeException e1) {
                logger.info((Object)"ldap entry type is null!");
            }
            if (LdapPropertyTemp == null) {
                LdapPropertyTemp = new HashMap();
            }
            LdapPropertyTemp.put(ldapType, item);
            ldapPreceptItem.setLdapProperty(LdapPropertyTemp);
            map.remove(ldapNumber);
            map.put(ldapPreceptItem.getNumber(), ldapPreceptItem);
            ldap.writeLdapEntryMap(map);
            this.getUIWindow().close();
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"savesuccess"));
    }

    @Override
    public void actionUp_actionPerformed(ActionEvent e) throws Exception {
        LdapPreceptInfo item;
        super.actionUp_actionPerformed(e);
        this.initControlNull();
        Map.Entry entry = null;
        Map.Entry entry1 = null;
        Iterator it = LdapEntryFacadeFactory.getRemoteInstance().readLdapEntryMap().entrySet().iterator();
        String tempLdapName = ldapName;
        while (it.hasNext() && !(item = (LdapPreceptInfo)(entry = it.next()).getValue()).getName().equals(tempLdapName)) {
            ldapName = item.getName();
            Iterator it1 = item.getLdapProperty().entrySet().iterator();
            entry1 = it1.next();
            ldapType = (String)entry1.getKey();
        }
        this.initData();
        this.btnUpd.setEnabled(true);
    }

    @Override
    public void actionUpd_actionPerformed(ActionEvent e) throws Exception {
        super.actionUpd_actionPerformed(e);
        state = OprtState.EDIT;
        this.setControlEnable(true);
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.initControlNull();
        Iterator it = LdapEntryFacadeFactory.getRemoteInstance().readLdapEntryMap().entrySet().iterator();
        Map.Entry entry = it.next();
        LdapPreceptInfo item = (LdapPreceptInfo)entry.getValue();
        ldapName = item.getName();
        it = item.getLdapProperty().entrySet().iterator();
        entry = it.next();
        ldapType = (String)entry.getKey();
        this.initData();
        this.btnUpd.setEnabled(true);
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.initControlNull();
        Map.Entry entry2 = null;
        Map.Entry entry1 = null;
        for (Map.Entry entry2 : LdapEntryFacadeFactory.getRemoteInstance().readLdapEntryMap().entrySet()) {
            LdapPreceptInfo item = (LdapPreceptInfo)entry2.getValue();
            if (item.getLdapProperty().size() == 0) continue;
            Iterator it1 = item.getLdapProperty().entrySet().iterator();
            entry1 = it1.next();
            ldapType = (String)entry1.getKey();
            ldapName = item.getName();
        }
        this.initData();
        this.btnUpd.setEnabled(true);
    }

    private void checkClose() throws Exception {
        block23: {
            block24: {
                LdapEasInfo ldapEasInfo;
                block25: {
                    int i;
                    if (state.equals(OprtState.VIEW)) break block23;
                    this.isCloseMag = false;
                    ControlUtilities.checkFocusAndCommit();
                    if (this.lcInfo == null) break block24;
                    if (!(this.lcInfo.getDn().equals(this.txtDN.getText()) && this.lcInfo.getParent().equals(this.txtPDN.getText()) && this.lcInfo.getEasEntryPwd().equals(this.txtPWD.getText()) && this.lcInfo.getRelativelyName().equals(this.txtRDN.getText()) && this.lcInfo.getEasEntryID().equals(this.txtID.getText()))) {
                        this.isCloseMag = true;
                    }
                    if (!this.lcInfo.getImportSwitch().equals(String.valueOf(this.cbSwitch.isSelected()))) {
                        this.isCloseMag = true;
                    }
                    if (this.tblObjectClass.getRowCount() != this.lcInfo.getObjectClass().size()) {
                        this.isCloseMag = true;
                    } else if (!this.isCloseMag) {
                        for (i = 0; i < this.tblObjectClass.getRowCount(); ++i) {
                            if (this.lcInfo.getObjectClass().get(i).toString().equals(this.tblObjectClass.getRow(i).getCell(0).getValue().toString())) continue;
                            this.isCloseMag = true;
                            break;
                        }
                    }
                    if (this.tblMV.getRowCount() != this.lcInfo.getMustValue().size()) {
                        this.isCloseMag = true;
                    } else if (!this.isCloseMag) {
                        for (i = 0; i < this.tblMV.getRowCount(); ++i) {
                            if (this.lcInfo.getMustValue().get(i).toString().equals(this.tblMV.getRow(i).getCell(0).getValue().toString())) continue;
                            this.isCloseMag = true;
                            break;
                        }
                    }
                    if (!this.isCloseMag) {
                        boolean t = false;
                        for (i = 0; i < this.tblMaping.getRowCount(); ++i) {
                            String str = "";
                            if (this.tblMaping.getRow(i).getCell(1).getValue() != null) {
                                str = this.tblMaping.getRow(i).getCell(1).getValue().toString();
                            }
                            if (StringUtils.isEmpty((String)str)) continue;
                            if (this.mappingMap.get(str) != null) {
                                this.mappingMap.remove(str);
                                continue;
                            }
                            this.isCloseMag = true;
                            break;
                        }
                        if (!this.isCloseMag && this.mappingMap.size() > 0) {
                            this.isCloseMag = true;
                        }
                    }
                    ldapEasInfo = null;
                    if (this.tblDef.getRowCount() == this.lcInfo.getDefValue().size()) break block25;
                    this.isCloseMag = true;
                    break block23;
                }
                if (this.isCloseMag) break block23;
                for (int i = 0; i < this.tblDef.getRowCount(); ++i) {
                    ldapEasInfo = (LdapEasInfo)this.lcInfo.getDefValue().get(i);
                    if (!ldapEasInfo.getKeyName().toString().equals(this.tblDef.getRow(i).getCell(0).getValue().toString())) {
                        this.isCloseMag = true;
                    } else {
                        if (ldapEasInfo.getKeyValue().toString().equals(this.tblDef.getRow(i).getCell(1).getValue().toString())) continue;
                        this.isCloseMag = true;
                    }
                    break block23;
                }
                break block23;
            }
            if (!(StringUtils.isEmpty((String)this.txtDN.getText()) && StringUtils.isEmpty((String)this.txtRDN.getText()) && StringUtils.isEmpty((String)this.txtPDN.getText()) && StringUtils.isEmpty((String)this.txtPWD.getText()) && StringUtils.isEmpty((String)this.txtID.getText()))) {
                this.isCloseMag = true;
            }
            if (this.cbSwitch.isSelected()) {
                this.isCloseMag = true;
            }
            if (this.cobConnect.getSelectedIndex() != 0) {
                this.isCloseMag = true;
            }
            if (this.tblObjectClass.getRowCount() != 0 || this.tblMV.getRowCount() != 0 || this.tblDef.getRowCount() != 0) {
                this.isCloseMag = true;
            }
            for (int i = 0; i < this.tblMaping.getRowCount(); ++i) {
                ICell ob = this.tblMaping.getRow(i).getCell(1);
                if (ob == null || !StringUtils.isEmpty((String)ob.toString())) continue;
                this.isCloseMag = true;
                break;
            }
        }
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            this.checkClose();
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        if (this.isCloseMag && !this.isSave) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.actionSave_actionPerformed(null);
                    return true;
                }
                catch (Exception e) {
                    this.handleException(e);
                    return false;
                }
            }
            return result == 1;
        }
        return true;
    }
}

