/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.sso.IUserSyncHandleFacade;
import com.kingdee.eas.cp.eip.sso.UserSyncHandleFacadeFactory;
import com.kingdee.eas.cp.eip.sso.client.AbstractLdapSyncUI;
import com.kingdee.eas.cp.eip.sso.client.LdapSyncEditUI;
import com.kingdee.eas.cp.eip.sso.client.ListLF;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.IFlowUI;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapClientUtil;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapExtendUtil;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapServerUtil;
import com.kingdee.eas.cp.eip.sso.user.PasswordUtils;
import com.kingdee.eas.cp.eip.sso.user.UserResource;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigItem;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class LdapSyncUI
extends AbstractLdapSyncUI
implements IFlowUI {
    private static final Logger logger = CoreUIObject.getLogger(LdapSyncEditUI.class);
    private String upID = "";
    private HashMap map;
    private String path = "";
    private String state = "";
    private HashMap classMap;
    private UserResource userResource;
    private HashMap userSyncConfigMap;
    private DirContext dirCtx;
    private String baseDN;
    private boolean isCloseMag = false;
    private LdapClientUtil ldapClientUtil = LdapClientUtil.init();
    private DefaultKingdeeTreeNode rootNode = null;

    private void initState(boolean isEnable) {
        this.txtID.setEnabled(isEnable);
        this.txtURL.setEnabled(isEnable);
        this.ldap2Database(isEnable);
        this.txtName.setEnabled(isEnable);
        this.txtNumber.setEnabled(isEnable);
        this.txtRe.setEnabled(isEnable);
        this.txtSelect.setEnabled(isEnable);
        this.TtxtPWDefault.setEnabled(isEnable);
        this.cmbType.setEnabled(isEnable);
        this.btSync.setEnabled(!isEnable);
        this.btExport.setEnabled(!isEnable);
        this.btImport.setEnabled(!isEnable);
    }

    private void ldap2Database(boolean isEnable) {
        if (this.state.equals(OprtState.ADDNEW) || this.state.equals(OprtState.EDIT)) {
            if (this.cmbType.getSelectedItem().toString().equals("LDAP")) {
                this.setState(true);
            } else {
                this.setState(false);
            }
        } else {
            this.setState(isEnable);
        }
    }

    private void setState(boolean isEnable) {
        this.txtPort.setEnabled(isEnable);
        this.cmbDN.setEnabled(isEnable);
        this.btGetDN.setEnabled(isEnable);
        this.txtUser.setEnabled(isEnable);
        this.txtPW.setEnabled(isEnable);
        this.btLeft.setEnabled(isEnable);
        this.btRight.setEnabled(isEnable);
        this.txtImport.setEnabled(isEnable);
        this.cmbClass.setEnabled(isEnable);
    }

    private void initDN() {
        try {
            this.cmbDN.removeAllItems();
            Properties env = new Properties();
            env.put("java.naming.referral", "throw");
            InitialDirContext dirCtx = new InitialDirContext(env);
            Attributes ats = dirCtx.getAttributes("ldap://" + this.txtURL.getText() + ":" + this.txtPort.getText() + "/", new String[]{"namingcontexts"});
            Attribute at = ats.get("namingcontexts");
            for (int i = 0; i < at.size(); ++i) {
                this.cmbDN.addItem((Object)at.get(i).toString());
            }
        }
        catch (Exception e1) {
            this.setMessage("", true);
        }
    }

    private void init() throws Exception {
        this.btAdd.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btUp.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btSync.setIcon(EASResource.getIcon((String)"imgTbtn_synchronization"));
        this.btDefault.setIcon(EASResource.getIcon((String)"imgTbtn_defaultopen"));
        this.btLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btConn.setIcon(EASResource.getIcon((String)"imgTbtn_connectdatafountain"));
        this.btRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.txtName.setText("displayName");
        this.txtNumber.setText("sAMAccountName");
        this.txtRe.setText("sAMAccountName,displayName");
        this.txtSelect.setText("(&(objectClass=person)(objectClass=user)(whenCreated>={0}))");
        this.txtImport.setText("com.kingdee.eas.cp.eip.sso.ldapAdapter.XMLUtil");
        this.txtID.setText("");
        this.txtURL.setText("");
        this.txtPort.setText("");
        this.txtUser.setText("");
        this.txtPW.setText("");
        this.TtxtPWDefault.setText("kingdee");
        this.cmbClass.removeAllItems();
        this.cmbType.removeAllItems();
        this.cmbDN.removeAllItems();
        this.cmbType.addItem((Object)"LDAP");
        this.cmbType.addItem((Object)"database");
        this.classMap = UserSyncHandleFacadeFactory.getRemoteInstance().getSyncClass();
        String str = this.classMap.toString();
        str = str.substring(str.lastIndexOf("{"), str.indexOf("}"));
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreElements()) {
            String temp = st.nextElement().toString().trim();
            String temp1 = EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)(temp = temp.substring(temp.indexOf("=") + 1, temp.length())));
            if (temp1.equals("Missing Resource")) {
                this.cmbClass.addItem((Object)temp);
                continue;
            }
            this.cmbClass.addItem((Object)temp1);
        }
        this.kDTable2.removeRows();
        this.tree.setModel(null);
    }

    private void initValue() throws Exception {
        if (!this.state.equals(OprtState.ADDNEW) && this.getUIContext().get("USERSYNCLIST") != null) {
            if (this.userResource.getResourceType().equalsIgnoreCase("database")) {
                this.cmbType.setSelectedIndex(1);
                this.txtImport.setText(this.userResource.getSyncImport());
            } else {
                this.cmbType.setSelectedIndex(0);
                String tempurl = this.userResource.getProviderURL();
                this.txtURL.setText(tempurl.substring(tempurl.indexOf("//") + 2, tempurl.lastIndexOf(":")));
                this.txtPort.setText(tempurl.substring(tempurl.lastIndexOf(":") + 1, tempurl.trim().length() - 1));
                this.txtUser.setText(this.userResource.getPrincipal());
                this.txtImport.setText(this.userResource.getSyncImport());
                String credentials = this.userResource.getCredentials();
                String flagStr = "encrypt:";
                if (credentials.startsWith(flagStr)) {
                    int idx = flagStr.trim().length();
                    credentials = credentials.substring(idx);
                    this.txtPW.setText(PasswordUtils.decodePassword(this.userResource.getPrincipal(), credentials));
                }
                this.cmbDN.removeAllItems();
                this.cmbDN.addItem((Object)this.userResource.getConDN());
                this.cmbDN.setSelectedItem((Object)this.userResource.getConDN());
            }
            this.txtID.setText(this.upID);
            this.kDTable2.removeRows();
            this.userSyncConfigMap = this.userResource.getUserSyncConfigItemMap();
            Iterator ite = this.userSyncConfigMap.entrySet().iterator();
            Map.Entry entry2 = null;
            while (ite.hasNext()) {
                entry2 = ite.next();
                UserSyncConfigItem userSyncConfigItem = (UserSyncConfigItem)entry2.getValue();
                this.txtName.setText(userSyncConfigItem.getMapToEasUserName());
                this.txtNumber.setText(userSyncConfigItem.getMapToEasUserNumber());
                this.txtRe.setText(userSyncConfigItem.getReturningAttributes());
                this.txtSelect.setText(userSyncConfigItem.getFilter());
                this.TtxtPWDefault.setText(userSyncConfigItem.getDefaultPwd());
                if (this.userResource.getResourceType().equalsIgnoreCase("database")) {
                    this.txtURL.setText(this.userResource.getJndiName());
                    continue;
                }
                this.kDTable2.addRow().getCell(0).setValue((Object)userSyncConfigItem.getBaseDN());
            }
            boolean isEqual = false;
            for (Map.Entry entry2 : this.classMap.entrySet()) {
                if (!entry2.getValue().toString().equals(this.userResource.getSyncClass())) continue;
                isEqual = true;
                break;
            }
            if (isEqual) {
                if (StringUtils.isEmpty((String)this.userResource.getSyncClass())) {
                    this.cmbClass.setSelectedIndex(0);
                } else {
                    this.cmbClass.addItem((Object)this.userResource.getSyncClass());
                    this.cmbClass.setSelectedItem((Object)this.userResource.getSyncClass());
                }
            } else {
                String temp = this.userResource.getSyncClass();
                String temp1 = EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)temp.substring(temp.indexOf("=") + 1, temp.trim().length()));
                this.cmbClass.setSelectedItem((Object)temp1);
            }
            if (!this.state.equals(OprtState.EDIT)) {
                this.initState(false);
                this.actionConnect_actionPerformed(null);
                this.btSave.setEnabled(false);
            } else {
                this.initState(true);
                this.txtID.setEnabled(false);
                this.cmbType.setEnabled(false);
                this.btSave.setEnabled(true);
            }
        } else {
            this.upID = "";
            this.userResource = new UserResource();
            this.userSyncConfigMap = new HashMap();
            this.initState(true);
            this.btSave.setEnabled(true);
        }
    }

    public void onLoad() throws Exception {
        this.kDTable2.checkParsed();
        super.onLoad();
        this.btDefault.setVisible(false);
        this.state = this.getUIContext().get("USERSYNCSTATS").toString();
        this.map = (HashMap)this.getUIContext().get("USERSYNCHASHMAP");
        if (!this.state.equals(OprtState.ADDNEW)) {
            Iterator it = ((List)this.getUIContext().get("USERSYNCLIST")).iterator();
            if (it.hasNext()) {
                this.upID = it.next().toString();
            }
            this.userResource = (UserResource)this.map.get(this.upID);
        }
        this.init();
        this.initValue();
        this.initListen();
    }

    private void initListen() {
        this.initListen(this.txtID);
        this.initListen(this.txtURL);
        this.initListen(this.txtPort);
        this.initListen(this.txtUser);
        this.txtPW.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LdapSyncUI.this.changed();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LdapSyncUI.this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LdapSyncUI.this.changed();
            }
        });
        this.initListen(this.txtName);
        this.initListen(this.txtNumber);
        this.initListen(this.txtRe);
        this.initListen(this.txtSelect);
        this.TtxtPWDefault.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LdapSyncUI.this.changed();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LdapSyncUI.this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LdapSyncUI.this.changed();
            }
        });
        this.initListen(this.txtImport);
    }

    private void initListen(KDTextField kdt) {
        kdt.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LdapSyncUI.this.changed();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LdapSyncUI.this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LdapSyncUI.this.changed();
            }
        });
    }

    private void changed() {
        this.isCloseMag = true;
    }

    @Override
    public void actionSync_actionPerformed(ActionEvent e) throws Exception {
        super.actionSync_actionPerformed(e);
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                LdapSyncUI.this.state = OprtState.EDIT;
                LdapSyncUI.this.sync(null);
                return "";
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    private void sync(Object object) throws Exception {
        LdapClientUtil.init().sync(this.txtID.getText(), this.map, (IUIObject)this, object);
    }

    @Override
    protected void txtName_focusLost(FocusEvent e) throws Exception {
        super.txtName_focusLost(e);
        this.initReStr();
    }

    @Override
    protected void txtNumber_focusLost(FocusEvent e) throws Exception {
        super.txtNumber_focusLost(e);
        this.initReStr();
    }

    private void initReStr() {
        boolean isNumber = false;
        boolean isName = false;
        String number = this.txtNumber.getText().trim();
        String name = this.txtName.getText().trim();
        String str = "";
        if (StringUtils.isEmpty((String)number)) {
            isNumber = true;
        }
        if (StringUtils.isEmpty((String)name)) {
            isName = true;
        }
        if (!isNumber && !isName) {
            str = number + " ," + name;
        }
        if (isNumber || isName) {
            str = (number + name).trim();
        }
        this.txtRe.setText(str);
    }

    private void setMessage(String msg, boolean isWarn) {
        String url = "ldap://" + this.txtURL.getText() + ":" + this.txtPort.getText() + "/";
        if (isWarn) {
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"connecterror") + ": " + url));
        } else {
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"connectsuccess") + ": " + url));
        }
    }

    @Override
    public void actionConnect_actionPerformed(ActionEvent e) throws Exception {
        super.actionConnect_actionPerformed(e);
        this.initTree();
    }

    private void initType() {
        if (this.cmbType.getSelectedItem().toString().equals("database")) {
            this.btConn.setEnabled(false);
            this.btRefresh.setEnabled(false);
        } else {
            this.btConn.setEnabled(true);
            this.btRefresh.setEnabled(true);
        }
    }

    @Override
    protected void cmbClass_popupMenuWillBecomeInvisible(PopupMenuEvent e) throws Exception {
        super.cmbClass_popupMenuWillBecomeInvisible(e);
        this.changed();
    }

    @Override
    protected void cmbDN_popupMenuWillBecomeInvisible(PopupMenuEvent e) throws Exception {
        super.cmbDN_popupMenuWillBecomeInvisible(e);
        this.changed();
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        this.getUIContext().put("USERSYNCLIST", null);
        this.state = OprtState.ADDNEW;
        this.init();
        this.initValue();
        this.btSave.setEnabled(true);
        this.cmbType.setSelectedIndex(0);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.saveMap();
        IUserSyncHandleFacade iUser = UserSyncHandleFacadeFactory.getRemoteInstance();
        try {
            iUser.controlUserNode(this.map);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"savesuccess"));
            this.isCloseMag = false;
        }
        catch (BOSException e1) {
            this.isCloseMag = true;
        }
    }

    private void saveMap() throws Exception {
        this.isValidate();
        this.initState(false);
        if (this.state.equals(OprtState.ADDNEW)) {
            this.userResource = new UserResource();
        }
        UserResource ur = null;
        Map.Entry entry2 = null;
        String maxList = "";
        for (Map.Entry entry2 : this.map.entrySet()) {
            ur = (UserResource)this.map.get((String)entry2.getKey());
            if (!StringUtils.isEmpty((String)maxList) && Integer.parseInt(maxList) >= Integer.parseInt(ur.getResourceList())) continue;
            maxList = ur.getResourceList();
        }
        if (this.state.equals(OprtState.ADDNEW)) {
            this.userResource.setResourceList(String.valueOf(Integer.parseInt(maxList) + 1));
            this.upID = this.txtID.getText();
        } else {
            this.upID = this.txtID.getText();
            this.userResource = (UserResource)this.map.get(this.upID);
            this.userResource.initUserSyncConfigItemMap();
        }
        this.userResource.setResourceType(this.cmbType.getSelectedItem().toString());
        String str = this.classMap.toString();
        str = str.substring(str.lastIndexOf("{"), str.indexOf("}"));
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreElements()) {
            String temp = st.nextElement().toString();
            String temp1 = this.cmbClass.getSelectedItem().toString();
            if (temp1.equals(EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"com.kingdee.eas.cp.eip.sso.special.AbstractSyncUserIsvalidationDefault"))) {
                this.userResource.setSyncClass("com.kingdee.eas.cp.eip.sso.special.AbstractSyncUserIsvalidationDefault");
                continue;
            }
            if (temp1.equals(EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"com.kingdee.eas.cp.eip.sso.special.SyncUserIsvalidationDefaultPerson"))) {
                this.userResource.setSyncClass("com.kingdee.eas.cp.eip.sso.special.SyncUserIsvalidationDefaultPerson");
                continue;
            }
            this.userResource.setSyncClass(temp.substring(temp.indexOf("=") + 1, temp.trim().length()));
        }
        this.userResource.setUserID(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        this.userResource.setLastTime("");
        if (this.cmbType.getSelectedItem().toString().toLowerCase().equals("ldap")) {
            this.userResource.setAuthentication("simple");
            this.userResource.setContextFactory("com.sun.jndi.ldap.LdapCtxFactory");
            this.userResource.setCredentials(this.txtPW.getText());
            this.userResource.setPrincipal(this.txtUser.getText());
            this.userResource.setProviderURL("ldap://" + this.txtURL.getText() + ":" + this.txtPort.getText() + "/");
            this.userResource.setConDN(this.cmbDN.getSelectedItem().toString());
            this.userResource.setSyncImport(this.txtImport.getText());
            for (int i = 0; i < this.kDTable2.getRowCount(); ++i) {
                this.userResource.put(String.valueOf(i), this.setUserSyncConfigItem(this.kDTable2.getRow(i).getCell(0).getValue().toString()));
            }
        } else {
            this.userResource.setJndiName(this.txtURL.getText());
            this.userResource.put("1", this.setUserSyncConfigItem(this.txtID.getText()));
        }
        this.map.put(this.upID, this.userResource);
        this.btSave.setEnabled(false);
        this.setState(false);
    }

    private UserSyncConfigItem setUserSyncConfigItem(String dn) {
        UserSyncConfigItem userSyncConfigItem = new UserSyncConfigItem();
        this.userSyncConfigMap = new HashMap();
        userSyncConfigItem.setBaseDN(dn);
        userSyncConfigItem.setCountLimited(0);
        userSyncConfigItem.setDefaultPwd(this.TtxtPWDefault.getText());
        userSyncConfigItem.setExecutor("administrator");
        userSyncConfigItem.setFilter(this.txtSelect.getText());
        userSyncConfigItem.setLanguage("\u7b80\u4f53\u4e2d\u6587");
        userSyncConfigItem.setLastSync("");
        userSyncConfigItem.setLastSyncUbound("");
        userSyncConfigItem.setMapToEasUserName(this.txtName.getText());
        userSyncConfigItem.setMapToEasUserNumber(this.txtNumber.getText());
        userSyncConfigItem.setReturningAttributes(this.txtRe.getText());
        userSyncConfigItem.setSearchScope(2);
        userSyncConfigItem.setUsernameSuffix("_ldap");
        userSyncConfigItem.setUsernumber("1");
        return userSyncConfigItem;
    }

    @Override
    public void actionUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionUp_actionPerformed(e);
        this.state = OprtState.EDIT;
        this.initState(true);
        this.txtID.setEnabled(false);
        this.cmbType.setEnabled(false);
        this.btSave.setEnabled(true);
    }

    @Override
    public void actionDefault_actionPerformed(ActionEvent e) throws Exception {
        super.actionDefault_actionPerformed(e);
        this.initValue();
    }

    private void initTree() {
        try {
            LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    try {
                        LdapSyncUI.this.dirCtx = LdapServerUtil.init().initContext("ldap://" + LdapSyncUI.this.txtURL.getText() + ":" + LdapSyncUI.this.txtPort.getText() + "/", LdapSyncUI.this.txtUser.getText(), LdapSyncUI.this.txtPW.getText());
                        LdapSyncUI.this.rootNode = new DefaultKingdeeTreeNode((Object)LdapSyncUI.this.cmbDN.getSelectedItem().toString());
                        LdapSyncUI.this.baseDN = LdapSyncUI.this.cmbDN.getSelectedItem().toString();
                        LdapSyncUI.this.rootNode = LdapSyncUI.this.ldapClientUtil.initDefaultKingdeeTreeNode(LdapSyncUI.this.dirCtx, LdapSyncUI.this.baseDN, LdapSyncUI.this.rootNode);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        LdapSyncUI.this.tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)LdapSyncUI.this.rootNode));
                        LdapSyncUI.this.tree.setSelectionNode(LdapSyncUI.this.rootNode);
                    }
                    catch (RuntimeException e) {
                        LdapSyncUI.this.setMessage("", true);
                    }
                    return "";
                }

                public void afterExec(Object result) throws Exception {
                }
            });
            dialog.show();
        }
        catch (Exception e1) {
            logger.info((Object)e1);
        }
    }

    private void isUserPwd() {
        if (this.txtUser.getText() == null || this.txtUser.getText().trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"nameisnull"));
            this.txtUser.requestFocus();
            SysUtil.abort();
        }
        if (this.txtPW.getText() == null || this.txtPW.getText().trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"pwdisnull"));
            this.txtPW.requestFocus();
            SysUtil.abort();
        }
    }

    private void isValidate() throws Exception {
        if (this.txtID.getText() == null || this.txtID.getText().trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"resourceisnull"));
            this.txtID.requestFocus();
            SysUtil.abort();
        }
        if (this.cmbType.getSelectedItem().toString().toLowerCase().equals("database")) {
            if (this.txtURL.getText() == null || this.txtURL.getText().trim().length() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"jndinameisnull"));
                this.txtURL.requestFocus();
                SysUtil.abort();
            }
        } else {
            if (this.txtURL.getText() == null || this.txtURL.getText().trim().length() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"lanaddressisnull"));
                this.txtURL.requestFocus();
                SysUtil.abort();
            }
            if (this.txtPort.getText() == null || this.txtPort.getText().trim().length() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"portisnull"));
                this.txtPort.requestFocus();
                SysUtil.abort();
            }
            if (this.cmbDN.getItemCount() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"condnisnull"));
                this.cmbDN.requestFocus();
                SysUtil.abort();
            }
            this.isUserPwd();
            if (this.kDTable2.getRowCount() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"basednisnull"));
                this.txtURL.requestFocus();
                SysUtil.abort();
            }
        }
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"mapnumberisnull"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (this.txtName.getText() == null || this.txtName.getText().trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"mapnameisnull"));
            this.txtName.requestFocus();
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.cmbClass.getSelectedItem().toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"syncclass"));
            this.cmbClass.requestFocus();
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.TtxtPWDefault.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"rpwdisnull"));
            this.TtxtPWDefault.requestFocus();
            SysUtil.abort();
        }
        if (this.state.equals(OprtState.ADDNEW) && this.map.containsKey(this.txtID.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"beingresource"));
            this.txtID.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    protected void cmbType_popupMenuWillBecomeInvisible(PopupMenuEvent e) throws Exception {
        super.cmbType_popupMenuWillBecomeInvisible(e);
        this.changed();
        if (this.cmbType.getSelectedItem().toString().equals("database")) {
            this.txtName.setText("FName_L2");
            this.txtNumber.setText("FNumber");
            this.txtRe.setText("FNumber,FName_L2");
            this.txtSelect.setText("FCreateTime >= ? and FCreateTime <= ?");
            this.txtImport.setText("");
        } else {
            this.txtName.setText("displayName");
            this.txtNumber.setText("sAMAccountName");
            this.txtRe.setText("sAMAccountName,displayName");
            this.txtSelect.setText("(&(objectClass=person)(objectClass=user)(whenCreated>={0}))");
            this.txtImport.setText("com.kingdee.eas.cp.eip.sso.ldapAdapter.XMLUtil");
        }
        this.ldap2Database(false);
        this.initType();
    }

    @Override
    public void actionExpor_actionPerformed(ActionEvent e) throws Exception {
        super.actionExpor_actionPerformed(e);
        this.path = LdapClientUtil.init().filePath((Component)((Object)this), false).trim();
        if (!StringUtils.isEmpty((String)this.path)) {
            LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    LdapClientUtil.init().exportXML(LdapSyncUI.this.path, LdapSyncUI.this.map, LdapSyncUI.this.txtID.getText());
                    return "";
                }

                public void afterExec(Object result) throws Exception {
                }
            });
            dialog.show();
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        super.actionImport_actionPerformed(e);
        this.path = LdapClientUtil.init().filePath((Component)((Object)this), true).trim();
        if (!StringUtils.isEmpty((String)this.path)) {
            LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    LdapSyncUI.this.state = OprtState.EDIT;
                    LdapSyncUI.this.sync(LdapClientUtil.init().importXML(LdapSyncUI.this.path));
                    return "";
                }

                public void afterExec(Object result) throws Exception {
                }
            });
            dialog.show();
        }
    }

    @Override
    protected void btGetDN_actionPerformed(ActionEvent e) throws Exception {
        super.btGetDN_actionPerformed(e);
        this.initDN();
    }

    @Override
    protected void btLeft_actionPerformed(ActionEvent e) throws Exception {
        super.btLeft_actionPerformed(e);
        Iterator it = ListLF.init().getSelctList(this.kDTable2).iterator();
        while (it.hasNext()) {
            this.kDTable2.removeRow(Integer.parseInt(it.next().toString()));
        }
    }

    @Override
    protected void btRight_actionPerformed(ActionEvent e) throws Exception {
        super.btRight_actionPerformed(e);
        SearchResult getresult = null;
        IRow row = null;
        String dn = "";
        TreePath[] selectedPath = this.tree.getSelectionPaths();
        if (selectedPath == null) {
            return;
        }
        for (int i = 0; i < selectedPath.length; ++i) {
            DefaultKingdeeTreeNode tmp = (DefaultKingdeeTreeNode)selectedPath[i].getLastPathComponent();
            if (tmp.getUserObject() instanceof String) {
                dn = tmp.getUserObject().toString();
            } else {
                getresult = (SearchResult)tmp.getUserObject();
                dn = LdapExtendUtil.init().updateDN(getresult.getAttributes().get("distinguishedName").toString());
            }
            row = this.kDTable2.addRow();
            row.getCell(0).setValue((Object)dn);
        }
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.isCloseMag) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.saveMap();
                    return true;
                }
                catch (Exception e) {
                    this.handleException(e);
                    return false;
                }
            }
            return result == 1;
        }
        return true;
    }

    @Override
    public Map submitFlow(Map context) throws Exception {
        return null;
    }

    @Override
    public Map initFlowUI(Map context) throws Exception {
        return null;
    }
}

