/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.cp.eip.sso.SSOFlowFacadeFactory;
import com.kingdee.eas.cp.eip.sso.client.AbstractSSOLdapConfigUI;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.IFlowUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SSOLdapConfigUI
extends AbstractSSOLdapConfigUI
implements IFlowUI {
    private static final Logger logger = CoreUIObject.getLogger(SSOLdapConfigUI.class);

    @Override
    public Map submitFlow(Map context) throws Exception {
        String strIP = this.txtIP.getText();
        String strPort = this.txtPort.getText();
        HashMap<String, String> map = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)strIP)) {
            map.put("ldapHost", strIP);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ssoldapipnull"));
            SysUtil.abort();
        }
        if (!StringUtils.isEmpty((String)strPort)) {
            map.put("ldapPort", strPort);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ssoldapportnull"));
            SysUtil.abort();
        }
        if (!this.ipValid(strIP)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ssoldapipsuccess"));
            SysUtil.abort();
        }
        if (!this.isDigit(strPort)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ssoldapportasuccess"));
            SysUtil.abort();
        }
        SSOFlowFacadeFactory.getRemoteInstance().setLDAPProperty(map);
        return null;
    }

    private boolean isDigit(String str) {
        return str.matches("[0-9]*");
    }

    private boolean ipValid(String s) {
        String regex0 = "(2[0-4]\\d)|(25[0-5])";
        String regex1 = "1\\d{2}";
        String regex2 = "[1-9]\\d";
        String regex3 = "\\d";
        String regex = "(" + regex0 + ")|(" + regex1 + ")|(" + regex2 + ")|(" + regex3 + ")";
        regex = "(" + regex + ").(" + regex + ").(" + regex + ").(" + regex + ")";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(s);
        return m.matches();
    }

    @Override
    public Map initFlowUI(Map context) throws Exception {
        HashMap map = (HashMap)SSOFlowFacadeFactory.getRemoteInstance().getLDAPProperty();
        if (map.containsKey("ldapHost")) {
            this.txtIP.setText((String)map.get("ldapHost"));
        }
        if (map.containsKey("ldapPort")) {
            this.txtPort.setText((String)map.get("ldapPort"));
        }
        return null;
    }
}

