/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.cp.eip.sso.IUserSyncHandleFacade;
import com.kingdee.eas.cp.eip.sso.UserSyncHandleFacadeFactory;
import com.kingdee.eas.cp.eip.sso.client.AbstractUserControlSyncListUI;
import com.kingdee.eas.cp.eip.sso.client.UserSyncMapListUI;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapClientUtil;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapExtendUtil;
import com.kingdee.eas.cp.eip.sso.user.UserResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserControlSyncListUI
extends AbstractUserControlSyncListUI {
    private static final Logger logger = CoreUIObject.getLogger(UserControlSyncListUI.class);
    public static final String USER_SYNC_RESOURCE = "com.kingdee.eas.cp.eip.sso.UserSyncResource";
    private int maxRList = 0;
    private HashMap map;
    private String maxValue = "";
    private String path = "";
    private String keyStr = "";
    public static final String STATS = "USERSYNCSTATS";
    public static final String USERSYNCLIST = "USERSYNCLIST";
    public static final String USERSYNCHASHMAP = "USERSYNCHASHMAP";
    public static final String MAXVALUE = "maxValue";
    public static final String USERSYNCHASMAX = "USERSYNCHASMAX";
    private HashMap tempMap = null;
    private String key = "";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTable1.getSelectManager().setSelectMode(2);
        this.kDTable1.checkParsed();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnUpdate.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnPhase.setIcon(EASResource.getIcon((String)"imgTbtn_synchronization"));
        this.btCleanTime.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.btCleanEasData.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnTestConnect.setIcon(EASResource.getIcon((String)"imgTbtn_testdatacenterdatabank"));
        this.initTable();
    }

    private void initTable() throws UIException {
        int k;
        this.kDTable1.removeRows();
        try {
            IUserSyncHandleFacade iUserSyncHandleFacade = UserSyncHandleFacadeFactory.getRemoteInstance();
            this.map = iUserSyncHandleFacade.getAllUserNode();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        this.tempMap = this.map;
        this.getUIContext().put(USERSYNCHASHMAP, this.tempMap);
        Iterator it = this.map.entrySet().iterator();
        Map.Entry entry = null;
        UserResource userResource = null;
        int num = this.map.size();
        UserResource[] usercol = new UserResource[num];
        String[] strkeycol = new String[num];
        String key = null;
        int i = 0;
        while (it.hasNext()) {
            entry = it.next();
            usercol[i] = (UserResource)entry.getValue();
            strkeycol[i] = entry.getKey().toString();
            ++i;
        }
        for (k = 0; k < num; ++k) {
            for (int m = 0; m < k; ++m) {
                if (Integer.parseInt(usercol[k].getResourceList().toString()) <= Integer.parseInt(usercol[m].getResourceList().toString())) continue;
                userResource = usercol[k];
                usercol[k] = usercol[m];
                usercol[m] = userResource;
                key = strkeycol[k];
                strkeycol[k] = strkeycol[m];
                strkeycol[m] = key;
            }
        }
        this.maxValue = String.valueOf(usercol.length);
        for (k = 0; k < usercol.length; ++k) {
            userResource = usercol[k];
            IRow row = this.kDTable1.addRow();
            row.getCell(0).setValue((Object)strkeycol[k]);
            row.getCell(1).setValue((Object)userResource.getResourceType());
            if (!StringUtils.isEmpty((String)userResource.getJndiName())) {
                row.getCell(2).setValue((Object)userResource.getJndiName());
            } else {
                row.getCell(2).setValue((Object)userResource.getProviderURL());
            }
            row.getCell(3).setValue((Object)userResource.getLastTime());
        }
        this.kDTable1.getSelectManager().setSelectMode(2);
        this.kDTable1.setRowCount(this.map.size());
        this.kDTable1.checkParsed();
    }

    private List getIDList(String str) {
        ArrayList<String> list = new ArrayList<String>();
        KDTSelectBlock sb = this.kDTable1.getSelectManager().get();
        if (sb != null && sb.size() != 0) {
            list.add(this.kDTable1.getRow(sb.getTop()).getCell(str).getValue().toString());
        }
        return list;
    }

    @Override
    protected void kDTable1_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() != 0) {
            this.actionView_actionPerformed(null);
        }
    }

    private void openEditUI(HashMap ctx) throws UIException {
        ctx.put(MAXVALUE, this.maxValue);
        ctx.put(USERSYNCHASHMAP, this.map);
        ctx.put("Owner", this);
        ctx.put(USERSYNCHASMAX, String.valueOf(this.maxRList));
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow currOrgTreeDialog = uiFactory.create("com.kingdee.eas.cp.eip.sso.client.LdapSyncEditUI", (Map)ctx);
        currOrgTreeDialog.show();
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put(STATS, OprtState.ADDNEW);
        this.openEditUI(ctx);
        this.onLoad();
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        List list = this.getIDList("id");
        if (list.size() != 0) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)USER_SYNC_RESOURCE, (String)"realdelete")) == 0) {
                for (Object ob : list) {
                    if (!this.tempMap.containsKey(ob.toString())) continue;
                    this.tempMap.remove(ob);
                    this.controlMap(this.tempMap);
                }
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)USER_SYNC_RESOURCE, (String)"pleaseSelectRow"));
        }
        this.onLoad();
    }

    private void controlMap(HashMap map) {
        try {
            IUserSyncHandleFacade iUser = UserSyncHandleFacadeFactory.getRemoteInstance();
            iUser.controlUserNode(map);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    @Override
    public void actionPhase_actionPerformed(ActionEvent e) throws Exception {
        this.getKey();
        this.sync(null);
        this.onLoad();
    }

    private void getKey() throws Exception {
        List list = this.getIDList("id");
        if (list.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)USER_SYNC_RESOURCE, (String)"pleaseSelectRow"));
            SysUtil.abort();
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.key = it.next().toString();
        }
    }

    private void sync(Object object) throws Exception {
        LdapClientUtil.init().sync(this.key, this.map, (IUIObject)this, object);
    }

    @Override
    public void actionUpdate_actionPerformed(ActionEvent e) throws Exception {
        List list = this.getIDList("id");
        if (list.size() != 0) {
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put(STATS, OprtState.EDIT);
            ctx.put(USERSYNCLIST, list);
            this.openEditUI(ctx);
            this.onLoad();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)USER_SYNC_RESOURCE, (String)"pleaseSelectRow"));
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
        if (this.getIDList("id").size() != 0) {
            this.getUIContext().put(STATS, OprtState.VIEW);
            this.getUIContext().put(USERSYNCLIST, this.getIDList("id"));
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put(STATS, OprtState.VIEW);
            ctx.put(USERSYNCLIST, this.getIDList("id"));
            this.openEditUI(ctx);
            this.initTable();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)USER_SYNC_RESOURCE, (String)"pleaseSelectRow"));
        }
    }

    @Override
    public void actionExternalUserMap_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UserSyncMapListUI.class.getName(), this.getUIContext(), null, null);
        uiWindow.show();
    }

    @Override
    public void actionTestConnect_actionPerformed(ActionEvent e) throws Exception {
        String resType = "";
        List list = this.getIDList("rtype");
        if (list.size() == 1) {
            resType = list.get(0).toString();
            IUserSyncHandleFacade iushFace = UserSyncHandleFacadeFactory.getRemoteInstance();
            boolean synTag = iushFace.testConnect(resType, this.getIDList("id").get(0).toString());
            if (synTag) {
                MsgBox.showInfo((String)EASResource.getString((String)USER_SYNC_RESOURCE, (String)"connectionsuccess"));
                this.btnPhase.setEnabled(true);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)USER_SYNC_RESOURCE, (String)"connectionlost"));
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)USER_SYNC_RESOURCE, (String)"pleaseSelectRow"));
        }
    }

    @Override
    public void actionCleanTime_actionPerformed(ActionEvent e) throws Exception {
        super.actionCleanTime_actionPerformed(e);
        List list = this.getIDList("id");
        if (list.size() != 0) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)USER_SYNC_RESOURCE, (String)"cleantime")) == 0) {
                LdapClientUtil.init().cleanTime(this.map, LdapClientUtil.init().getListSelectID(this.kDTable1), "");
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)USER_SYNC_RESOURCE, (String)"pleaseSelectRow"));
        }
        this.onLoad();
    }

    @Override
    public void actionCleanEasData_actionPerformed(ActionEvent e) throws Exception {
        super.actionCleanEasData_actionPerformed(e);
        LdapExtendUtil.init().setHashMap(this.map, "");
        if (MsgBox.showConfirm2((String)EASResource.getString((String)USER_SYNC_RESOURCE, (String)"cleandata")) == 0) {
            MsgBox.showInfo((String)(EASResource.getString((String)USER_SYNC_RESOURCE, (String)"cleandatacount") + " " + UserSyncHandleFacadeFactory.getRemoteInstance().cleanSyncEasData(this.map) + " " + EASResource.getString((String)USER_SYNC_RESOURCE, (String)"phitem") + "\uff01"));
        }
        this.onLoad();
    }

    @Override
    public void actionExpor_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionExpor_actionPerformed(arg0);
        this.keyStr = LdapClientUtil.init().getListSelectID(this.kDTable1).trim();
        if (StringUtils.isEmpty((String)this.keyStr)) {
            return;
        }
        this.path = LdapClientUtil.init().filePath((Component)((Object)this), true).trim();
        if ("$CANCEL_OPTION$".equals(this.path)) {
            return;
        }
        boolean isEmpty = StringUtils.isEmpty((String)this.path);
        this.path = this.path + ".xml";
        File file = new File(this.path);
        if (isEmpty || !file.exists() && !file.createNewFile()) {
            MsgBox.showError((String)EASResource.getString((String)USER_SYNC_RESOURCE, (String)"FileNotExist_Error"));
            this.abort();
        } else {
            LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    LdapClientUtil.init().exportXML(UserControlSyncListUI.this.path, UserControlSyncListUI.this.map, UserControlSyncListUI.this.keyStr);
                    return "";
                }

                public void afterExec(Object result) throws Exception {
                }
            });
            dialog.show();
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionImport_actionPerformed(arg0);
        this.getKey();
        this.path = LdapClientUtil.init().filePath((Component)((Object)this), true).trim();
        if ("$CANCEL_OPTION$".equals(this.path)) {
            return;
        }
        if (StringUtils.isEmpty((String)this.path) || !new File(this.path).exists()) {
            MsgBox.showError((String)EASResource.getString((String)USER_SYNC_RESOURCE, (String)"FileNotExist_Error"));
            this.abort();
        } else {
            LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    UserControlSyncListUI.this.sync(LdapClientUtil.init().importXML(UserControlSyncListUI.this.path));
                    return "";
                }

                public void afterExec(Object result) throws Exception {
                }
            });
            dialog.show();
        }
    }
}

