/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.kdCloud;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.UserContextCallback;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ErpUserStatusEnum;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.base.uiframe.gzh.util.HashHmacCrypto;
import com.kingdee.eas.cp.eip.sso.AbstractEasAuthHandler;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class KingdeeCloudAuthHandler
extends AbstractEasAuthHandler {
    private static Logger logger = Logger.getLogger((String)KingdeeCloudAuthHandler.class.getName());

    @Override
    public boolean authenticate(UserContextCallback userCtxCallback, String userNumber, String password) throws BOSLoginException {
        try {
            ErpUserStatusEnum statu;
            Context ctx = userCtxCallback.getUserContext();
            String sql = "select fnumber,fcell,femail from t_pm_user where fnumber = ?";
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{ctx.getUserName()});
            if (result.next() && ErpUserStatusEnum.NOT_ACTIVATED.equals((Object)(statu = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getErpUserStatus(result.getString("fnumber"), result.getString("fcell"), result.getString("femail"))))) {
                return true;
            }
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("username", userNumber);
            params.put("password", password);
            HttpGet httpGet = new HttpGet(EasCloud.AUTH_USER_ACCESSTOKEN_URL + "?" + this.concatUrl(params));
            String timeStamp = String.valueOf(new Date().getTime() / 1000L);
            String nonce = UUID.randomUUID().toString().replace("-", "");
            httpGet.addHeader("X-Api-ClientID", EasCloud.CLIENT_ID);
            httpGet.addHeader("X-Api-Auth-Version", "2.0");
            httpGet.addHeader("X-Api-TimeStamp", timeStamp);
            httpGet.addHeader("X-Api-SignHeaders", "X-Api-TimeStamp,X-Api-Nonce");
            httpGet.addHeader("X-Api-Nonce", nonce);
            TreeMap<String, String> signatureMap = new TreeMap<String, String>();
            signatureMap.put("X-Api-Nonce", nonce);
            signatureMap.put("X-Api-TimeStamp", timeStamp);
            String signature = HashHmacCrypto.sign((String)"GET", (String)"/auth/user/access_token", params, signatureMap, (String)EasCloud.CLIENT_SECRET);
            httpGet.addHeader("X-Api-Signature", signature.replaceAll(System.getProperty("line.separator"), ""));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(1500).setSocketTimeout(1500).build();
            httpGet.setConfig(requestConfig);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity responseEntity = response.getEntity();
            JSONObject rs = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)responseEntity));
            if ("0".equalsIgnoreCase(rs.getString("errcode"))) {
                return true;
            }
            throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
        }
        catch (UserException e) {
            logger.error((Object)e);
            throw new BOSLoginException((Throwable)e);
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)e);
            String format = EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.web.auth.LoginFrameResxResource", (String)"NETWORK_TIMEOUT");
            throw new BOSLoginException(MessageFormat.format(format, "api.kingdee.com"));
        }
        catch (Exception e) {
            logger.error((Object)e);
            String format = EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.web.auth.LoginFrameResxResource", (String)"NETWORK_ERROR");
            throw new BOSLoginException(MessageFormat.format(format, "api.kingdee.com"));
        }
    }

    @Override
    public String getEasUserNumber(Context ctx, String externalUserNumber) throws BOSLoginException {
        String number;
        block5: {
            number = null;
            IRowSet rs = null;
            try {
                String sql = "select fnumber,fcell,femail from t_pm_user where fcell = ? or femail =?";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{externalUserNumber, externalUserNumber});
                if (rs != null && rs.next()) {
                    number = rs.getString(1);
                    ErpUserStatusEnum status = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getErpUserStatus(rs.getString("fnumber"), rs.getString("fcell"), rs.getString("femail"));
                    if (ErpUserStatusEnum.NOT_ENABLED.equals((Object)status)) {
                        throw new UserException(UserException.CLOUDUSER_FORBIDDEN);
                    }
                    if (ErpUserStatusEnum.NO_CLOUND_PASSPORT.equals((Object)status)) {
                        throw new UserException(UserException.CLOUDUSER_NREGISTER);
                    }
                    break block5;
                }
                throw new UserException(UserException.USER_NOT_EXIST);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSLoginException((Throwable)e);
            }
        }
        return number;
    }

    private String concatUrl(TreeMap<String, String> parameters) throws UnsupportedEncodingException {
        StringBuffer params = new StringBuffer();
        for (Map.Entry<String, String> element : parameters.entrySet()) {
            params.append(element.getKey());
            params.append("=");
            params.append(URLEncoder.encode(element.getValue(), "utf-8"));
            params.append("&");
        }
        int iLen = params.length();
        if (iLen > 0) {
            params = params.deleteCharAt(iLen - 1);
        }
        return params.toString();
    }
}

