/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.ldapAdapter;

import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapServerUtil;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigParseException;
import com.kingdee.eas.cp.eip.sso.user.XmlUtils;
import com.kingdee.eas.cp.eip.sso.xml.INode;
import com.kingdee.eas.cp.eip.sso.xml.NodeFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractXML {
    private Logger logger = Logger.getLogger(AbstractXML.class);
    protected FileOutputStream fileos = null;
    protected File fw = null;
    protected BufferedInputStream bis = null;
    protected static final String TABNUM_ZOE = "0";
    protected static final String TABNUM_ONE = "1";
    protected static final String TABNUM_TWO = "2";
    protected static final String TABNUM_THR = "3";
    protected static final String TABNUM_FOU = "4";
    protected static final String TABNUM_FIV = "5";
    protected static final String TABNUM_SIX = "6";
    protected static final String SEALSIGN_ON = "SEALSIGN_ON";
    protected static final String SEALSIGN_OFF = "SEALSIGN_OFF";

    protected String getPath(String path, String fileName) {
        return path + File.separator + fileName;
    }

    protected File getFile(String fileName) throws IOException {
        this.fw = new File(LdapServerUtil.init().getPath(fileName));
        if (!this.fw.exists()) {
            this.newXmlFile(LdapServerUtil.init().getPath(fileName));
        } else if (this.fw.length() == 0L) {
            this.newXmlFile(LdapServerUtil.init().getPath(fileName));
        }
        return this.fw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newXmlFile(String fileName) {
        FileOutputStream fileos1 = null;
        try {
            fileos1 = new FileOutputStream(this.fw);
            String charset = "UTF-8";
            String xmlHeader = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n";
            fileos1.write(xmlHeader.getBytes(charset));
            fileos1.write("<config>\r\n".getBytes(charset));
            fileos1.write("</config>".getBytes(charset));
        }
        catch (FileNotFoundException e) {
            this.logger.info((Object)e);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.info((Object)e);
        }
        catch (IOException e) {
            this.logger.info((Object)e);
        }
        finally {
            try {
                if (fileos1 != null) {
                    fileos1.flush();
                    fileos1.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected FileOutputStream getPrintWriter(String fileName) throws IOException {
        this.fileos = new FileOutputStream(this.getFile(fileName));
        return this.fileos;
    }

    protected void close() throws IOException {
        if (this.fileos != null) {
            this.fileos.flush();
            this.fileos.close();
        }
        if (this.bis != null) {
            this.bis.close();
        }
    }

    protected INode[] getChildNodes(INode node, String name) {
        ArrayList<INode> result = new ArrayList<INode>();
        for (INode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(name)) continue;
            result.add(child);
        }
        return result.toArray(new INode[result.size()]);
    }

    protected INode initTree(String fileName) throws IOException, UserSyncConfigParseException {
        try {
            this.bis = new BufferedInputStream(new FileInputStream(this.getFile(fileName)));
        }
        catch (IOException e) {
            this.logger.info((Object)("LdapMapEASConfig file is wrong!" + e));
            throw e;
        }
        INode root = null;
        try {
            root = NodeFactory.build(this.bis);
        }
        catch (IOException e) {
            throw new UserSyncConfigParseException("Invalidate LdapDN config file.expected:<" + fileName + ">", e);
        }
        if (root == null) {
            throw new UserSyncConfigParseException("Invalidate LdapDN config file.expected:<" + fileName + ">");
        }
        return root;
    }

    protected StringBuffer initBlank(StringBuffer sb, String tabNum) {
        int num = 0;
        try {
            num = Integer.parseInt(tabNum);
        }
        catch (NumberFormatException e) {
            this.logger.info((Object)("initNodeOne parameter error" + e));
            throw e;
        }
        for (int i = 0; i < num * 4; ++i) {
            sb.append(" ");
        }
        return sb;
    }

    protected String initNodeOne(String nodeName, Map map, String tabNum, String sealSign) {
        StringBuffer sb = new StringBuffer();
        if (map != null && map.size() != 0) {
            this.initBlank(sb, tabNum);
            sb.append("<" + nodeName + " ");
            Iterator it = map.entrySet().iterator();
            Map.Entry entry = null;
            while (it.hasNext()) {
                entry = it.next();
                sb.append(entry.getKey());
                sb.append("=\"");
                sb.append(entry.getValue() + "\" ");
            }
            if (sealSign.equals(SEALSIGN_ON)) {
                sb.append("/>\r\n");
            } else {
                sb.append(">\r\n");
            }
        }
        return sb.toString();
    }

    protected String initNodeSeal(String nodeName, String tabNum) {
        StringBuffer sb = new StringBuffer();
        this.initBlank(sb, tabNum);
        sb.append("</" + nodeName + ">\r\n");
        return sb.toString();
    }

    protected String initNodeTwo(String nodeName, String nodeValue, String tabNum, String sealSign) {
        StringBuffer sb = new StringBuffer();
        this.initBlank(sb, tabNum);
        sb.append("<" + nodeName + ">");
        sb.append(XmlUtils.encodedXmlData(nodeValue));
        if (sealSign.equals(SEALSIGN_ON)) {
            sb.append("</" + nodeName + ">");
        }
        sb.append("\r\n");
        return sb.toString();
    }

    protected Map initNameOrValue(String nameValue, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (nameValue != null && nameValue.length() != 0) {
            map.put("name", nameValue);
        }
        if (value != null && value.length() != 0) {
            map.put("value", value);
        }
        return map;
    }

    protected void writeXML(String str, Object file) throws IOException {
        String charset = "UTF-8";
        String xmlHeader = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n";
        if (file instanceof FileOutputStream) {
            this.fileos = (FileOutputStream)file;
        } else if (file instanceof String) {
            this.fileos = this.getPrintWriter(file.toString());
        }
        this.fileos.write(xmlHeader.getBytes(charset));
        this.fileos.write("<config>\r\n".getBytes(charset));
        byte[] outBytes = str.getBytes(charset);
        int bufSize = 4096;
        int start = 0;
        int len = bufSize;
        int i = 1;
        while (start < outBytes.length) {
            if (start + len > outBytes.length) {
                len = outBytes.length - start;
            }
            this.fileos.write(outBytes, start, len);
            start = bufSize * (++i - 1);
        }
        this.fileos.write("</config>".getBytes(charset));
        this.close();
    }

    public abstract Object readXML() throws UserSyncConfigParseException, IOException;

    protected abstract HashMap buildInfo(INode var1) throws UserSyncConfigParseException;

    protected abstract String initNodeString(Object var1) throws IOException;

    public abstract void write(Object var1) throws IOException;
}

