/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.qrcode.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.cp.eip.sso.qrcode.exception.AjaxException;
import com.kingdee.eas.cp.eip.sso.qrcode.exception.AppAuth2Exception;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.Ajax;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.QrCodeTokenHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppAuth2 {
    private static final Logger logger = LoggerFactory.getLogger(AppAuth2.class);

    private static String appAuth2Treaty(String appid, String appSecret) throws UnsupportedEncodingException {
        String authorization = "OpenAuth2 version=\"%s\", appid=\"%s\", timestamp=%d, nonce=\"%s\", sign=\"%s\"";
        String version = "1.1";
        appid = URLEncoder.encode(appid, "UTF-8");
        long timestamp = System.currentTimeMillis();
        String nonce = URLEncoder.encode(UUID.randomUUID().toString(), "UTF-8");
        String sign = AppAuth2.shaHex(version, appid, String.valueOf(timestamp), nonce, appSecret);
        sign = URLEncoder.encode(sign, "UTF-8");
        authorization = String.format(authorization, version, appid, timestamp, nonce, sign);
        return authorization;
    }

    private static String shaHex(String ... data) {
        Arrays.sort(data);
        String join = StringUtils.join((Object[])data);
        String sign = DigestUtils.shaHex((String)join);
        return sign;
    }

    private static String getAuthorizationHeader() throws AppAuth2Exception {
        String authorization = "";
        try {
            authorization = AppAuth2.appAuth2Treaty(QrCodeTokenHelper.getAppID(), QrCodeTokenHelper.getAppSecret());
        }
        catch (UnsupportedEncodingException e) {
            AppAuth2Exception aa2e = new AppAuth2Exception("Get Authorization Header : Unsupport charset Exception");
            aa2e.initCause(e);
            throw aa2e;
        }
        return authorization;
    }

    public static String getAccess_token() throws AppAuth2Exception {
        HttpGet get = new HttpGet(QrCodeTokenHelper.getAuthURL());
        String authorization = AppAuth2.getAuthorizationHeader();
        get.setHeader("authorization", authorization);
        String response = null;
        try {
            response = Ajax.exceuteRequest((HttpRequestBase)get, "utf-8");
        }
        catch (AjaxException e) {
            AppAuth2Exception aa2e = new AppAuth2Exception("Oauth App identity Exception");
            logger.error(aa2e.getMessage());
            throw aa2e;
        }
        if (response == null || response.trim().length() <= 0) {
            return null;
        }
        JSONObject ret = (JSONObject)JSON.parse((String)response);
        JSONObject data = (JSONObject)ret.get((Object)"data");
        String access_token = (String)data.get((Object)"access_token");
        return access_token;
    }
}

