/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.special;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.ISyncUserInitItem;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.SyncUserItem;
import com.kingdee.eas.cp.eip.sso.special.AbstractSyncUserIsvalidationDefault;
import com.kingdee.eas.cp.eip.sso.user.IDatasourceUtil;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import org.apache.log4j.Logger;

public class SyncUserIsvalidationHD
extends AbstractSyncUserIsvalidationDefault
implements ISyncUserInitItem {
    private static Logger logger = Logger.getLogger((String)SyncUserIsvalidationHD.class.getName());

    @Override
    public SyncUserItem initItem(IDatasourceUtil dsUtil, UserSyncConfigItem syncConfigItem) {
        SyncUserItem item = super.initItem(dsUtil, syncConfigItem);
        String userState = "";
        userState = dsUtil.getUserProperty("accountstatus") == null ? "0" : dsUtil.getUserProperty("accountstatus");
        String[] property = new String[]{userState};
        item.setProperty(property);
        return item;
    }

    @Override
    public void executeItem(Context ctx, SyncUserItem suItem) {
        super.executeItem(ctx, suItem);
        try {
            IUser iu = UserFactory.getLocalInstance((Context)ctx);
            String userState = suItem.getProperty()[0];
            String userNumber = suItem.getUserNumber();
            UserInfo userInfo = iu.getUser(userNumber);
            if (userInfo == null) {
                return;
            }
            IObjectPK[] pk = new IObjectPK[]{new ObjectUuidPK(BOSUuid.read((String)userInfo.getId().toString()))};
            if (StringUtils.isEmpty((String)userState)) {
                iu.forbidUsers(pk, true);
            } else if (userState.equals("1")) {
                iu.forbidUsers(pk, false);
            } else {
                iu.forbidUsers(pk, true);
            }
        }
        catch (EASBizException e) {
            logger.info((Object)e);
        }
        catch (BOSException e) {
            logger.info((Object)e);
        }
        catch (UuidException e) {
            logger.info((Object)e);
        }
    }
}

