/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.JobCollection;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.LdapMappingFactory;
import com.kingdee.eas.cp.eip.sso.LdapMappingInfo;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.ILdapProject;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapControlInfo;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapPreceptInfo;
import com.kingdee.eas.cp.eip.sso.user.PasswordUtils;
import com.kingdee.eas.cp.eip.sso.user.UserResource;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigItem;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigManager;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigParseException;
import com.kingdee.eas.cp.eip.sso.util.EASConfigManagerUtil;
import com.kingdee.eas.cp.eip.sso.util.EasToLdapType;
import com.kingdee.eas.cp.eip.sso.util.LdapConfigManagerUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAPProject
implements ILdapProject {
    private static HashMap ldapProject;
    private static HashMap easProject;

    public LDAPProject() {
        ldapProject = new HashMap();
        easProject = new HashMap();
    }

    @Override
    public void useLdapProject(Context ctx, String strConnect) {
        HashMap<String, String> userMap = new HashMap<String, String>();
        HashMap<String, String> roleMap = new HashMap<String, String>();
        HashMap<String, String> orgMap = new HashMap<String, String>();
        HashMap<String, String> ldapUserMap = new HashMap<String, String>();
        HashMap<String, String> ldapRoleMap = new HashMap<String, String>();
        HashMap<String, String> ldapPositionMap = new HashMap<String, String>();
        HashMap<String, String> ldapOrgMap = new HashMap<String, String>();
        LdapControlInfo ldapControlInfoUser = null;
        LdapControlInfo ldapControlInfoOrg = null;
        LdapControlInfo ldapControlInfoRole = null;
        LdapControlInfo ldapControlInfoPosition = null;
        String naming = null;
        LdapControlInfo ldapControlInfo = null;
        String strDN = null;
        Map.Entry entry22 = null;
        HashMap map = null;
        Iterator it = null;
        try {
            String flagStr;
            InitialDirContext dirCtx = null;
            NamingEnumeration<SearchResult> namingEnum = null;
            SearchResult searchResult = null;
            UserResource ldapResx = UserSyncConfigManager.get(strConnect);
            Hashtable<String, String> env = new Hashtable<String, String>(11);
            env.put("java.naming.factory.initial", ldapResx.getContextFactory());
            env.put("java.naming.provider.url", ldapResx.getProviderURL());
            env.put("java.naming.security.authentication", ldapResx.getAuthentication());
            env.put("java.naming.security.principal", ldapResx.getPrincipal());
            String pwd = ldapResx.getCredentials();
            if (pwd != null && pwd.startsWith(flagStr = "encrypt:")) {
                int idx = flagStr.length();
                pwd = pwd.substring(idx);
                pwd = PasswordUtils.decodePassword(ldapResx.getPrincipal(), pwd);
            }
            env.put("java.naming.security.credentials", pwd);
            dirCtx = new InitialDirContext(env);
            HashMap syncConfigItemsMap = ldapResx.getUserSyncConfigItemMap();
            Iterator itemIte = syncConfigItemsMap.entrySet().iterator();
            while (itemIte.hasNext()) {
                UserSyncConfigItem configItem = (UserSyncConfigItem)itemIte.next().getValue();
                String baseDN = configItem.getBaseDN();
                String filterExp = configItem.getFilter();
                Object[] filterParam = new Object[]{"19900101010101.0Z", "19900101010101.0Z"};
                String returnAttr = configItem.getReturningAttributes();
                if (returnAttr == null || "".equals(returnAttr)) {
                    returnAttr = configItem.getMapToEasUserName() + "," + configItem.getMapToEasUserNumber();
                }
                int searchScope = configItem.getSearchScope();
                if (returnAttr == null || "".equals(returnAttr)) {
                    returnAttr = "defaultNamingContext";
                }
                String[] attrNames = returnAttr.indexOf(44) > -1 ? returnAttr.split(",") : new String[]{new String(returnAttr)};
                int countLimited = configItem.getCountLimited();
                SearchControls searchControls = new SearchControls();
                searchControls.setCountLimit(countLimited);
                searchControls.setReturningAttributes(attrNames);
                searchControls.setSearchScope(searchScope);
                namingEnum = dirCtx.search(baseDN, filterExp, filterParam, searchControls);
                map = (HashMap)LdapConfigManagerUtil.init().getReadXML();
                for (Map.Entry entry22 : map.entrySet()) {
                    LdapPreceptInfo ldapPre = (LdapPreceptInfo)entry22.getValue();
                    if (ldapPre.getLdapProperty() == null) continue;
                    for (Map.Entry entry22 : ldapPre.getLdapProperty().entrySet()) {
                        ldapControlInfo = (LdapControlInfo)entry22.getValue();
                        if (entry22.getKey().toString().equals("user")) {
                            ldapControlInfoUser = ldapControlInfo;
                            continue;
                        }
                        if (entry22.getKey().toString().equals("orgunit")) {
                            ldapControlInfoOrg = ldapControlInfo;
                            continue;
                        }
                        if (entry22.getKey().toString().equals("groups")) {
                            ldapControlInfoRole = ldapControlInfo;
                            continue;
                        }
                        if (!entry22.getKey().toString().equals("principalship")) continue;
                        ldapControlInfoPosition = ldapControlInfo;
                    }
                }
                UserCollection userCol = UserFactory.getLocalInstance((Context)ctx).getUserCollection();
                RoleCollection roleCol = RoleFactory.getLocalInstance((Context)ctx).getRoleCollection();
                AdminOrgUnitCollection orgCol = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection();
                JobCollection jobCol = JobFactory.getLocalInstance((Context)ctx).getJobCollection();
                UserInfo userInfo2 = null;
                RoleInfo roleInfo2 = null;
                AdminOrgUnitInfo adminOrgUnitInfo2 = null;
                Object positionInfo = null;
                Object jobInfo = null;
                for (UserInfo userInfo2 : userCol) {
                    userMap.put(STConverter.tc2sc((String)userInfo2.getNumber()), userInfo2.getId().toString());
                }
                for (RoleInfo roleInfo2 : roleCol) {
                    roleMap.put(STConverter.tc2sc((String)roleInfo2.getName()), roleInfo2.getId().toString());
                }
                for (AdminOrgUnitInfo adminOrgUnitInfo2 : orgCol) {
                    orgMap.put(STConverter.tc2sc((String)adminOrgUnitInfo2.getDisplayName()), adminOrgUnitInfo2.getId().toString());
                }
                while (namingEnum.hasMore()) {
                    searchResult = namingEnum.next();
                    naming = searchResult.getName();
                    strDN = (naming + "," + baseDN).toLowerCase();
                    if (strDN.indexOf(ldapControlInfoUser.getDn()) != -1) {
                        ldapUserMap.put(this.getNumber(ldapControlInfoUser.getRelativelyName(), strDN, false), strDN);
                        continue;
                    }
                    if (strDN.indexOf(ldapControlInfoOrg.getDn()) != -1) {
                        ldapOrgMap.put(this.getNumber(ldapControlInfoOrg.getRelativelyName(), naming, true), strDN);
                        continue;
                    }
                    if (strDN.indexOf(ldapControlInfoRole.getDn()) != -1) {
                        ldapRoleMap.put(this.getNumber(ldapControlInfoRole.getRelativelyName(), strDN, false), strDN);
                        continue;
                    }
                    if (strDN.indexOf(ldapControlInfoPosition.getDn()) == -1) continue;
                    ldapPositionMap.put(this.getNumber(ldapControlInfoPosition.getRelativelyName(), naming, true), strDN);
                }
            }
            this.initMapping(ctx, userMap, ldapUserMap, "user");
            this.initMapping(ctx, roleMap, ldapRoleMap, "groups");
            this.initMapping(ctx, orgMap, ldapOrgMap, "orgunit");
            EASConfigManagerUtil.initLdapConfigManager("ldapProject.xml").write(ldapProject);
            EASConfigManagerUtil.initLdapConfigManager("easProject.xml").write(easProject);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (UserSyncConfigParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getNumber(String relatively, String dn, boolean isLevel) {
        String str = "";
        if (isLevel) {
            StringTokenizer st = new StringTokenizer(dn, relatively + "=");
            while (st.hasMoreTokens()) {
                String temp = st.nextToken();
                int num = temp.indexOf(",");
                if (num == -1) continue;
                if (StringUtils.isEmpty((String)str)) {
                    str = temp.substring(0, num);
                    continue;
                }
                str = temp.substring(0, num) + "_" + str;
            }
        } else {
            str = dn.substring(dn.indexOf(relatively + "=") + relatively.length() + 1, dn.indexOf(","));
        }
        return str;
    }

    private void initMapping(Context ctx, HashMap value, HashMap ldapValue, String type) {
        HashMap notValue = new HashMap();
        HashMap notLdapValue = new HashMap();
        notValue.putAll(value);
        notLdapValue.putAll(ldapValue);
        try {
            String key = null;
            Map.Entry entry = null;
            String id = null;
            Iterator it = ldapValue.entrySet().iterator();
            LdapMappingInfo info = null;
            while (it.hasNext()) {
                entry = it.next();
                key = entry.getKey().toString();
                id = (String)value.get(key);
                if (StringUtils.isEmpty((String)id)) continue;
                info = new LdapMappingInfo();
                notLdapValue.remove(key);
                notValue.remove(key);
                info.setEasid(id);
                info.setLdapdn(entry.getValue().toString(), LocaleUtils.getLocale((String)"L2"));
                info.setLdapdn(entry.getValue().toString(), LocaleUtils.getLocale((String)"L3"));
                if (type.equals("user")) {
                    EasToLdapType.initEasToLdapType().controlAdd(ctx, id, entry.getValue().toString(), type);
                }
                LdapMappingFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
            }
            if (type.equals("user")) {
                ldapProject.put("user", notLdapValue);
                easProject.put("user", notValue);
            } else if (type.equals("orgunit")) {
                ldapProject.put("orgunit", notLdapValue);
                easProject.put("orgunit", notValue);
            } else if (type.equals("groups")) {
                ldapProject.put("groups", notLdapValue);
                easProject.put("groups", notValue);
            } else if (type.equals("principalship")) {
                ldapProject.put("principalship", notLdapValue);
                easProject.put("principalship", notValue);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

