/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.util;

import com.kingdee.eas.cp.eip.sso.ldapAdapter.AbstractXML;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapControlInfo;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapEasInfo;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapPreceptInfo;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigParseException;
import com.kingdee.eas.cp.eip.sso.xml.INode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LdapConfigManagerUtil
extends AbstractXML {
    protected Logger logger = Logger.getLogger(LdapConfigManagerUtil.class);
    private static LdapConfigManagerUtil ldapConfigManagerUtil = null;
    private String fileName = "ldapConfig.xml";
    private static final String LDAPNUMBER = "ldapNumber";
    private static final String STATE = "state";
    private static final String LDAPNAME = "ldapName";
    private static final String LDAPDNNODE = "ldapDNnode";
    private static final String RELATIVELYNAME = "relativelyName";
    private static final String EASRELATIVELYNAME = "easRelativelyName";
    private static final String ADDUCTION = "adduction";
    private static final String IMPORTSWITCH = "importSwitch";
    private static final String PARENT = "parent";
    private static final String EASENTRYID = "easEntryID";
    private static final String EASENTRYPWD = "easEntryPwd";
    private static final String OBJECTCLASS = "objectClass";
    private static final String MUSTVALUE = "mustvalue";
    private static final String MAPPING = "mapping";
    private static final String DEFAULT = "default";
    private static final String ATTRNAME = "name";
    private static final String ATTRVALUE = "value";

    private LdapConfigManagerUtil() {
    }

    public static LdapConfigManagerUtil init() {
        if (ldapConfigManagerUtil == null) {
            ldapConfigManagerUtil = new LdapConfigManagerUtil();
        }
        return ldapConfigManagerUtil;
    }

    @Override
    public void write(Object object) throws IOException {
        this.writeXML(this.initNodeString(object), this.fileName);
    }

    @Override
    public Object readXML() throws UserSyncConfigParseException, IOException {
        HashMap<String, LdapPreceptInfo> ldapResourcesMap = new HashMap<String, LdapPreceptInfo>();
        INode[] ldapResxNodes = this.getChildNodes(this.initTree(this.fileName), LDAPNUMBER);
        LdapPreceptInfo ldapPreceptItem = null;
        String ldapResxKey = "";
        for (int i = 0; i < ldapResxNodes.length; ++i) {
            ldapResxKey = ldapResxNodes[i].getAttribute(ATTRNAME);
            ldapPreceptItem = new LdapPreceptInfo();
            ldapPreceptItem.setState(ldapResxNodes[i].getFirstChild().getNodeValue());
            ldapPreceptItem.setName(ldapResxNodes[i].getChildNodes()[1].getNodeValue());
            ldapPreceptItem.setNumber(ldapResxKey);
            ldapPreceptItem.setLdapProperty(this.buildInfo(ldapResxNodes[i]));
            ldapResourcesMap.put(ldapPreceptItem.getNumber(), ldapPreceptItem);
        }
        return ldapResourcesMap;
    }

    @Override
    protected HashMap buildInfo(INode resourceNode) throws UserSyncConfigParseException {
        HashMap<String, LdapControlInfo> ldapResourcesMap = new HashMap<String, LdapControlInfo>();
        INode[] ldapResxNodes = this.getChildNodes(resourceNode, LDAPDNNODE);
        LdapControlInfo ldapResx = null;
        String ldapResxKey = "";
        for (int i = 0; i < ldapResxNodes.length; ++i) {
            ldapResxKey = ldapResxNodes[i].getAttribute(ATTRNAME);
            ldapResx = (LdapControlInfo)this.getNodeObject(ldapResxNodes[i]);
            ldapResourcesMap.put(ldapResxKey, ldapResx);
        }
        return ldapResourcesMap;
    }

    @Override
    protected String initNodeString(Object object) throws IOException {
        HashMap map = (HashMap)object;
        Map.Entry entry22 = null;
        Iterator tempit = null;
        StringBuffer sb = new StringBuffer();
        LdapControlInfo item = null;
        List list = null;
        for (Map.Entry entry22 : map.entrySet()) {
            LdapPreceptInfo ldapPre = (LdapPreceptInfo)entry22.getValue();
            sb.append(this.initNodeOne(LDAPNUMBER, this.initNameOrValue(entry22.getKey().toString(), null), "1", "SEALSIGN_OFF"));
            sb.append(this.initNodeTwo(STATE, ldapPre.getState(), "2", "SEALSIGN_ON"));
            sb.append(this.initNodeTwo(LDAPNAME, ldapPre.getName(), "2", "SEALSIGN_ON"));
            if (ldapPre.getLdapProperty() != null) {
                for (Map.Entry entry22 : ldapPre.getLdapProperty().entrySet()) {
                    item = (LdapControlInfo)entry22.getValue();
                    sb.append(this.initNodeOne(LDAPDNNODE, this.initNameOrValue(entry22.getKey().toString(), item.getDn()), "2", "SEALSIGN_OFF"));
                    sb.append(this.initNodeTwo(RELATIVELYNAME, item.getRelativelyName(), "3", "SEALSIGN_ON"));
                    sb.append(this.initNodeTwo(EASRELATIVELYNAME, item.getEasRelativelyName(), "3", "SEALSIGN_ON"));
                    sb.append(this.initNodeTwo(ADDUCTION, item.getAdduction(), "3", "SEALSIGN_ON"));
                    sb.append(this.initNodeTwo(IMPORTSWITCH, item.getImportSwitch(), "3", "SEALSIGN_ON"));
                    sb.append(this.initNodeTwo(PARENT, item.getParent(), "3", "SEALSIGN_ON"));
                    sb.append(this.initNodeTwo(EASENTRYID, item.getEasEntryID(), "3", "SEALSIGN_ON"));
                    sb.append(this.initNodeTwo(EASENTRYPWD, item.getEasEntryPwd(), "3", "SEALSIGN_ON"));
                    list = item.getObjectClass();
                    if (list != null && list.size() != 0) {
                        tempit = list.iterator();
                        while (tempit.hasNext()) {
                            sb.append(this.initNodeTwo(OBJECTCLASS, tempit.next().toString(), "3", "SEALSIGN_ON"));
                        }
                        list = item.getMustValue();
                        if (list != null && list.size() != 0) {
                            tempit = list.iterator();
                            while (tempit.hasNext()) {
                                sb.append(this.initNodeTwo(MUSTVALUE, tempit.next().toString(), "3", "SEALSIGN_ON"));
                            }
                        }
                        if ((list = item.getMapValue()) != null && list.size() != 0) {
                            for (LdapEasInfo ldapEasInfo : list) {
                                sb.append(this.initNodeOne(MAPPING, this.initNameOrValue(ldapEasInfo.getKeyName(), ldapEasInfo.getKeyValue()), "3", "SEALSIGN_ON"));
                            }
                        }
                        if ((list = item.getDefValue()) != null && list.size() != 0) {
                            for (LdapEasInfo ldapEasInfo : list) {
                                sb.append(this.initNodeOne(DEFAULT, this.initNameOrValue(ldapEasInfo.getKeyName(), ldapEasInfo.getKeyValue()), "3", "SEALSIGN_ON"));
                            }
                        }
                    }
                    sb.append(this.initNodeSeal(LDAPDNNODE, "2"));
                }
            }
            sb.append(this.initNodeSeal(LDAPNUMBER, "1"));
        }
        return sb.toString();
    }

    protected Object getNodeObject(INode resourceNode) {
        LdapControlInfo result = new LdapControlInfo();
        LdapEasInfo ldapEasInfo = null;
        result.setDn(resourceNode.getAttribute(ATTRVALUE));
        ArrayList<String> objectAy = new ArrayList<String>();
        ArrayList<String> mustAy = new ArrayList<String>();
        ArrayList<LdapEasInfo> mapAy = new ArrayList<LdapEasInfo>();
        ArrayList<LdapEasInfo> defAy = new ArrayList<LdapEasInfo>();
        for (INode childNode = resourceNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (OBJECTCLASS.equalsIgnoreCase(childNode.getNodeName())) {
                objectAy.add(childNode.getNodeValue());
                continue;
            }
            if (MUSTVALUE.equalsIgnoreCase(childNode.getNodeName())) {
                mustAy.add(childNode.getNodeValue());
                continue;
            }
            if (MAPPING.equalsIgnoreCase(childNode.getNodeName())) {
                ldapEasInfo = new LdapEasInfo();
                ldapEasInfo.setKeyName(childNode.getAttribute(ATTRNAME));
                ldapEasInfo.setKeyValue(childNode.getAttribute(ATTRVALUE));
                mapAy.add(ldapEasInfo);
                continue;
            }
            if (DEFAULT.equalsIgnoreCase(childNode.getNodeName())) {
                ldapEasInfo = new LdapEasInfo();
                ldapEasInfo.setKeyName(childNode.getAttribute(ATTRNAME));
                ldapEasInfo.setKeyValue(childNode.getAttribute(ATTRVALUE));
                defAy.add(ldapEasInfo);
                continue;
            }
            if (RELATIVELYNAME.equalsIgnoreCase(childNode.getNodeName())) {
                result.setRelativelyName(childNode.getNodeValue());
                continue;
            }
            if (EASRELATIVELYNAME.equalsIgnoreCase(childNode.getNodeName())) {
                result.setEasRelativelyName(childNode.getNodeValue());
                continue;
            }
            if (ADDUCTION.equalsIgnoreCase(childNode.getNodeName())) {
                result.setAdduction(childNode.getNodeValue());
                continue;
            }
            if (IMPORTSWITCH.equalsIgnoreCase(childNode.getNodeName())) {
                result.setImportSwitch(childNode.getNodeValue());
                continue;
            }
            if (PARENT.equalsIgnoreCase(childNode.getNodeName())) {
                result.setParent(childNode.getNodeValue());
                continue;
            }
            if (EASENTRYID.equalsIgnoreCase(childNode.getNodeName())) {
                result.setEasEntryID(childNode.getNodeValue());
                continue;
            }
            if (!EASENTRYPWD.equalsIgnoreCase(childNode.getNodeName())) continue;
            result.setEasEntryPwd(childNode.getNodeValue());
        }
        result.setMapValue(mapAy);
        result.setObjectClass(objectAy);
        result.setMustValue(mustAy);
        result.setDefValue(defAy);
        return result;
    }

    public Map getReadXML() throws UserSyncConfigParseException, IOException {
        HashMap map = null;
        try {
            map = (HashMap)this.readXML();
        }
        catch (UserSyncConfigParseException e) {
            this.logger.info((Object)("LdapMapEASConfig is parse exception:" + e));
            throw e;
        }
        catch (IOException e) {
            this.logger.info((Object)("LdapMapEASConfig is io exception:" + e));
            throw e;
        }
        return map;
    }

    public Map getReadXMLStartRootNode() throws UserSyncConfigParseException, IOException {
        HashMap map = (HashMap)this.getReadXML();
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : map.entrySet()) {
            LdapPreceptInfo ldapPreceptItem = (LdapPreceptInfo)entry2.getValue();
            if (!"true".equals(ldapPreceptItem.getState())) continue;
            map = ldapPreceptItem.getLdapProperty();
            break;
        }
        return map;
    }

    public static void main(String[] args) {
        LdapConfigManagerUtil ldap = new LdapConfigManagerUtil();
        HashMap aa = null;
        try {
            aa = (HashMap)ldap.readXML();
        }
        catch (UserSyncConfigParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map.Entry entry22 = null;
        for (Map.Entry entry22 : aa.entrySet()) {
            System.out.println("1111::" + entry22.getKey());
            LdapPreceptInfo ldapPreceptItem = (LdapPreceptInfo)entry22.getValue();
            System.out.println("aaa::" + ldapPreceptItem.getState());
            System.out.println("aaa::" + ldapPreceptItem.getName());
            System.out.println("aaa::" + ldapPreceptItem.getNumber());
            for (Map.Entry entry22 : ldapPreceptItem.getLdapProperty().entrySet()) {
                System.out.println("2222::" + entry22.getKey());
                LdapControlInfo result = (LdapControlInfo)entry22.getValue();
                Iterator it = result.getObjectClass().iterator();
                while (it.hasNext()) {
                    System.out.println("objectclass:::" + it.next().toString());
                }
                it = result.getMustValue().iterator();
                while (it.hasNext()) {
                    System.out.println("mustvalue:::" + it.next().toString());
                }
                for (LdapEasInfo aa1 : result.getMapValue()) {
                    System.out.println("easpro:::" + aa1.getKeyName());
                    System.out.println("ldappro:::" + aa1.getKeyValue());
                }
                for (LdapEasInfo aa1 : result.getDefValue()) {
                    System.out.println("defname:::" + aa1.getKeyName());
                    System.out.println("defvalue:::" + aa1.getKeyValue());
                }
                System.out.println("getDn:::" + result.getDn());
                System.out.println("getRelativelyName:::" + result.getRelativelyName());
                System.out.println("getEasRelativelyName:::" + result.getEasRelativelyName());
                System.out.println("getAdduction:::" + result.getAdduction());
                System.out.println("getImportSwitch:::" + result.getImportSwitch());
                System.out.println("getParent:::" + result.getParent());
                System.out.println("getEasEntryID:::" + result.getEasEntryID());
                System.out.println("getEasEntryPwd:::" + result.getEasEntryPwd());
                System.out.println("--------------------------------------------------------");
            }
        }
    }
}

