/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.util;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LdapUtils {
    public static final String LDAP_CONNECT_POOL = "com.sun.jndi.ldap.connect.pool";
    public static final String CLASS_DEFINITION = "ClassDefinition";
    public static final String ATTR_DEFINITION = "AttributeDefinition";
    public static final String SYNTAX_DEFINITION = "SyntaxDefinition";
    public static final String MATCHING_RULE = "MatchingRule";
    public static final String EXT_DEFINITION = "ExtensionDefinition";
    public static final String CTRL_DEFINITION = "ControlDefinition";
    public static final String SASL_DEFINITION = "SASLDefinition";

    public static DirContext createDirContext(String ldapUrl, String username, String password) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>(10);
        env.put(LDAP_CONNECT_POOL, "true");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.referral", "follow");
        InitialDirContext dirCtx = new InitialDirContext(env);
        return dirCtx;
    }

    public static NamingEnumeration getSchemaDefinition(DirContext schema, String oid, String bindingType) throws NamingException {
        if (!LdapUtils.isSupported(bindingType)) {
            throw new NamingException("not support to lookup this " + bindingType);
        }
        DirContext cs = (DirContext)schema.lookup(bindingType + "/" + oid);
        Attributes attrs = cs.getAttributes("");
        NamingEnumeration<? extends Attribute> enu = attrs.getAll();
        return enu;
    }

    public static boolean isSupported(String bindingType) {
        return true;
    }

    public static NamingEnumeration getIBMAttributes(DirContext ctx) throws NamingException {
        String[] attrs = new String[]{"ibmattributetypes"};
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(0);
        constraints.setReturningAttributes(attrs);
        NamingEnumeration<SearchResult> results = ctx.search("cn=schema", "objectclass=*", constraints);
        return results;
    }

    public static NamingEnumeration getAllObjectClass(DirContext ctx, String objectClass) throws NamingException {
        String[] attrs = new String[]{objectClass};
        DirContext objClasses = ctx.getSchemaClassDefinition(objectClass);
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(0);
        constraints.setReturningAttributes(attrs);
        NamingEnumeration<SearchResult> results = ctx.search("cn=schema", "objectclass=*", constraints);
        return results;
    }
}

