/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.auth;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.PassiveCallbackHandler;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.cp.common.web.util.ConstantsUtil;
import com.kingdee.eas.cp.common.web.util.ExceptionUtil;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.sso.web.auth.EASCallbackHandler;
import com.kingdee.eas.cp.eip.sso.web.auth.EASWebLicenceHelper;
import edu.yale.its.tp.cas.auth.PasswordHandler;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class EASAuthHandler
implements PasswordHandler {
    private Logger logger = Logger.getLogger((String)EASAuthHandler.class.getName());
    private String APPLICATION_NAME = EASAuthHandler.class.getName();

    public boolean authenticate(ServletRequest request, String username, String password) {
        long authStart = System.currentTimeMillis();
        this.logger.debug((Object)(" [EAS Portal Auth] The user " + username + " want to login EAS Portal."));
        boolean authResult = true;
        try {
            EASCallbackHandler easchb = new EASCallbackHandler();
            PassiveCallbackHandler chb = easchb.createCallbackHandler(request, username, password);
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            long authReady = System.currentTimeMillis() - authStart;
            this.logger.debug((Object)("[EAS Portal Auth] Be ready to auth spend " + authReady + " ms."));
            try {
                LoginContext lc = new LoginContext(this.APPLICATION_NAME, (CallbackHandler)chb);
                lc.login();
            }
            catch (LoginException e) {
                throw e;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
            long authEnd = System.currentTimeMillis() - authReady - authStart;
            this.logger.debug((Object)("[EAS Portal Auth] Perform auth(from be ready to perform) spend " + authEnd + " ms."));
            this.logger.info((Object)("[EAS Portal Auth] User " + username + " login,EAS LoginModule spent " + authEnd + " ms! SessionId = " + easchb.getUserContext().getContextID()));
            easchb.getUserContext().setClientHostIP(request.getRemoteAddr());
            easchb.getUserContext().setClientHostName(request.getRemoteAddr());
            EASWebLicenceHelper.checkWebLoginLicence((HttpServletRequest)request, easchb, "com.kingdee.eas.portal.web.action.PortalAction");
            if (ConstantsUtil.isWRAP_REQUEST()) {
                WebContextUtil.createWebContext((HttpServletRequest)((HttpServletRequest)request), (Context)easchb.getUserContext());
                long webCtxWrappedEnd = System.currentTimeMillis() - authEnd - authReady - authStart;
                this.logger.debug((Object)("[EAS Portal Auth] web context wrapper(from auth end to wrapper context) spend " + webCtxWrappedEnd + " ms."));
            }
        }
        catch (LoginException e) {
            if (e instanceof BOSLoginException) {
                this.logger.error((Object)(" [EAS Portal Auth] Authentication attempt failed. \r\n" + ExceptionUtil.getExcLinkStackTrace((Throwable)((BOSLoginException)e), (String)"\r\n")));
            } else {
                this.logger.error((Object)(" [EAS Portal Auth] Authentication attempt failed. \r\n" + ExceptionUtil.getExcLinkStackTrace((Throwable)e, (String)"\r\n")));
            }
            if (e.getCause() == null) {
                request.setAttribute("loginErrorInfo", (Object)e.getMessage());
            } else {
                request.setAttribute("loginErrorInfo", (Object)e.getCause().getMessage());
            }
            authResult = false;
        }
        catch (LicenseException e) {
            this.logger.error((Object)("license check failed:" + e.getMessage()));
        }
        return authResult;
    }

    public Context wapAuthenticate(ServletRequest request, String username, String password) {
        long authStart = System.currentTimeMillis();
        this.logger.debug((Object)(" [EAS Portal Auth] The user " + username + " want to login EAS Portal."));
        boolean authResult = true;
        EASCallbackHandler easchb = new EASCallbackHandler();
        try {
            easchb = new EASCallbackHandler();
            PassiveCallbackHandler chb = easchb.createCallbackHandler(request, username, password);
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            long authReady = System.currentTimeMillis() - authStart;
            this.logger.debug((Object)("[EAS Portal Auth] Be ready to auth spend " + authReady + " ms."));
            try {
                LoginContext lc = new LoginContext(this.APPLICATION_NAME, (CallbackHandler)chb);
                lc.login();
            }
            catch (LoginException e) {
                throw e;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
            long authEnd = System.currentTimeMillis() - authReady - authStart;
            this.logger.debug((Object)("[EAS Portal Auth] Perform auth(from be ready to perform) spend " + authEnd + " ms."));
            this.logger.info((Object)("[EAS Portal Auth] User " + username + " login,EAS LoginModule spent " + authEnd + " ms! SessionId = " + easchb.getUserContext().getContextID()));
            if (ConstantsUtil.isWRAP_REQUEST()) {
                long webCtxWrappedEnd = System.currentTimeMillis() - authEnd - authReady - authStart;
                this.logger.debug((Object)("[EAS Portal Auth] web context wrapper(from auth end to wrapper context) spend " + webCtxWrappedEnd + " ms."));
            }
        }
        catch (LoginException e) {
            if (e instanceof BOSLoginException) {
                this.logger.error((Object)(" [EAS Portal Auth] Authentication attempt failed. \r\n" + ExceptionUtil.getExcLinkStackTrace((Throwable)((BOSLoginException)e), (String)"\r\n")));
            } else {
                this.logger.error((Object)(" [EAS Portal Auth] Authentication attempt failed. \r\n" + ExceptionUtil.getExcLinkStackTrace((Throwable)e, (String)"\r\n")));
            }
            authResult = false;
        }
        return easchb.getUserContext();
    }
}

