/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.auth;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.PassiveCallbackHandler;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.ExceptionUtil;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class EASCallbackHandler {
    private Logger logger = Logger.getLogger((String)EASCallbackHandler.class.getName());
    private static final String USBKE_INFO = "usbkeyInfo";
    private static final String USBKE_PIN_VERIFY_RESULT = "usbkeyPinVerifyResult";
    private LoginContext loginContext = null;
    private Context userContext = null;

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    public void setLoginContext(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    public Context getUserContext() {
        return this.userContext;
    }

    public void setUserContext(Context userContext) {
        this.userContext = userContext;
    }

    public PassiveCallbackHandler createCallbackHandler(ServletRequest request, String username, String password) throws BOSLoginException {
        LoginContext loginCtx = null;
        Context userCtx = null;
        loginCtx = this.createLoginContext(request, username, password);
        userCtx = this.createUserContext(loginCtx);
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        userCtx.setClientHostIP(EASCallbackHandler.getIpAddr(httpServletRequest));
        userCtx.setClientHostName(request.getRemoteAddr());
        this.fillContext(loginCtx, userCtx);
        String easSessionId = request.getParameter("easSessionId");
        String isPureWeb = (String)request.getAttribute("isPureWeb");
        if ("true".equals(isPureWeb)) {
            easSessionId = userCtx.getContextID();
        }
        this.fillSessionId(easSessionId, userCtx);
        this.setLoginContext(loginCtx);
        this.setUserContext(userCtx);
        userCtx.put((Object)USBKE_INFO, (Object)request.getParameter(USBKE_INFO));
        userCtx.put((Object)USBKE_PIN_VERIFY_RESULT, (Object)request.getParameter(USBKE_PIN_VERIFY_RESULT));
        PassiveCallbackHandler cbh = new PassiveCallbackHandler(loginCtx, userCtx);
        return cbh;
    }

    private static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("nap_proxy_client_ip");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private void fillSessionId(String easSessionId, Context userCtx) {
        userCtx.put((Object)"SessionId", (Object)easSessionId);
    }

    private void fillContext(LoginContext loginCtx, Context userCtx) {
        Iterator it = loginCtx.items.entrySet().iterator();
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = it.next();
            userCtx.put(entry.getKey(), entry.getValue());
        }
    }

    private Context createUserContext(LoginContext loginCtx) {
        Context userContext = null;
        Object ob = loginCtx.get("oldContextId");
        this.logger.debug((Object)("oldContextId from easapplet " + ob));
        if (ob == null) {
            userContext = new Context(null, loginCtx.getSlnName(), loginCtx.getAis(), loginCtx.getLocale());
        } else {
            String contextId = (String)ob;
            userContext = new Context(null, loginCtx.getSlnName(), loginCtx.getAis(), loginCtx.getLocale(), contextId);
        }
        return userContext;
    }

    private LoginContext createLoginContext(ServletRequest request, String username, String password) throws BOSLoginException {
        String isSaveContext;
        String slnName = request.getParameter("solutionName");
        String dataCenter = request.getParameter("dataCenter");
        String localeStr = request.getParameter("locale");
        String dbTypeStr = request.getParameter("dbType");
        String ip = request.getRemoteAddr();
        String clientHostName = request.getRemoteHost();
        String isPureWeb = (String)request.getAttribute("isPureWeb");
        if ("true".equals(isPureWeb)) {
            slnName = (String)request.getAttribute("solutionName");
            dataCenter = (String)request.getAttribute("dataCenter");
            localeStr = (String)request.getAttribute("locale");
            dbTypeStr = (String)request.getAttribute("dbType");
        }
        if (slnName == null || "".equals(slnName) || dataCenter == null || "".equals(dataCenter) || localeStr == null || "".equals(localeStr)) {
            throw new BOSLoginException("[EAS Auth]Please assign required parameter.solutionName=[" + slnName + "],dataCenter=[" + dataCenter + "],locale=[" + localeStr + "],dbType=[" + dbTypeStr + "]");
        }
        Locale locale = new Locale(localeStr);
        int dbType = 2;
        try {
            dbType = Integer.parseInt(dbTypeStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String encodedPwd = this.encodePassword(username, password);
        LoginContext ctx = new LoginContext(username, encodedPwd, slnName, dataCenter, locale, ip, clientHostName);
        ctx.put("dbType", (Object)EASCallbackHandler.getDbType(dbType));
        String authPattern = request.getParameter("userAuthPattern");
        if (authPattern != null && !authPattern.equals("")) {
            ctx.put("UserAuthPattern", (Object)authPattern);
        }
        if ((isSaveContext = request.getParameter("isSaveContext")) != null && "true".equals(isSaveContext)) {
            ctx.put("oldContextId", (Object)request.getParameter("oldContextId"));
        }
        return ctx;
    }

    private static String getDbType(int dbType) {
        return DbType.getName((int)dbType);
    }

    private String encodePassword(String userName, String password) {
        String encodedPassword = "";
        try {
            encodedPassword = CryptoTean.encrypt((String)userName, (String)password);
            this.logger.debug((Object)("[EAS Portal] password=" + password + ",encodePwd=" + encodedPassword));
        }
        catch (CryptException e) {
            this.logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)e));
        }
        return encodedPassword;
    }
}

