/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.controller;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserFindPassFacadeFactory;
import com.kingdee.eas.base.permission.UserFindPassParam;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.helper.SecurityValidatorHelper;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import com.kingdee.eas.cp.eip.sso.util.CloudParamUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class UserFindPassController
extends AbstractController {
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String dataCenter = request.getParameter("dataCenter");
        String local = request.getParameter("language");
        String userNumber = request.getParameter("userNumber");
        String method = request.getParameter("method");
        Context ctx = CloudParamUtil.getContext(dataCenter, local, userNumber);
        String clientIP = request.getHeader("nap_proxy_client_ip");
        if (StringUtils.isEmpty((String)clientIP)) {
            clientIP = request.getRemoteAddr();
        }
        if (!StringUtils.isEmpty((String)clientIP)) {
            ctx.setClientHostIP(clientIP);
            ctx.setClientHostName(clientIP);
        }
        JSONObject obj = new JSONObject();
        try {
            if ("sendVcode".equals(method)) {
                String phoneOrEmail = request.getParameter("phoneOrEmail");
                try {
                    JSONObject result = UserFindPassFacadeFactory.getLocalInstance((Context)ctx).sendVcode(userNumber, phoneOrEmail);
                    if (result.getInteger("errcode") != 0) {
                        if (result.getInteger("errcode") == 1507) {
                            obj.put("offineline", (Object)true);
                        }
                        throw new Exception(result.getString(EasCloud.DESCRIPTION_CN));
                    }
                    obj.put("resend_in", (Object)JSONObject.parseObject((String)result.getString("data")).getInteger("resend_in"));
                }
                catch (Exception e) {
                    if (e.getCause() instanceof IOException && phoneOrEmail.indexOf("@") < 0) {
                        obj.put("offineline", (Object)true);
                    }
                    throw e;
                }
            } else if ("checkVcode".equals(method)) {
                String phoneOrEmail = request.getParameter("phoneOrEmail");
                String authCode = request.getParameter("authCode");
                String canConnetToNet = request.getParameter("canConnetToNet");
                UserFindPassParam params = new UserFindPassParam(dataCenter, local, userNumber);
                params.setOffineLine("true".equalsIgnoreCase(canConnetToNet));
                params.setVcode(authCode);
                params.setPhone(phoneOrEmail);
                params.setEmail(phoneOrEmail);
                params.setUsePhone(phoneOrEmail.indexOf("@") <= 0);
                boolean isSuccess = UserFindPassFacadeFactory.getLocalInstance((Context)ctx).verifyVCode(params);
                if (isSuccess) {
                    String passTip = SecurityValidatorHelper.getPwdTip((Context)ctx, (String)userNumber);
                    obj.put("pwdTip", (Object)passTip);
                    request.getSession().setAttribute("ut", (Object)MD5Util.getMD5String((String)(dataCenter + userNumber)));
                    request.getSession().setAttribute("ut_createtime", (Object)String.valueOf(System.currentTimeMillis()));
                }
            } else if ("setNewPass".equals(method)) {
                String ut = (String)request.getSession().getAttribute("ut");
                String ut_createtime = (String)request.getSession().getAttribute("ut_createtime");
                if (ut == null || ut_createtime == null || !ut.equals(MD5Util.getMD5String((String)(dataCenter + userNumber))) || System.currentTimeMillis() - Long.valueOf(ut_createtime) > 300000L) {
                    throw new Exception(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionFindPassResource", (String)"FINDPASS_UT_EMPTY", (Locale)ctx.getLocale()));
                }
                String pwd = request.getParameter("pwd");
                String newPwd = BASE64Util.decodeAsString(pwd);
                String sql = "SELECT FID ,FNUMBER FROM T_PM_USER WHERE LOWER(FNUMBER)=?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userNumber.toLowerCase()});
                if (rs.next()) {
                    ObjectUuidPK pk = new ObjectUuidPK(rs.getString("FID"));
                    ctx.setCaller((IObjectPK)pk);
                    UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)pk);
                    userInfo.remove("orgRange");
                    userInfo.setPassword(PermissionCommonUtil.encrypt((String)rs.getString("FNUMBER"), (String)newPwd));
                    UserFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectValue)userInfo, true);
                    request.getSession().removeAttribute("ut");
                    request.getSession().removeAttribute("ut_createtime");
                    CloudParamUtil.logFindPass(ctx);
                }
            } else if ("checkCanFindPass".equalsIgnoreCase(method)) {
                UserFindPassFacadeFactory.getLocalInstance((Context)ctx).checkCanFindPass(userNumber);
            }
            obj.put("success", (Object)true);
        }
        catch (Exception e) {
            this.logger.error((Object)"CloudActivateServlet error ===", (Throwable)e);
            obj.put("success", (Object)"false");
            if (e.getCause() != null) {
                obj.put("errorInfo", (Object)e.getCause().getMessage());
            } else {
                obj.put("errorInfo", (Object)e.getMessage());
            }
            obj.put("errorCode", (Object)"other");
        }
        response.setContentType("text/html");
        response.getOutputStream().write(obj.toJSONString().getBytes("utf-8"));
        return null;
    }
}

