/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.datacenter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.framework.ejb.EJBFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DataCenterConnUtil {
    public static final Logger logger = CommonLogger.getLogger(DataCenterConnUtil.class);
    public static final String ClassForName = "com.kingdee.bos.sql.shell.KDDriver";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List getDataCenterList(Context ctx) throws BOSException, SQLException {
        ArrayList<DataCenterInfo> arrayList;
        ArrayList<DataCenterInfo> list = new ArrayList<DataCenterInfo>();
        String sql = "select * from T_CTR_ExtReportOutDB";
        Connection con = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            rs = DBUtil.executeSql(con, sql);
            while (rs.next()) {
                DataCenterInfo info = new DataCenterInfo();
                info.setDbCenterName(rs.getString("FDbCenterName"));
                info.setDbAddress(rs.getString("FDbAddress"));
                info.setDbName(rs.getString("FDbName"));
                info.setDbPort(rs.getInt("FDbPort"));
                info.setDbType(rs.getInt("FDbType"));
                info.setInstanceName(rs.getString("FInstanceName"));
                info.setUser(rs.getString("FUser"));
                info.setPwd(rs.getString("FPWD"));
                list.add(info);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(rs);
            DBUtil.closeDBConn(con);
            throw throwable;
        }
        DBUtil.closeResultSet(rs);
        DBUtil.closeDBConn(con);
        return arrayList;
    }

    public static Connection openConnection(DataCenterInfo vo) throws Exception {
        String connectUrl = null;
        Connection conn = null;
        String user = null;
        String pwd = null;
        try {
            connectUrl = DataCenterConnUtil.getDriverClassName(vo.getDbType()) + ":" + DataCenterConnUtil.getJDBCUrl(vo);
            DataCenterConnUtil.loadDrive();
            user = vo.getUser();
            pwd = new String(Base64.decode(vo.getPwd()));
            conn = DriverManager.getConnection(connectUrl, user, pwd);
        }
        catch (Exception e) {
            logger.error((Object)("DataCenterInfo: Connection = " + connectUrl + ", user = " + user + ", pwd = " + pwd + ",finished!"));
            DataCenterConnUtil.closeConnection(conn);
            throw e;
        }
        return conn;
    }

    public static void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"close DB-Connection faile.");
        }
    }

    private static String getSqlServerUrl(String dbaddress, int dbport, String dbName) {
        String[] arr;
        String instanceName = null;
        if (dbaddress.indexOf("\\") != -1 && (arr = dbaddress.split("\\\\")).length == 2) {
            dbaddress = arr[0];
            instanceName = arr[1];
        }
        StringBuffer sb = new StringBuffer();
        if (instanceName != null && !instanceName.equals("")) {
            sb.append("jdbc:jtds:sqlserver://").append(dbaddress).append(":").append(dbport).append("/").append(dbName);
            sb.append(";instance=").append(instanceName).append(";prepareSQL=2;sendStringParametersAsUnicode=false;useCursors=true");
        } else {
            sb.append("jdbc:jtds:sqlserver://").append(dbaddress).append(":").append(dbport).append("/").append(dbName);
            sb.append(";prepareSQL=2;sendStringParametersAsUnicode=false;useCursors=true");
        }
        return sb.toString();
    }

    private static String getOracelUrl(String dbaddress, int dbport, String instanceName) {
        return "jdbc:oracle:thin:@" + dbaddress + ":" + dbport + ":" + instanceName;
    }

    private static String getOracelServiceUrl(String dbaddress, int dbport, String instanceName) {
        return "jdbc:oracle:thin:@" + dbaddress + ":" + dbport + "/" + instanceName;
    }

    private static String getDb2Url(String dbaddress, int dbport, String dbName) {
        return "jdbc:db2://" + dbaddress + ":" + dbport + "/" + dbName + ":retrieveMessagesFromServerOnGetMessage=true;";
    }

    private static String getMysql(String dbaddress, int dbport, String dbName) {
        return "jdbc:mysql://" + dbaddress + ":" + dbport + "/" + dbName + "?useUnicode=true&characterEncoding=utf-8";
    }

    private static String getPostgreSql(String dbaddress, int dbport, String dbName) {
        return "jdbc:postgresql://" + dbaddress + ":" + dbport + "/" + dbName;
    }

    private static String getDM(String dbaddress, int dbport, String dbName) {
        return "jdbc:dm://" + dbaddress + ":" + dbport + "/" + dbName;
    }

    private static String getKingbase(String dbaddress, int dbport, String dbName) {
        return "jdbc:kingbase8://" + dbaddress + ":" + dbport + "/" + dbName;
    }

    public static String getJDBCUrl(DataCenterInfo vo) {
        int dbType = vo.getDbType();
        if (dbType == 3) {
            return DataCenterConnUtil.getSqlServerUrl(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        if (dbType == 2) {
            return DataCenterConnUtil.getOracelServiceUrl(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        if (dbType == 1) {
            return DataCenterConnUtil.getDb2Url(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        if (dbType == 6) {
            return DataCenterConnUtil.getMysql(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        if (dbType == 5) {
            return DataCenterConnUtil.getPostgreSql(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        if (dbType == 7) {
            return DataCenterConnUtil.getDM(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        if (dbType == 12) {
            return DataCenterConnUtil.getKingbase(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        return null;
    }

    public static String getDriverClassName(int dbType) {
        switch (dbType) {
            case 3: {
                return "jdbc:ksql:net.sourceforge.jtds.jdbc.Driver:dbtype=mssqlserver";
            }
            case 2: {
                return "jdbc:ksql:oracle.jdbc.driver.OracleDriver:dbtype=oracle";
            }
            case 1: {
                return "jdbc:ksql:com.ibm.db2.jcc.DB2Driver:dbtype=db2";
            }
            case 6: {
                return "jdbc:ksql:com.mysql.jdbc.Driver:dbtype=mysql";
            }
            case 5: {
                return "jdbc:ksql:org.postgresql.Driver:dbtype=postgresql";
            }
            case 7: {
                return "jdbc:ksql:dm.jdbc.driver.DmDriver:dbtype=dm";
            }
            case 12: {
                return "jdbc:ksql:com.kingbase8.Driver:dbtype=kingbase";
            }
        }
        return null;
    }

    private static final boolean loadDrive() {
        try {
            Class.forName(ClassForName);
        }
        catch (ClassNotFoundException ex) {
            logger.error((Object)ex, (Throwable)ex);
            return false;
        }
        return true;
    }

    public static void testLinkConn(DataCenterInfo vo) throws Exception {
        Connection conn = DataCenterConnUtil.openConnection(vo);
        DataCenterConnUtil.closeConnection(conn);
    }
}

