/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import java.awt.BufferCapabilities;
import java.awt.DisplayMode;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;

public class GraphicsUtil {
    public static String getGraphicsConfigText(Graphics2D g) {
        StringBuffer sb = new StringBuffer();
        GraphicsUtil.makeGraphicsConfig(g.getDeviceConfiguration(), sb);
        return sb.toString();
    }

    public static void makeGraphicsConfig(GraphicsConfiguration gc, StringBuffer sb) {
        sb.append("[Bournds]\r\n\t");
        Rectangle rc = gc.getBounds();
        sb.append("X=");
        sb.append(rc.getX());
        sb.append(", Y=");
        sb.append(rc.getY());
        sb.append(", Width=");
        sb.append(rc.getWidth());
        sb.append(", Height=");
        sb.append(rc.getHeight());
        sb.append("\r\n");
        sb.append("[AffineTransform]");
        AffineTransform at = gc.getDefaultTransform();
        sb.append("\r\n\tType=");
        sb.append(at.getType());
        sb.append("\r\n\tDeterminant=");
        sb.append(at.getDeterminant());
        sb.append("\r\n\tScale: X=");
        sb.append(at.getScaleX());
        sb.append(", Y=");
        sb.append(at.getScaleY());
        sb.append("\r\n\tShear: X=");
        sb.append(at.getShearX());
        sb.append(", Y=");
        sb.append(at.getShearY());
        sb.append("\r\n\tTransform: X=");
        sb.append(at.getTranslateX());
        sb.append(", Y=");
        sb.append(at.getTranslateY());
        sb.append("\r\n");
        ColorModel cm = gc.getColorModel();
        sb.append("[ColorModel]");
        sb.append("\r\n\tPixelSize=");
        sb.append(cm.getPixelSize());
        sb.append("\r\n\tTransferType=");
        sb.append(cm.getTransferType());
        sb.append("\r\n\tTransparency=");
        sb.append(cm.getTransparency());
        sb.append("\r\n\tAlpha=");
        sb.append(cm.hasAlpha());
        sb.append(", Premultiplied=");
        sb.append(cm.isAlphaPremultiplied());
        sb.append("\r\n");
        sb.append("[GraphicsDevice]");
        GraphicsDevice gv = gc.getDevice();
        sb.append("\r\n\tID=");
        sb.append(gv.getIDstring());
        sb.append("\r\n\tType=");
        sb.append(gv.getType());
        sb.append("\r\n\tDisplayMode: ");
        GraphicsUtil.makeDisplayMode(gv.getDisplayMode(), sb);
        sb.append("\r\n\tAvailableAcceleratedMemory=");
        sb.append(gv.getAvailableAcceleratedMemory());
        sb.append("\r\n");
        sb.append("[ImageCapabilities]\r\n\t");
        GraphicsUtil.makeImageCapabilities(gc.getImageCapabilities(), sb);
        sb.append("\r\n");
        sb.append("[BufferCapabilities]\r\n");
        BufferCapabilities bc = gc.getBufferCapabilities();
        sb.append("\tFront: ");
        GraphicsUtil.makeImageCapabilities(bc.getFrontBufferCapabilities(), sb);
        sb.append("\r\n\tBack: ");
        GraphicsUtil.makeImageCapabilities(bc.getBackBufferCapabilities(), sb);
        sb.append("\r\n\tFlipContents: ");
        BufferCapabilities.FlipContents fc = bc.getFlipContents();
        sb.append(fc != null ? fc.toString() : null);
        sb.append("\r\n");
    }

    public static void makeDisplayMode(DisplayMode dm, StringBuffer sb) {
        sb.append("Width=");
        sb.append(dm.getWidth());
        sb.append(", Height=");
        sb.append(dm.getHeight());
        sb.append(", BitDepth=");
        sb.append(dm.getBitDepth());
        sb.append(", RefreshRate=");
        sb.append(dm.getRefreshRate());
    }

    public static void makeImageCapabilities(ImageCapabilities ic, StringBuffer sb) {
        sb.append("Accelerated=");
        sb.append(ic.isAccelerated());
        sb.append(", TrueVolatile=");
        sb.append(ic.isTrueVolatile());
    }
}

