/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ReflectUtil {
    private static HashMap infsCache;
    public static final Class[] VOID_ARGTYPES;
    public static final Object[] VOID_ARGS;
    public static final HashMap clsCache;

    public static Object invoke(Object obj, String methodName, Object[] args) throws Throwable {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                throw new NoSuchMethodException();
            }
            argTypes[i] = args[i].getClass();
        }
        return ReflectUtil.invoke(obj, methodName, argTypes, args);
    }

    public static Method getMethodEx(Class cls, String name, Class[] args) throws NoSuchMethodException {
        NoSuchMethodException ex = null;
        while (cls != null) {
            try {
                return cls.getDeclaredMethod(name, args);
            }
            catch (NoSuchMethodException e) {
                cls = cls.getSuperclass();
                if (ex != null) continue;
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return null;
    }

    public static Object invoke(Object obj, String methodName, Class[] argTypes, Object[] args) throws Throwable {
        Class<?> cls = obj.getClass();
        Method mtd = cls.getMethod(methodName, argTypes);
        try {
            return mtd.invoke(obj, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    public static Method getFirstMethodWithCache(Class cls, String methodName) {
        Method mtd = ReflectUtil.getCachedMethod(cls, methodName);
        if (mtd == null && (mtd = ReflectUtil.getFirstMethod(cls, methodName)) != null) {
            ReflectUtil.cacheMethod(cls, mtd);
        }
        return mtd;
    }

    public static void clearCachedMethds() {
        clsCache.clear();
    }

    public static Method cacheMethod(Class cls, Method mtd) {
        HashMap<String, Method> mtds = (HashMap<String, Method>)clsCache.get(cls);
        if (mtds == null) {
            mtds = new HashMap<String, Method>();
            clsCache.put(cls, mtds);
        }
        return mtds.put(mtd.getName(), mtd);
    }

    public static Method getCachedMethod(Class cls, String methodName) {
        HashMap mtds = (HashMap)clsCache.get(cls);
        if (mtds == null) {
            return null;
        }
        return (Method)mtds.get(methodName);
    }

    public static Method getFirstMethod(Class cls, String methodName) {
        Method[] mtds = cls.getMethods();
        for (int i = 0; i < mtds.length; ++i) {
            Method mtd = mtds[i];
            if (!mtd.getName().equals(methodName)) continue;
            return mtd;
        }
        return null;
    }

    public static Object invoke(Object obj, String methodName) throws Throwable {
        return ReflectUtil.invoke(obj, methodName, VOID_ARGTYPES, VOID_ARGS);
    }

    public static final Class getSimpleTypeClass(String name) {
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        return null;
    }

    public static final Class getTypeClass(String name) throws ClassNotFoundException {
        Class<?> cls = ReflectUtil.getSimpleTypeClass(name);
        if (cls == null) {
            cls = Class.forName(name);
        }
        return cls;
    }

    private static Class[] pure_getAllInterfaces(Class cls) {
        HashSet set = new HashSet();
        for (Class curCls = cls; curCls != null; curCls = curCls.getSuperclass()) {
            Class<?>[] temp = curCls.getInterfaces();
            if (temp == null) continue;
            for (int i = 0; i < temp.length; ++i) {
                set.add(temp[i]);
            }
        }
        Class[] clses = new Class[set.size()];
        return set.toArray(clses);
    }

    public static Class[] getAllInterfaces(Class cls) {
        Class[] clses;
        if (infsCache == null) {
            infsCache = new HashMap();
        }
        if ((clses = (Class[])infsCache.get(cls)) == null) {
            clses = ReflectUtil.pure_getAllInterfaces(cls);
            infsCache.put(cls, clses);
        }
        return clses;
    }

    public static int compareClass(Class cls1, Class cls2) {
        if (cls1.equals(cls2)) {
            return 0;
        }
        if (cls1.isAssignableFrom(cls2)) {
            return -1;
        }
        if (cls2.isAssignableFrom(cls1)) {
            return 1;
        }
        return -2;
    }

    public static int compareClass(String cls1, String cls2) throws ClassNotFoundException {
        return ReflectUtil.compareClass(Class.forName(cls1), Class.forName(cls2));
    }

    public static Object makeMonitableObject(Object realObject, IIvkListener ivkListener) {
        if (ivkListener == null) {
            return realObject;
        }
        Class[] ifs = ReflectUtil.getAllInterfaces(realObject.getClass());
        return Proxy.newProxyInstance(ReflectUtil.class.getClassLoader(), ifs, (InvocationHandler)new ObjectHandler(realObject, ivkListener));
    }

    public static void makeAccessible(Constructor<?> ctor) {
        if (!(Modifier.isPublic(ctor.getModifiers()) && Modifier.isPublic(ctor.getDeclaringClass().getModifiers()) || ctor.isAccessible())) {
            ctor.setAccessible(true);
        }
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    static {
        VOID_ARGTYPES = new Class[0];
        VOID_ARGS = new Object[0];
        clsCache = new HashMap();
    }

    public static class ObjectHandler
    implements InvocationHandler {
        private Object realObject;
        private IIvkListener ivkListener;

        public ObjectHandler(Object realObject, IIvkListener ivkListener) {
            this.realObject = realObject;
            this.ivkListener = ivkListener;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.ivkListener != null) {
                this.ivkListener.beginInvoke(this.realObject, method, args);
            }
            Object obj = null;
            Throwable throwable = null;
            try {
                obj = method.invoke(this.realObject, args);
            }
            catch (Throwable e) {
                throwable = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            }
            if (this.ivkListener != null) {
                this.ivkListener.endInvoke(this.realObject, method, args, throwable);
            }
            if (throwable != null) {
                throw throwable;
            }
            return obj;
        }
    }

    public static class IvkListenerList
    implements IIvkListener {
        private HashSet listenerSet = new HashSet();

        public void add(IIvkListener listener) {
            this.listenerSet.add(listener);
        }

        @Override
        public void beginInvoke(Object object, Method method, Object[] args) throws Throwable {
            Iterator i = this.listenerSet.iterator();
            while (i.hasNext()) {
                ((IIvkListener)i.next()).beginInvoke(object, method, args);
            }
        }

        @Override
        public void endInvoke(Object object, Method method, Object[] args, Throwable ivkResult) throws Throwable {
            Iterator i = this.listenerSet.iterator();
            while (i.hasNext()) {
                ((IIvkListener)i.next()).endInvoke(object, method, args, ivkResult);
            }
        }
    }

    public static interface IIvkListener {
        public void beginInvoke(Object var1, Method var2, Object[] var3) throws Throwable;

        public void endInvoke(Object var1, Method var2, Object[] var3, Throwable var4) throws Throwable;
    }
}

