/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;

public class UID {
    private static final char[] BASE;
    private byte[] bytes;

    public static String create16() {
        return UID.create(16);
    }

    public static String create(int len) {
        return new UID(len).toString();
    }

    private UID(int length) {
        this.bytes = new byte[length];
        this.generate();
    }

    private void generate() {
        SecureRandom ng = new SecureRandom();
        ng.nextBytes(this.bytes);
        int c = this.bytes.length;
        for (int i = 0; i < c; ++i) {
            this.bytes[i] = (byte)BASE[this.bytes[i] & 0x3F];
        }
    }

    public String toString() {
        try {
            return new String(this.bytes, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.bytes);
        }
    }

    static {
        int i;
        BASE = new char[64];
        UID.BASE[0] = 95;
        UID.BASE[1] = 95;
        int idx = 2;
        for (i = 48; i <= 57; ++i) {
            UID.BASE[idx++] = (char)i;
        }
        for (i = 65; i <= 90; ++i) {
            UID.BASE[idx++] = (char)i;
        }
        for (i = 97; i <= 122; ++i) {
            UID.BASE[idx++] = (char)i;
        }
    }
}

