/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.expr;

import com.kingdee.bos.ctrl.common.util.NumberUtil;
import com.kingdee.bos.ctrl.kdf.expr.ExprError;
import com.kingdee.bos.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.bos.ctrl.kdf.expr.Util;
import com.kingdee.bos.ctrl.kdf.expr.VarBase;
import com.kingdee.bos.ctrl.kdf.expr.VarBigDecimal;
import com.kingdee.bos.ctrl.kdf.expr.VarBigInteger;
import com.kingdee.bos.ctrl.kdf.expr.VarBoolean;
import com.kingdee.bos.ctrl.kdf.expr.VarByte;
import com.kingdee.bos.ctrl.kdf.expr.VarCalendar;
import com.kingdee.bos.ctrl.kdf.expr.VarCharacter;
import com.kingdee.bos.ctrl.kdf.expr.VarCurrency;
import com.kingdee.bos.ctrl.kdf.expr.VarDate;
import com.kingdee.bos.ctrl.kdf.expr.VarDouble;
import com.kingdee.bos.ctrl.kdf.expr.VarError;
import com.kingdee.bos.ctrl.kdf.expr.VarFloat;
import com.kingdee.bos.ctrl.kdf.expr.VarInteger;
import com.kingdee.bos.ctrl.kdf.expr.VarLong;
import com.kingdee.bos.ctrl.kdf.expr.VarNull;
import com.kingdee.bos.ctrl.kdf.expr.VarObject;
import com.kingdee.bos.ctrl.kdf.expr.VarShort;
import com.kingdee.bos.ctrl.kdf.expr.VarString;
import com.kingdee.bos.ctrl.kdf.expr.VarVariant;
import com.kingdee.bos.ctrl.kdf.util.CtrlFormatUtilities;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;

public class Variant
implements Cloneable,
Comparable {
    public static final short VT_NULL = 0;
    public static final short VT_BYTE = 1;
    public static final short VT_SHORT = 2;
    public static final short VT_INTEGER = 3;
    public static final short VT_LONG = 4;
    public static final short VT_FLOAT = 5;
    public static final short VT_DOUBLE = 6;
    public static final short VT_CHARACTER = 7;
    public static final short VT_BOOLEAN = 8;
    public static final short VT_BIGINTEGER = 9;
    public static final short VT_BIGDECIMAL = 10;
    public static final short VT_STRING = 11;
    public static final short VT_DATE = 12;
    public static final short VT_CALENDAR = 13;
    public static final short VT_CURRENCY = 14;
    public static final short VT_VARIANT = 15;
    public static final short VT_ERROR = 16;
    public static final short VT_OBJECT = 17;
    public static final short VT_VALUE = 256;
    public static final short VT_ARRAY = 512;
    public static final short VT_EMPTY = 8192;
    public static final short VT_INVALID = 16384;
    public static final Variant nullVariant = new Variant(null, 0);
    public static final Variant errorVariant = new Variant(new SyntaxErrorException(64L, "VT_ERROR"), 16);
    private static final String[] vtString = new String[]{"VT_NULL", "VT_BYTE", "VT_SHORT", "VT_INTEGER", "VT_LONG", "VT_FLOAT", "VT_DOUBLE", "VT_CHARACTER", "VT_BOOLEAN", "VT_BIGINTEGER", "VT_BIGDECIMAL", "VT_STRING", "VT_DATE", "VT_CALENDAR", "VT_CURRENCY", "VT_VARIANT", "VT_ERROR", "VT_OBJECT", "VT_EMPTY", "VT_INVALD"};
    private static final VarBase[] vars = new VarBase[]{new VarNull(), new VarByte(), new VarShort(), new VarInteger(), new VarLong(), new VarFloat(), new VarDouble(), new VarCharacter(), new VarBoolean(), new VarBigInteger(), new VarBigDecimal(), new VarString(), new VarDate(), new VarCalendar(), new VarCurrency(), new VarVariant(), new VarError(), new VarObject()};
    private static final Class[] dataType = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, Boolean.class, BigInteger.class, BigDecimal.class, String.class, Date.class, Calendar.class, Currency.class, Variant.class, SyntaxErrorException.class, Exception.class, Object.class};
    private static final int[] vt4DataType = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 17};
    private static final Class[] arrayType = new Class[]{byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class, char[].class, boolean[].class, Byte[].class, Short[].class, Integer[].class, Long[].class, Float[].class, Double[].class, Character[].class, Boolean[].class, BigInteger[].class, BigDecimal[].class, String[].class, Date[].class, Calendar[].class, Currency[].class, Variant[].class, SyntaxErrorException[].class, Exception[].class, Object[].class};
    private static final int[] vt4ArrayType = new int[]{769, 770, 771, 772, 773, 774, 775, 776, 513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 527, 528, 528, 529};
    private int vt;
    private Object value;

    public Variant() {
        this.value = null;
        this.vt = 8192;
    }

    public Variant(Object src) {
        if (src == null) {
            this.value = null;
            this.vt = 0;
        } else {
            this.setType(src);
            if (this.vt != 16384) {
                this.value = src;
            }
        }
    }

    public Variant(Object src, int vt) {
        this.value = src;
        this.vt = vt;
    }

    public Variant(Variant src) {
        this.setVariant(src);
    }

    public Variant(byte src) {
        this.value = new Byte(src);
        this.vt = 1;
    }

    public Variant(short src) {
        this.value = new Short(src);
        this.vt = 2;
    }

    public Variant(int src) {
        this.value = new Integer(src);
        this.vt = 3;
    }

    public Variant(long src) {
        this.value = new Long(src);
        this.vt = 4;
    }

    public Variant(float src) {
        this.value = new Float(src);
        this.vt = 5;
    }

    public Variant(double src) {
        this.value = new Double(src);
        this.vt = 6;
    }

    public Variant(char src) {
        this.value = new Character(src);
        this.vt = 7;
    }

    public Variant(boolean src) {
        this.value = src;
        this.vt = 8;
    }

    public void setObject(Object src) {
        if (src == null) {
            this.value = null;
            this.vt = 0;
        } else {
            this.setType(src);
            if (this.vt != 16384) {
                this.value = src;
            }
        }
    }

    public void setEmpty() {
        this.value = null;
        this.vt = 8192;
    }

    public static Variant getNewEmptyVariant() {
        return new Variant();
    }

    public void setObject(Object src, int vt) {
        this.value = src;
        this.vt = vt;
    }

    public void setVariant(Variant src) {
        if (src == null) {
            this.value = null;
            this.vt = 0;
        } else {
            this.value = src.value;
            this.vt = src.vt;
        }
    }

    public void setByte(byte src) {
        this.value = new Byte(src);
        this.vt = 1;
    }

    public void setShort(short src) {
        this.value = new Short(src);
        this.vt = 2;
    }

    public void setInt(int src) {
        this.value = new Integer(src);
        this.vt = 3;
    }

    public void setLong(long src) {
        this.value = new Long(src);
        this.vt = 4;
    }

    public void setFloat(float src) {
        this.value = new Float(src);
        this.vt = 5;
    }

    public void setDouble(double src) {
        this.value = new Double(src);
        this.vt = 6;
    }

    public void setChar(char src) {
        this.value = new Character(src);
        this.vt = 7;
    }

    public void setBoolean(boolean src) {
        this.value = src;
        this.vt = 8;
    }

    public Object getValue() {
        return this.value;
    }

    public Class getType() {
        if (this.value == null) {
            return null;
        }
        return this.value.getClass();
    }

    public int getVt() {
        return this.vt;
    }

    public String getVtAsString() {
        String ret = "";
        if (this.vt == 16384) {
            return "VT_INVALID";
        }
        if (this.vt == 8192) {
            return "VT_EMPTY";
        }
        if (this.isArray()) {
            ret = ret + "VT_ARRAY | ";
        }
        if (this.isValueType()) {
            ret = ret + "VT_VALUE | ";
        }
        ret = ret + vtString[(byte)this.vt];
        return ret;
    }

    public boolean isNull() {
        return this.vt == 0;
    }

    public boolean isEmpty() {
        return this.vt == 8192;
    }

    public boolean isInvalid() {
        return this.vt == 16384;
    }

    public boolean isError() {
        return this.vt == 16;
    }

    public boolean isNumber() {
        return this.vt < 7 && this.vt > 0 || this.vt == 9 || this.vt == 10;
    }

    public boolean isString() {
        return this.vt == 11;
    }

    public boolean isNumeric() {
        if (this.isNumber()) {
            return true;
        }
        if (this.vt == 11) {
            try {
                Util.stringToNumber((String)this.value);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        if (this.vt == 15) {
            return ((Variant)this.value).isNumeric();
        }
        return false;
    }

    public boolean isNumeric(Variant result) {
        if (this.isNumber()) {
            result.setVariant(this);
            return true;
        }
        if (this.vt == 11) {
            try {
                Number number = Util.stringToNumber((String)this.value);
                result.setObject(number);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        if (this.vt == 15) {
            return ((Variant)this.value).isNumeric(result);
        }
        return false;
    }

    public boolean isArray() {
        return (this.vt & 0x200) > 0;
    }

    protected boolean isValueType() {
        return (this.vt & 0x100) > 0;
    }

    public Object clone() {
        if (this.isArray()) {
            Class<?> type = this.value.getClass();
            int len = Array.getLength(this.value);
            Object obj = Array.newInstance(type.getComponentType(), len);
            System.arraycopy(this.value, 0, obj, 0, len);
            return new Variant(obj, this.vt);
        }
        return new Variant(this);
    }

    public byte byteValue() throws SyntaxErrorException {
        if (this.vt < 512) {
            switch (this.vt) {
                case 1: {
                    return (Byte)this.value;
                }
                case 2: {
                    return ((Short)this.value).byteValue();
                }
                case 3: {
                    return ((Integer)this.value).byteValue();
                }
                case 4: {
                    return ((Long)this.value).byteValue();
                }
                case 5: {
                    return ((Float)this.value).byteValue();
                }
                case 6: {
                    return ((Double)this.value).byteValue();
                }
                case 7: {
                    return (byte)((Character)this.value).charValue();
                }
                case 8: {
                    boolean bl = (Boolean)this.value;
                    return (byte)Util.booleanToInt(bl);
                }
                case 9: {
                    return ((BigInteger)this.value).byteValue();
                }
                case 10: {
                    return ((BigDecimal)this.value).byteValue();
                }
                case 11: {
                    byte ret = 0;
                    try {
                        ret = Byte.parseByte((String)this.value);
                    }
                    catch (NumberFormatException e) {
                        ExprError.goError(64L, e.getMessage());
                    }
                    return ret;
                }
                case 12: {
                    return (byte)((Date)this.value).getTime();
                }
                case 13: {
                    return (byte)((Calendar)this.value).getTimeInMillis();
                }
                case 14: {
                    return (byte)((Currency)this.value).getDefaultFractionDigits();
                }
                case 15: {
                    return ((Variant)this.value).byteValue();
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3abyte\u7c7b\u578b");
                    return 0;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3abyte\u7c7b\u578b");
                    return 0;
                }
            }
            return 0;
        }
        if (this.isArray()) {
            ExprError.goError(64L, "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3abyte\u7c7b\u578b");
        } else {
            switch (this.vt) {
                case 8192: {
                    ExprError.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3abyte\u7c7b\u578b");
                    break;
                }
                case 16384: {
                    ExprError.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3abyte\u7c7b\u578b");
                    break;
                }
                default: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3abyte\u7c7b\u578b");
                }
            }
        }
        return 0;
    }

    public short shortValue() throws SyntaxErrorException {
        if (this.vt < 512) {
            switch (this.vt) {
                case 1: {
                    return ((Byte)this.value).shortValue();
                }
                case 2: {
                    return (Short)this.value;
                }
                case 3: {
                    return ((Integer)this.value).shortValue();
                }
                case 4: {
                    return ((Long)this.value).shortValue();
                }
                case 5: {
                    return ((Float)this.value).shortValue();
                }
                case 6: {
                    return ((Double)this.value).shortValue();
                }
                case 7: {
                    return (short)((Character)this.value).charValue();
                }
                case 8: {
                    boolean bl = (Boolean)this.value;
                    return (short)Util.booleanToInt(bl);
                }
                case 9: {
                    return ((BigInteger)this.value).shortValue();
                }
                case 10: {
                    return ((BigDecimal)this.value).shortValue();
                }
                case 11: {
                    short ret = 0;
                    try {
                        ret = Short.parseShort((String)this.value);
                    }
                    catch (NumberFormatException e) {
                        ExprError.goError(64L, e.getMessage());
                    }
                    return ret;
                }
                case 12: {
                    return (short)((Date)this.value).getTime();
                }
                case 13: {
                    return (short)((Calendar)this.value).getTimeInMillis();
                }
                case 14: {
                    return (short)((Currency)this.value).getDefaultFractionDigits();
                }
                case 15: {
                    return ((Variant)this.value).shortValue();
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3ashort\u7c7b\u578b");
                    return 0;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3ashort\u7c7b\u578b");
                    return 0;
                }
            }
            return 0;
        }
        if (this.isArray()) {
            ExprError.goError(64L, "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3ashort\u7c7b\u578b");
        } else {
            switch (this.vt) {
                case 8192: {
                    ExprError.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3ashort\u7c7b\u578b");
                    break;
                }
                case 16384: {
                    ExprError.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3ashort\u7c7b\u578b");
                    break;
                }
                default: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3ashort\u7c7b\u578b");
                }
            }
        }
        return 0;
    }

    public int intValue() throws SyntaxErrorException {
        if (this.vt < 512) {
            switch (this.vt) {
                case 1: {
                    return ((Byte)this.value).intValue();
                }
                case 2: {
                    return ((Short)this.value).intValue();
                }
                case 3: {
                    return (Integer)this.value;
                }
                case 4: {
                    return ((Long)this.value).intValue();
                }
                case 5: {
                    return ((Float)this.value).intValue();
                }
                case 6: {
                    return ((Double)this.value).intValue();
                }
                case 7: {
                    return ((Character)this.value).charValue();
                }
                case 8: {
                    boolean bl = (Boolean)this.value;
                    return Util.booleanToInt(bl);
                }
                case 9: {
                    return ((BigInteger)this.value).intValue();
                }
                case 10: {
                    return ((BigDecimal)this.value).intValue();
                }
                case 11: {
                    int ret = 0;
                    try {
                        ret = Integer.parseInt((String)this.value);
                    }
                    catch (NumberFormatException e) {
                        ExprError.goError(64L, e.getMessage());
                    }
                    return ret;
                }
                case 12: {
                    return (int)((Date)this.value).getTime();
                }
                case 13: {
                    return (int)((Calendar)this.value).getTimeInMillis();
                }
                case 14: {
                    return ((Currency)this.value).getDefaultFractionDigits();
                }
                case 15: {
                    return ((Variant)this.value).intValue();
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aint\u7c7b\u578b");
                    return 0;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aint\u7c7b\u578b");
                    return 0;
                }
            }
            return 0;
        }
        if (this.isArray()) {
            ExprError.goError(64L, "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aint\u7c7b\u578b");
        } else {
            switch (this.vt) {
                case 8192: {
                    ExprError.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aint\u7c7b\u578b");
                    break;
                }
                case 16384: {
                    ExprError.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aint\u7c7b\u578b");
                    break;
                }
                default: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aint\u7c7b\u578b");
                }
            }
        }
        return 0;
    }

    public long longValue() throws SyntaxErrorException {
        if (this.vt < 512) {
            switch (this.vt) {
                case 1: {
                    return ((Byte)this.value).longValue();
                }
                case 2: {
                    return ((Short)this.value).longValue();
                }
                case 3: {
                    return ((Integer)this.value).longValue();
                }
                case 4: {
                    return (Long)this.value;
                }
                case 5: {
                    return ((Float)this.value).longValue();
                }
                case 6: {
                    return ((Double)this.value).longValue();
                }
                case 7: {
                    return ((Character)this.value).charValue();
                }
                case 8: {
                    boolean bl = (Boolean)this.value;
                    return Util.booleanToInt(bl);
                }
                case 9: {
                    return ((BigInteger)this.value).longValue();
                }
                case 10: {
                    return ((BigDecimal)this.value).longValue();
                }
                case 11: {
                    long ret = 0L;
                    try {
                        ret = Long.parseLong((String)this.value);
                    }
                    catch (NumberFormatException e) {
                        ExprError.goError(64L, e.getMessage());
                    }
                    return ret;
                }
                case 12: {
                    return ((Date)this.value).getTime();
                }
                case 13: {
                    return ((Calendar)this.value).getTimeInMillis();
                }
                case 14: {
                    return ((Currency)this.value).getDefaultFractionDigits();
                }
                case 15: {
                    return ((Variant)this.value).longValue();
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3along\u7c7b\u578b");
                    return 0L;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3along\u7c7b\u578b");
                    return 0L;
                }
            }
            return 0L;
        }
        if (this.isArray()) {
            ExprError.goError(64L, "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3along\u7c7b\u578b");
        } else {
            switch (this.vt) {
                case 8192: {
                    ExprError.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3along\u7c7b\u578b");
                    break;
                }
                case 16384: {
                    ExprError.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3along\u7c7b\u578b");
                    break;
                }
                default: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3along\u7c7b\u578b");
                }
            }
        }
        return 0L;
    }

    public float floatValue() throws SyntaxErrorException {
        if (this.vt < 512) {
            switch (this.vt) {
                case 1: {
                    return ((Byte)this.value).floatValue();
                }
                case 2: {
                    return ((Short)this.value).floatValue();
                }
                case 3: {
                    return ((Integer)this.value).floatValue();
                }
                case 4: {
                    return ((Long)this.value).floatValue();
                }
                case 5: {
                    return ((Float)this.value).floatValue();
                }
                case 6: {
                    return ((Double)this.value).floatValue();
                }
                case 7: {
                    return ((Character)this.value).charValue();
                }
                case 8: {
                    boolean bl = (Boolean)this.value;
                    return Util.booleanToInt(bl);
                }
                case 9: {
                    return ((BigInteger)this.value).floatValue();
                }
                case 10: {
                    return ((BigDecimal)this.value).floatValue();
                }
                case 11: {
                    float ret = 0.0f;
                    try {
                        ret = Float.parseFloat((String)this.value);
                    }
                    catch (NumberFormatException e) {
                        ExprError.goError(64L, e.getMessage());
                    }
                    return ret;
                }
                case 12: {
                    return ((Date)this.value).getTime();
                }
                case 13: {
                    return ((Calendar)this.value).getTimeInMillis();
                }
                case 14: {
                    return ((Currency)this.value).getDefaultFractionDigits();
                }
                case 15: {
                    return ((Variant)this.value).floatValue();
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3afloat\u7c7b\u578b");
                    return 0.0f;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3afloat\u7c7b\u578b");
                    return 0.0f;
                }
            }
            return 0.0f;
        }
        if (this.isArray()) {
            ExprError.goError(64L, "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3afloat\u7c7b\u578b");
        } else {
            switch (this.vt) {
                case 8192: {
                    ExprError.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3afloat\u7c7b\u578b");
                    break;
                }
                case 16384: {
                    ExprError.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3afloat\u7c7b\u578b");
                    break;
                }
                default: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3afloat\u7c7b\u578b");
                }
            }
        }
        return 0.0f;
    }

    public double doubleValue() throws SyntaxErrorException {
        if (this.vt < 512) {
            switch (this.vt) {
                case 1: {
                    return ((Byte)this.value).doubleValue();
                }
                case 2: {
                    return ((Short)this.value).doubleValue();
                }
                case 3: {
                    return ((Integer)this.value).doubleValue();
                }
                case 4: {
                    return ((Long)this.value).doubleValue();
                }
                case 5: {
                    return ((Float)this.value).doubleValue();
                }
                case 6: {
                    return (Double)this.value;
                }
                case 7: {
                    return ((Character)this.value).charValue();
                }
                case 8: {
                    boolean bl = (Boolean)this.value;
                    return Util.booleanToInt(bl);
                }
                case 9: {
                    return ((BigInteger)this.value).doubleValue();
                }
                case 10: {
                    return ((BigDecimal)this.value).doubleValue();
                }
                case 11: {
                    double ret = 0.0;
                    try {
                        ret = Double.parseDouble((String)this.value);
                    }
                    catch (NumberFormatException e) {
                        ExprError.goError(64L, e.getMessage());
                    }
                    return ret;
                }
                case 12: {
                    return ((Date)this.value).getTime();
                }
                case 13: {
                    return ((Calendar)this.value).getTimeInMillis();
                }
                case 14: {
                    return ((Currency)this.value).getDefaultFractionDigits();
                }
                case 15: {
                    return ((Variant)this.value).doubleValue();
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3adouble\u7c7b\u578b");
                    return 0.0;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3adouble\u7c7b\u578b");
                    return 0.0;
                }
            }
            return 0.0;
        }
        if (this.isArray()) {
            ExprError.goError(64L, "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3adouble\u7c7b\u578b");
        } else {
            switch (this.vt) {
                case 8192: {
                    ExprError.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3adouble\u7c7b\u578b");
                    break;
                }
                case 16384: {
                    ExprError.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3adouble\u7c7b\u578b");
                    break;
                }
                default: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3adouble\u7c7b\u578b");
                }
            }
        }
        return 0.0;
    }

    public char charValue() throws SyntaxErrorException {
        if (this.vt < 512) {
            switch (this.vt) {
                case 1: {
                    return (char)((Byte)this.value).byteValue();
                }
                case 2: {
                    return (char)((Short)this.value).shortValue();
                }
                case 3: {
                    return (char)((Integer)this.value).intValue();
                }
                case 4: {
                    return (char)((Long)this.value).longValue();
                }
                case 5: {
                    return (char)((Float)this.value).floatValue();
                }
                case 6: {
                    return (char)((Double)this.value).doubleValue();
                }
                case 7: {
                    return ((Character)this.value).charValue();
                }
                case 8: {
                    boolean bl = (Boolean)this.value;
                    return Util.booleanToChar(bl);
                }
                case 9: {
                    return (char)((BigInteger)this.value).intValue();
                }
                case 10: {
                    return (char)((BigDecimal)this.value).intValue();
                }
                case 11: {
                    if (((String)this.value).length() == 1) {
                        return ((String)this.value).charAt(0);
                    }
                    ExprError.goError(64L, "String\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    return '\u0000';
                }
                case 12: {
                    ExprError.goError(64L, "Date\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    return '\u0000';
                }
                case 13: {
                    ExprError.goError(64L, "Calendar\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    return '\u0000';
                }
                case 14: {
                    ExprError.goError(64L, "Currency\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    return '\u0000';
                }
                case 15: {
                    return ((Variant)this.value).charValue();
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    return '\u0000';
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    return '\u0000';
                }
            }
            return '\u0000';
        }
        if (this.isArray()) {
            ExprError.goError(64L, "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
        } else {
            switch (this.vt) {
                case 8192: {
                    ExprError.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    break;
                }
                case 16384: {
                    ExprError.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    break;
                }
                default: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                }
            }
        }
        return '\u0000';
    }

    public boolean booleanValue() throws SyntaxErrorException {
        if (this.vt < 512) {
            switch (this.vt) {
                case 8: {
                    return (Boolean)this.value;
                }
                case 7: {
                    char temp = ((Character)this.value).charValue();
                    if (temp == 'T') {
                        return true;
                    }
                    if (temp == 'F') {
                        return false;
                    }
                    ExprError.goError(64L, "Character\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aboolean\u7c7b\u578b");
                }
                case 11: {
                    if (((String)this.value).equalsIgnoreCase("true")) {
                        return true;
                    }
                    if (((String)this.value).equalsIgnoreCase("false")) {
                        return false;
                    }
                    ExprError.goError(64L, "String\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aboolean\u7c7b\u578b");
                }
                case 12: {
                    ExprError.goError(64L, "Date\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aboolean\u7c7b\u578b");
                    return false;
                }
                case 13: {
                    ExprError.goError(64L, "Calendar\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aboolean\u7c7b\u578b");
                    return false;
                }
                case 14: {
                    ExprError.goError(64L, "Currency\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aboolean\u7c7b\u578b");
                    return false;
                }
                case 15: {
                    return ((Variant)this.value).booleanValue();
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aboolean\u7c7b\u578b");
                    return false;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aboolean\u7c7b\u578b");
                    return false;
                }
                case 0: {
                    return false;
                }
            }
            return this.intValue() != 0;
        }
        if (this.isArray()) {
            ExprError.goError(64L, "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
        } else {
            switch (this.vt) {
                case 8192: {
                    ExprError.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    break;
                }
                case 16384: {
                    ExprError.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    break;
                }
                default: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                }
            }
        }
        return false;
    }

    public BigInteger toBigInteger() throws SyntaxErrorException {
        if (this.vt < 512) {
            switch (this.vt) {
                case 1: {
                    return BigInteger.valueOf(((Byte)this.value).byteValue());
                }
                case 2: {
                    return BigInteger.valueOf(((Short)this.value).shortValue());
                }
                case 3: {
                    return BigInteger.valueOf(((Integer)this.value).intValue());
                }
                case 4: {
                    return BigInteger.valueOf((Long)this.value);
                }
                case 5: {
                    return BigInteger.valueOf((long)((Float)this.value).floatValue());
                }
                case 6: {
                    return BigInteger.valueOf((long)((Double)this.value).doubleValue());
                }
                case 7: {
                    return BigInteger.valueOf(((Character)this.value).charValue());
                }
                case 8: {
                    boolean bl = (Boolean)this.value;
                    return BigInteger.valueOf(Util.booleanToInt(bl));
                }
                case 9: {
                    return (BigInteger)this.value;
                }
                case 10: {
                    return ((BigDecimal)this.value).toBigInteger();
                }
                case 11: {
                    BigInteger ret = null;
                    try {
                        ret = new BigInteger((String)this.value);
                    }
                    catch (Exception e) {
                        ExprError.goError(64L, "String\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal\u7c7b\u578b");
                    }
                    return ret;
                }
                case 12: {
                    return BigInteger.valueOf(((Date)this.value).getTime());
                }
                case 13: {
                    return BigInteger.valueOf(((Calendar)this.value).getTimeInMillis());
                }
                case 14: {
                    return BigInteger.valueOf(((Currency)this.value).getDefaultFractionDigits());
                }
                case 15: {
                    return ((Variant)this.value).toBigInteger();
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aBigInteger\u7c7b\u578b");
                    return null;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aBigInteger\u7c7b\u578b");
                    return null;
                }
                case 0: {
                    return BigInteger.valueOf(0L);
                }
            }
            return null;
        }
        if (this.isArray()) {
            ExprError.goError(64L, "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aBigInteger\u7c7b\u578b");
        } else {
            switch (this.vt) {
                case 8192: {
                    ExprError.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aBigInteger\u7c7b\u578b");
                    break;
                }
                case 16384: {
                    ExprError.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aBigInteger\u7c7b\u578b");
                    break;
                }
                default: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aBigInteger\u7c7b\u578b");
                }
            }
        }
        return null;
    }

    public BigDecimal toBigDecimal() throws SyntaxErrorException {
        if (this.vt < 512) {
            switch (this.vt) {
                case 1: {
                    return BigDecimal.valueOf(((Byte)this.value).byteValue());
                }
                case 2: {
                    return BigDecimal.valueOf(((Short)this.value).shortValue());
                }
                case 3: {
                    return BigDecimal.valueOf(((Integer)this.value).intValue());
                }
                case 4: {
                    return BigDecimal.valueOf((Long)this.value);
                }
                case 5: {
                    return new BigDecimal(((Float)this.value).toString());
                }
                case 6: {
                    return new BigDecimal(((Double)this.value).toString());
                }
                case 7: {
                    return BigDecimal.valueOf(((Character)this.value).charValue());
                }
                case 8: {
                    boolean bl = (Boolean)this.value;
                    return BigDecimal.valueOf(Util.booleanToInt(bl));
                }
                case 9: {
                    return new BigDecimal((BigInteger)this.value);
                }
                case 10: {
                    return (BigDecimal)this.value;
                }
                case 11: {
                    BigDecimal ret = null;
                    try {
                        String integerPart;
                        DecimalFormatSymbols sym = CtrlFormatUtilities.getDecimalFormatSymbols();
                        int dotIndex = -1;
                        String decimalString = (String)this.value;
                        dotIndex = decimalString.indexOf(String.valueOf(sym.getDecimalSeparator()));
                        String decimalPart = null;
                        if (dotIndex > 0) {
                            integerPart = decimalString.substring(0, dotIndex);
                            decimalPart = decimalString.substring(dotIndex + 1);
                        } else {
                            integerPart = decimalString;
                        }
                        String dot = String.valueOf(sym.getGroupingSeparator());
                        if (dot.equals(".")) {
                            dot = "\\" + dot;
                        }
                        integerPart = integerPart.replaceAll(dot, ",");
                        integerPart = integerPart.replaceAll(dot, ",");
                        ret = new BigDecimal(integerPart + (decimalPart == null ? "" : "." + decimalPart));
                    }
                    catch (Exception e) {
                        ExprError.goError(64L, "String\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal\u7c7b\u578b");
                    }
                    return ret;
                }
                case 12: {
                    return BigDecimal.valueOf(((Date)this.value).getTime());
                }
                case 13: {
                    return BigDecimal.valueOf(((Calendar)this.value).getTimeInMillis());
                }
                case 14: {
                    return BigDecimal.valueOf(((Currency)this.value).getDefaultFractionDigits());
                }
                case 15: {
                    return ((Variant)this.value).toBigDecimal();
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal\u7c7b\u578b");
                    return null;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal\u7c7b\u578b");
                    return null;
                }
                case 0: {
                    return BigDecimal.valueOf(0L);
                }
            }
            return null;
        }
        if (this.isArray()) {
            ExprError.goError(64L, "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal\u7c7b\u578b");
        } else {
            switch (this.vt) {
                case 8192: {
                    ExprError.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal\u7c7b\u578b");
                    break;
                }
                case 16384: {
                    ExprError.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal\u7c7b\u578b");
                    break;
                }
                default: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal\u7c7b\u578b");
                }
            }
        }
        return null;
    }

    public String toString() {
        if (this.vt < 512) {
            if (this.value == null) {
                switch (this.vt) {
                    case 0: {
                        return "";
                    }
                }
                return "";
            }
            if (this.vt == 10) {
                return com.kingdee.bos.ctrl.common.variant.Util.bigDecimalToPlainString((BigDecimal)this.value);
            }
            return this.value.toString();
        }
        int len = 0;
        switch (this.vt) {
            case 519: {
                len = Array.getLength(this.value);
                char[] ca = new char[len];
                for (int i = 0; i < len; ++i) {
                    ca[i] = ((Character[])this.value)[i].charValue();
                }
                return new String(ca);
            }
            case 775: {
                return new String((char[])this.value);
            }
            case 513: {
                len = Array.getLength(this.value);
                byte[] bta = new byte[len];
                for (int i = 0; i < len; ++i) {
                    bta[i] = ((Byte[])this.value)[i];
                }
                return new String(bta);
            }
            case 769: {
                return new String((byte[])this.value);
            }
            case 8192: {
                return "";
            }
            case 16384: {
                return "";
            }
        }
        return this.value.toString();
    }

    public Date toDate() throws SyntaxErrorException {
        if (this.vt < 512) {
            switch (this.vt) {
                case 7: {
                    ExprError.goError(64L, "Character\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aDate\u7c7b\u578b");
                    return null;
                }
                case 8: {
                    ExprError.goError(64L, "Boolean\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aDate\u7c7b\u578b");
                    return null;
                }
                case 11: {
                    Date ret = Util.stringToDate((String)this.value);
                    if (ret == null) {
                        Variant var = new Variant();
                        if (this.isNumeric(var)) {
                            ret = new Date(var.longValue());
                        } else {
                            ExprError.goError(64L, "String\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aDate\u7c7b\u578b");
                        }
                    }
                    return ret;
                }
                case 12: {
                    return (Date)this.value;
                }
                case 13: {
                    return ((Calendar)this.value).getTime();
                }
                case 15: {
                    return ((Variant)this.value).toDate();
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aDate\u7c7b\u578b");
                    return null;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aDate\u7c7b\u578b");
                    return null;
                }
                case 0: {
                    return new Date(0L);
                }
            }
            return new Date(this.longValue());
        }
        if (this.isArray()) {
            ExprError.goError(64L, "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3ashort\u7c7b\u578b");
        } else {
            switch (this.vt) {
                case 8192: {
                    ExprError.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3ashort\u7c7b\u578b");
                    break;
                }
                case 16384: {
                    ExprError.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3ashort\u7c7b\u578b");
                    break;
                }
                default: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3ashort\u7c7b\u578b");
                }
            }
        }
        return null;
    }

    public Calendar toCalendar() throws SyntaxErrorException {
        if (this.vt < 512) {
            switch (this.vt) {
                case 7: {
                    ExprError.goError(64L, "Character\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
                    return null;
                }
                case 8: {
                    ExprError.goError(64L, "Boolean\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
                    return null;
                }
                case 11: {
                    Calendar ret = Calendar.getInstance();
                    Date dt = Util.stringToDate((String)this.value);
                    if (dt == null) {
                        Variant var = new Variant();
                        if (this.isNumeric(var)) {
                            dt = new Date(var.longValue());
                        } else {
                            ExprError.goError(64L, "String\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aDate\u7c7b\u578b");
                        }
                    }
                    ret.setTime(dt);
                    return ret;
                }
                case 12: {
                    Calendar ret = Calendar.getInstance();
                    ret.setTime((Date)this.value);
                    return ret;
                }
                case 13: {
                    return (Calendar)this.value;
                }
                case 15: {
                    return ((Variant)this.value).toCalendar();
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
                    return null;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
                    return null;
                }
                case 0: {
                    return Calendar.getInstance();
                }
            }
            Calendar ret = Calendar.getInstance();
            ret.setTimeInMillis(this.longValue());
            return ret;
        }
        if (this.isArray()) {
            ExprError.goError(64L, "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
        } else {
            switch (this.vt) {
                case 8192: {
                    ExprError.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
                    break;
                }
                case 16384: {
                    ExprError.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
                    break;
                }
                default: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
                }
            }
        }
        return null;
    }

    public Currency toCurrency() {
        return null;
    }

    public byte[] toByteArray() throws SyntaxErrorException {
        if (this.isNumber()) {
            if (this.vt == 9) {
                return ((BigInteger)this.value).toByteArray();
            }
            if (this.vt == 10) {
                return ((BigDecimal)this.value).unscaledValue().toByteArray();
            }
            return this.toBigInteger().toByteArray();
        }
        if (this.vt == 769) {
            return (byte[])this.value;
        }
        if (this.vt == 513) {
            int len = Array.getLength(this.value);
            byte[] ret = new byte[len];
            for (int i = 0; i < len; ++i) {
                ret[i] = ((Byte[])this.value)[i];
            }
            return ret;
        }
        if (this.vt == 11) {
            return ((String)this.value).getBytes();
        }
        if (this.vt == 0) {
            return null;
        }
        return this.toString().getBytes();
    }

    public char[] toCharArray() {
        if (this.vt == 11) {
            return ((String)this.value).toCharArray();
        }
        if (this.vt == 775) {
            return (char[])this.value;
        }
        if (this.vt == 519) {
            int len = Array.getLength(this.value);
            char[] ret = new char[len];
            for (int i = 0; i < len; ++i) {
                ret[i] = ((Character[])this.value)[i].charValue();
            }
            return ret;
        }
        if (this.vt == 0) {
            return null;
        }
        return this.toString().toCharArray();
    }

    public Variant add(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (right.vt == 0) {
            result.setVariant(this);
            return result;
        }
        if (this.vt < 512) {
            if (this.vt > 0 && this.vt < 7 && right.vt < 7) {
                int type = right.vt > this.vt ? right.vt : this.vt;
                switch (type) {
                    case 1: {
                        Util.add(((Number)this.value).byteValue(), ((Number)right.value).byteValue(), result);
                        break;
                    }
                    case 2: {
                        Util.add(((Number)this.value).shortValue(), ((Number)right.value).shortValue(), result);
                        break;
                    }
                    case 3: {
                        Util.add(((Number)this.value).intValue(), ((Number)right.value).intValue(), result);
                        break;
                    }
                    case 4: {
                        Util.add(((Number)this.value).longValue(), ((Number)right.value).longValue(), result);
                        break;
                    }
                    case 5: {
                        Util.add(((Number)this.value).floatValue(), ((Number)right.value).floatValue(), result);
                        break;
                    }
                    case 6: {
                        Util.add(((Number)this.value).doubleValue(), ((Number)right.value).doubleValue(), result);
                        break;
                    }
                    default: {
                        return nullVariant;
                    }
                }
            } else {
                vars[this.vt].add(this, right, result);
            }
        }
        return result;
    }

    public Variant add(Variant right) throws SyntaxErrorException {
        return this.add(right, this);
    }

    public Variant subtract(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (right.vt == 0) {
            result.setVariant(this);
            return result;
        }
        if (this.vt < 512) {
            if (this.vt > 0 && this.vt < 7 && right.vt < 7) {
                int type = right.vt > this.vt ? right.vt : this.vt;
                switch (type) {
                    case 1: {
                        Util.subtract(((Number)this.value).byteValue(), ((Number)right.value).byteValue(), result);
                        break;
                    }
                    case 2: {
                        Util.subtract(((Number)this.value).shortValue(), ((Number)right.value).shortValue(), result);
                        break;
                    }
                    case 3: {
                        Util.subtract(((Number)this.value).intValue(), ((Number)right.value).intValue(), result);
                        break;
                    }
                    case 4: {
                        Util.subtract(((Number)this.value).longValue(), ((Number)right.value).longValue(), result);
                        break;
                    }
                    case 5: {
                        Util.subtract(((Number)this.value).floatValue(), ((Number)right.value).floatValue(), result);
                        break;
                    }
                    case 6: {
                        Util.subtract(((Number)this.value).doubleValue(), ((Number)right.value).doubleValue(), result);
                        break;
                    }
                    default: {
                        return nullVariant;
                    }
                }
            } else {
                vars[this.vt].subtract(this, right, result);
            }
        }
        return result;
    }

    public Variant subtract(Variant right) throws SyntaxErrorException {
        return this.subtract(right, this);
    }

    public Variant multiply(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (right.vt == 0) {
            result.setVariant(nullVariant);
            return nullVariant;
        }
        if (this.vt < 512) {
            if (this.vt > 0 && this.vt < 7 && right.vt < 7) {
                int type = right.vt > this.vt ? right.vt : this.vt;
                switch (type) {
                    case 1: {
                        Util.multiply(((Number)this.value).byteValue(), ((Number)right.value).byteValue(), result);
                        break;
                    }
                    case 2: {
                        Util.multiply(((Number)this.value).shortValue(), ((Number)right.value).shortValue(), result);
                        break;
                    }
                    case 3: {
                        Util.multiply(((Number)this.value).intValue(), ((Number)right.value).intValue(), result);
                        break;
                    }
                    case 4: {
                        Util.multiply(((Number)this.value).longValue(), ((Number)right.value).longValue(), result);
                        break;
                    }
                    case 5: {
                        Util.multiply(((Number)this.value).floatValue(), ((Number)right.value).floatValue(), result);
                        break;
                    }
                    case 6: {
                        Util.multiply(((Number)this.value).doubleValue(), ((Number)right.value).doubleValue(), result);
                        break;
                    }
                    default: {
                        return nullVariant;
                    }
                }
            } else {
                vars[this.vt].multiply(this, right, result);
            }
        }
        return result;
    }

    public Variant multiply(Variant right) throws SyntaxErrorException {
        return this.multiply(right, this);
    }

    public Variant divide(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (this.vt < 512) {
            if (this.vt > 0 && this.vt < 10 || this.vt == 11) {
                double r = right.doubleValue();
                if (r == 0.0) {
                    ExprError.goError(2L, "\u9664\u6570\u4e3a\u96f6");
                } else {
                    BigDecimal ret = new BigDecimal(Double.toString(this.doubleValue())).divide(new BigDecimal(Double.toString(r)), 10, 4);
                    result.setObject(ret, 10);
                }
            } else {
                vars[(byte)this.vt].divide(this, right, result);
            }
        }
        NumberUtil.cutZero(result);
        return result;
    }

    public Variant divide(Variant right) throws SyntaxErrorException {
        return this.divide(right, this);
    }

    public Variant negate(Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, result)) {
            return result;
        }
        if (this.vt < 512) {
            switch (this.vt) {
                case 1: {
                    result.setByte(-((Byte)this.value).byteValue());
                    break;
                }
                case 2: {
                    result.setShort(-((Short)this.value).shortValue());
                    break;
                }
                case 3: {
                    result.setInt(-((Integer)this.value).intValue());
                    break;
                }
                case 4: {
                    result.setLong(-((Long)this.value).longValue());
                    break;
                }
                case 5: {
                    result.setFloat(-((Float)this.value).floatValue());
                    break;
                }
                case 6: {
                    result.setDouble(-((Double)this.value).doubleValue());
                    break;
                }
                case 7: {
                    result.setInt(-((Character)this.value).charValue());
                    break;
                }
                case 8: {
                    result.setBoolean((Boolean)this.value == false);
                    break;
                }
                case 9: {
                    result.setObject(((BigInteger)this.value).negate(), 9);
                    break;
                }
                case 10: {
                    result.setObject(((BigDecimal)this.value).negate(), 10);
                    break;
                }
                case 11: {
                    Variant var = new Variant(Util.stringToNumber((String)this.value));
                    var.negate(result);
                    break;
                }
                case 12: {
                    result.setVariant(this);
                    break;
                }
                case 13: {
                    result.setVariant(this);
                    break;
                }
                case 14: {
                    result.setVariant(this);
                    break;
                }
                case 15: {
                    ((Variant)this.value).negate(result);
                    break;
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u6267\u884c\u8fd0\u7b97");
                    break;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b, \u65e0\u6cd5\u6267\u884c\u8fd0\u7b97");
                    break;
                }
                default: {
                    result.setVariant(nullVariant);
                }
            }
        }
        return result;
    }

    public Variant negate() throws SyntaxErrorException {
        return this.negate(this);
    }

    public Variant mod(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (right.vt == 0) {
            ExprError.goError(2L, "\u9664\u6570\u4e3a\u96f6");
        }
        if (this.vt < 512) {
            if (this.vt > 0 && this.vt < 7 && right.vt > 0 && right.vt < 7) {
                int type = right.vt > this.vt ? right.vt : this.vt;
                switch (type) {
                    case 1: {
                        Util.mod(((Number)this.value).byteValue(), ((Number)right.value).byteValue(), result);
                        break;
                    }
                    case 2: {
                        Util.mod(((Number)this.value).shortValue(), ((Number)right.value).shortValue(), result);
                        break;
                    }
                    case 3: {
                        Util.mod(((Number)this.value).intValue(), ((Number)right.value).intValue(), result);
                        break;
                    }
                    case 4: {
                        Util.mod(((Number)this.value).longValue(), ((Number)right.value).longValue(), result);
                        break;
                    }
                    case 5: {
                        Util.mod(((Number)this.value).floatValue(), ((Number)right.value).floatValue(), result);
                        break;
                    }
                    case 6: {
                        Util.mod(((Number)this.value).doubleValue(), ((Number)right.value).doubleValue(), result);
                        break;
                    }
                    default: {
                        return nullVariant;
                    }
                }
            } else {
                vars[this.vt].mod(this, right, result);
            }
        }
        return result;
    }

    public Variant mod(Variant right) throws SyntaxErrorException {
        return this.mod(right, this);
    }

    public Variant pow(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        result.setDouble(Math.pow(this.doubleValue(), right.doubleValue()));
        return result;
    }

    public Variant pow(Variant right) throws SyntaxErrorException {
        return this.pow(right, this);
    }

    public Variant abs(Variant result) throws SyntaxErrorException {
        if (this.vt == 16) {
            result.setVariant(this);
            return result;
        }
        if (this.vt < 512) {
            switch (this.vt) {
                case 1: {
                    result.setInt(Math.abs(((Byte)this.value).byteValue()));
                    break;
                }
                case 2: {
                    result.setInt(Math.abs(((Short)this.value).shortValue()));
                    break;
                }
                case 3: {
                    result.setInt(Math.abs((Integer)this.value));
                    break;
                }
                case 4: {
                    result.setLong(Math.abs((Long)this.value));
                    break;
                }
                case 5: {
                    result.setFloat(Math.abs(((Float)this.value).floatValue()));
                    break;
                }
                case 6: {
                    result.setDouble(Math.abs((Double)this.value));
                    break;
                }
                case 7: {
                    result.setVariant(this);
                    break;
                }
                case 8: {
                    result.setVariant(this);
                    break;
                }
                case 9: {
                    result.setObject(((BigInteger)this.value).abs(), 9);
                    break;
                }
                case 10: {
                    result.setObject(((BigDecimal)this.value).abs(), 10);
                    break;
                }
                case 11: {
                    Variant var = new Variant(Util.stringToNumber((String)this.value));
                    var.abs(result);
                    break;
                }
                case 12: {
                    result.setVariant(this);
                    break;
                }
                case 13: {
                    result.setVariant(this);
                    break;
                }
                case 14: {
                    result.setVariant(this);
                    break;
                }
                case 15: {
                    ((Variant)this.value).abs(result);
                    break;
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u6267\u884c\u8fd0\u7b97");
                    break;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b, \u65e0\u6cd5\u6267\u884c\u8fd0\u7b97");
                    break;
                }
                default: {
                    result.setVariant(nullVariant);
                }
            }
        }
        return result;
    }

    public Variant abs() throws SyntaxErrorException {
        return this.abs(this);
    }

    public Variant fix(Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, result)) {
            return result;
        }
        if (this.vt < 512) {
            switch (this.vt) {
                case 1: {
                    result.setByte((Byte)this.value);
                    break;
                }
                case 2: {
                    result.setShort((Short)this.value);
                    break;
                }
                case 3: {
                    result.setInt((Integer)this.value);
                    break;
                }
                case 4: {
                    result.setLong((Long)this.value);
                    break;
                }
                case 5: {
                    float f = ((Float)this.value).floatValue();
                    if (f < 0.0f) {
                        f += 1.0f;
                    }
                    result.setDouble(Math.floor(f));
                    break;
                }
                case 6: {
                    double d = (Double)this.value;
                    if (d < 0.0) {
                        d += 1.0;
                    }
                    result.setDouble(Math.floor(d));
                    break;
                }
                case 7: {
                    result.setVariant(this);
                    break;
                }
                case 8: {
                    result.setVariant(this);
                    break;
                }
                case 9: {
                    result.setObject(this.value, 9);
                    break;
                }
                case 10: {
                    result.setObject(((BigDecimal)this.value).toBigInteger(), 9);
                    break;
                }
                case 11: {
                    result.setObject(new BigDecimal((String)this.value).toBigInteger(), 9);
                    break;
                }
                case 12: {
                    result.setVariant(this);
                    break;
                }
                case 13: {
                    result.setVariant(this);
                    break;
                }
                case 14: {
                    result.setVariant(this);
                    break;
                }
                case 15: {
                    ((Variant)this.value).fix(result);
                    break;
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u6267\u884c\u8fd0\u7b97");
                    break;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b, \u65e0\u6cd5\u6267\u884c\u8fd0\u7b97");
                    break;
                }
                default: {
                    result.setVariant(nullVariant);
                }
            }
        }
        return result;
    }

    public Variant fix() throws SyntaxErrorException {
        return this.fix(this);
    }

    public Variant intpart(Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, result)) {
            return result;
        }
        if (this.vt < 512) {
            switch (this.vt) {
                case 1: {
                    result.setByte((Byte)this.value);
                    break;
                }
                case 2: {
                    result.setShort((Short)this.value);
                    break;
                }
                case 3: {
                    result.setInt((Integer)this.value);
                    break;
                }
                case 4: {
                    result.setLong((Long)this.value);
                    break;
                }
                case 5: {
                    float f = ((Float)this.value).floatValue();
                    result.setDouble(Math.floor(f));
                    break;
                }
                case 6: {
                    double d = (Double)this.value;
                    result.setDouble(Math.floor(d));
                    break;
                }
                case 7: {
                    result.setVariant(this);
                    break;
                }
                case 8: {
                    result.setVariant(this);
                    break;
                }
                case 9: {
                    result.setObject(this.value, 9);
                    break;
                }
                case 10: {
                    BigDecimal bi = (BigDecimal)this.value;
                    if (bi.signum() < 0) {
                        result.setObject(bi.subtract(BigDecimal.valueOf(1L)), 9);
                        break;
                    }
                    result.setObject(bi.toBigInteger(), 9);
                    break;
                }
                case 11: {
                    BigDecimal bi = new BigDecimal((String)this.value);
                    if (bi.signum() < 0) {
                        result.setObject(bi.subtract(BigDecimal.valueOf(1L)), 9);
                        break;
                    }
                    result.setObject(bi.toBigInteger(), 9);
                    break;
                }
                case 12: {
                    result.setVariant(this);
                    break;
                }
                case 13: {
                    result.setVariant(this);
                    break;
                }
                case 14: {
                    result.setVariant(this);
                    break;
                }
                case 15: {
                    ((Variant)this.value).intpart(result);
                    break;
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u6267\u884c\u8fd0\u7b97");
                    break;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b, \u65e0\u6cd5\u6267\u884c\u8fd0\u7b97");
                    break;
                }
                default: {
                    result.setVariant(nullVariant);
                }
            }
        }
        return result;
    }

    public Variant intpart() throws SyntaxErrorException {
        return this.intpart(this);
    }

    public Variant round(int decimals, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, result)) {
            return result;
        }
        if (decimals < 0) {
            ExprError.goError(64L, "\u56db\u820d\u4e94\u5165\u7684\u53c2\u6570(\u5c0f\u6570\u4f4d\u6570)\u4e3a\u8d1f\u503c!");
        }
        if (this.vt < 512) {
            switch (this.vt) {
                case 5: {
                    double d = Math.pow(10.0, decimals);
                    result.setInt((int)((double)Math.round(d * (double)((Float)this.value).floatValue()) / d));
                    break;
                }
                case 6: {
                    double d = Math.pow(10.0, decimals);
                    result.setLong((long)((double)Math.round(d * (Double)this.value) / d));
                    break;
                }
                case 10: {
                    BigDecimal bdec = (BigDecimal)this.value;
                    bdec = bdec.setScale(decimals, 4);
                    result.setObject(bdec, 10);
                    break;
                }
                case 11: {
                    Variant var = new Variant(Util.stringToNumber((String)this.value));
                    var.round(decimals, result);
                    break;
                }
                case 15: {
                    ((Variant)this.value).fix(result);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: {
                    result.setVariant(this);
                    break;
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u6267\u884c\u8fd0\u7b97");
                    break;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b, \u65e0\u6cd5\u6267\u884c\u8fd0\u7b97");
                    break;
                }
                default: {
                    result.setVariant(nullVariant);
                }
            }
        }
        return result;
    }

    public Variant round(int decimals) throws SyntaxErrorException {
        return this.round(decimals, this);
    }

    public Variant and(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (right.vt == 0) {
            result.setVariant(nullVariant);
            return nullVariant;
        }
        if (this.vt < 512) {
            if (this.vt > 0 && this.vt < 7 && right.vt < 7) {
                int type = right.vt > this.vt ? right.vt : this.vt;
                switch (type) {
                    case 1: {
                        Util.and(((Number)this.value).byteValue(), ((Number)right.value).byteValue(), result);
                        break;
                    }
                    case 2: {
                        Util.and(((Number)this.value).shortValue(), ((Number)right.value).shortValue(), result);
                        break;
                    }
                    case 3: {
                        Util.and(((Number)this.value).intValue(), ((Number)right.value).intValue(), result);
                        break;
                    }
                    case 4: {
                        Util.and(((Number)this.value).longValue(), ((Number)right.value).longValue(), result);
                        break;
                    }
                    case 5: {
                        Util.and(((Number)this.value).floatValue(), ((Number)right.value).floatValue(), result);
                        break;
                    }
                    case 6: {
                        Util.and(((Number)this.value).doubleValue(), ((Number)right.value).doubleValue(), result);
                        break;
                    }
                    default: {
                        return nullVariant;
                    }
                }
            } else {
                vars[this.vt].and(this, right, result);
            }
        }
        return result;
    }

    public Variant and(Variant right) throws SyntaxErrorException {
        return this.and(right, this);
    }

    public Variant or(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (right.vt == 0) {
            result.setVariant(this);
            return result;
        }
        if (this.vt < 512) {
            if (this.vt > 0 && this.vt < 7 && right.vt < 7) {
                int type = right.vt > this.vt ? right.vt : this.vt;
                switch (type) {
                    case 1: {
                        Util.or(((Number)this.value).byteValue(), ((Number)right.value).byteValue(), result);
                        break;
                    }
                    case 2: {
                        Util.or(((Number)this.value).shortValue(), ((Number)right.value).shortValue(), result);
                        break;
                    }
                    case 3: {
                        Util.or(((Number)this.value).intValue(), ((Number)right.value).intValue(), result);
                        break;
                    }
                    case 4: {
                        Util.or(((Number)this.value).longValue(), ((Number)right.value).longValue(), result);
                        break;
                    }
                    case 5: {
                        Util.or(((Number)this.value).floatValue(), ((Number)right.value).floatValue(), result);
                        break;
                    }
                    case 6: {
                        Util.or(((Number)this.value).doubleValue(), ((Number)right.value).doubleValue(), result);
                        break;
                    }
                    default: {
                        return nullVariant;
                    }
                }
            } else {
                vars[this.vt].or(this, right, result);
            }
        }
        return result;
    }

    public Variant or(Variant right) throws SyntaxErrorException {
        return this.or(right, this);
    }

    public Variant not(Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, result)) {
            return result;
        }
        if (this.vt < 512) {
            switch (this.vt) {
                case 1: {
                    result.setByte(~((Byte)this.value).byteValue());
                    break;
                }
                case 2: {
                    result.setShort(~((Short)this.value).shortValue());
                    break;
                }
                case 3: {
                    result.setInt(~((Integer)this.value).intValue());
                    break;
                }
                case 4: {
                    result.setLong((long)((Long)this.value ^ 0xFFFFFFFFFFFFFFFFL));
                    break;
                }
                case 5: {
                    result.setFloat(((Float)this.value).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    break;
                }
                case 6: {
                    result.setDouble(((Double)this.value).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    break;
                }
                case 7: {
                    result.setInt(~((Character)this.value).charValue());
                    break;
                }
                case 8: {
                    result.setBoolean((Boolean)this.value == false);
                    break;
                }
                case 9: {
                    result.setObject(((BigInteger)this.value).not(), 9);
                    break;
                }
                case 10: {
                    result.setObject(((BigDecimal)this.value).toBigInteger().not(), 9);
                    break;
                }
                case 11: {
                    Variant var = new Variant(Util.stringToNumber((String)this.value));
                    var.not(result);
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    result.setVariant(this);
                    break;
                }
                case 15: {
                    ((Variant)this.value).not(result);
                    break;
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u6267\u884c\u8fd0\u7b97");
                    break;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b, \u65e0\u6cd5\u6267\u884c\u8fd0\u7b97");
                    break;
                }
                default: {
                    result.setVariant(nullVariant);
                }
            }
        }
        return result;
    }

    public Variant not() throws SyntaxErrorException {
        return this.not(this);
    }

    public Variant xor(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (right.vt == 0) {
            if (this.vt == 0) {
                result.setBoolean(false);
            } else {
                result.setBoolean(true);
            }
            return result;
        }
        if (this.vt < 512) {
            if (this.vt > 0 && this.vt < 7 && right.vt < 7) {
                int type = right.vt > this.vt ? right.vt : this.vt;
                switch (type) {
                    case 1: {
                        Util.xor(((Number)this.value).byteValue(), ((Number)right.value).byteValue(), result);
                        break;
                    }
                    case 2: {
                        Util.xor(((Number)this.value).shortValue(), ((Number)right.value).shortValue(), result);
                        break;
                    }
                    case 3: {
                        Util.xor(((Number)this.value).intValue(), ((Number)right.value).intValue(), result);
                        break;
                    }
                    case 4: {
                        Util.xor(((Number)this.value).longValue(), ((Number)right.value).longValue(), result);
                        break;
                    }
                    case 5: {
                        Util.xor(((Number)this.value).floatValue(), ((Number)right.value).floatValue(), result);
                        break;
                    }
                    case 6: {
                        Util.xor(((Number)this.value).doubleValue(), ((Number)right.value).doubleValue(), result);
                        break;
                    }
                    default: {
                        return nullVariant;
                    }
                }
            } else {
                vars[this.vt].xor(this, right, result);
            }
        }
        return result;
    }

    public Variant xor(Variant right) throws SyntaxErrorException {
        return this.xor(right, this);
    }

    public Variant implicate(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (this.isNull() && !right.booleanValue()) {
            result.setObject(null, 0);
        } else {
            result.setBoolean(true);
        }
        return result;
    }

    public Variant implicate(Variant right) throws SyntaxErrorException {
        return this.implicate(right, this);
    }

    public Variant concat(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (this.vt < 512) {
            if (this.isNull()) {
                result.setVariant(right);
            } else if (this.vt == 8) {
                result.setInt(Util.booleanToInt((Boolean)this.value));
            } else if (right.vt == 8) {
                result.setInt(Util.booleanToInt((Boolean)this.value));
            } else if (this.vt == 12) {
                result.setVariant(this);
            } else if (right.vt == 12) {
                result.setVariant(right);
            } else if (this.vt == 16 || right.vt == 16) {
                result.setObject(null, 0);
            } else if (this.vt == 8192 && right.vt == 8192) {
                result.setObject(null, 8192);
            } else if (this.vt == 11) {
                if (right.vt == 11) {
                    result.setObject(((String)this.value).concat((String)right.value), 11);
                } else {
                    result.setObject(((String)this.value).concat(right.toString()), 11);
                }
            } else if (right.vt == 11) {
                result.setObject(this.toString().concat((String)right.value), 11);
            } else {
                result.setObject(this.toString().concat(right.toString()), 11);
            }
        }
        return result;
    }

    public Variant concat(Variant right) throws SyntaxErrorException {
        return this.concat(right, this);
    }

    private int compareTo(Variant right, boolean isIgnoreCase) throws SyntaxErrorException {
        if (right == this) {
            return 0;
        }
        if (right.vt == 15) {
            return this.compareTo((Variant)right.value, isIgnoreCase);
        }
        if (this.vt < 512) {
            if (this.vt < 7 && right.vt < 7) {
                double temp = this.doubleValue() - right.doubleValue();
                if (temp > 0.0) {
                    return 1;
                }
                if (temp < 0.0) {
                    return -1;
                }
                return 0;
            }
            Variant vleft = new Variant();
            Variant vright = new Variant();
            if (this.isNumeric(vleft) && right.isNumeric(vright)) {
                double temp = vleft.doubleValue() - vright.doubleValue();
                if (temp > 0.0) {
                    return 1;
                }
                if (temp < 0.0) {
                    return -1;
                }
                return 0;
            }
            switch (this.vt) {
                case 7: {
                    if (isIgnoreCase) {
                        if (right.vt == 7) {
                            char cleft = Character.toUpperCase(((Character)this.value).charValue());
                            char cright = Character.toUpperCase(((Character)right.value).charValue());
                            return new Character(cleft).compareTo(new Character(cright));
                        }
                        if (right.vt == 11 && right.toString().length() == 1) {
                            char cleft = Character.toUpperCase(((Character)this.value).charValue());
                            char cright = Character.toUpperCase(((String)right.value).charAt(0));
                            return new Character(cleft).compareTo(new Character(cright));
                        }
                        return ((Character)this.value).compareTo((Character)right.value);
                    }
                    if (right.vt == 7) {
                        return ((Character)this.value).compareTo((Character)right.value);
                    }
                    if (right.vt == 11 && right.toString().length() == 1) {
                        char cright = ((String)right.value).charAt(0);
                        return ((Character)this.value).compareTo(new Character(cright));
                    }
                    return ((Character)this.value).compareTo((Character)right.value);
                }
                case 8: {
                    boolean bleft = (Boolean)this.value;
                    boolean bright = right.booleanValue();
                    return Util.booleanToInt(bleft) - Util.booleanToInt(bright);
                }
                case 9: {
                    if (right.vt == 9) {
                        return ((BigInteger)this.value).compareTo((BigInteger)right.value);
                    }
                    return ((BigInteger)this.value).compareTo(right.toBigInteger());
                }
                case 10: {
                    if (right.vt == 10) {
                        return ((BigDecimal)this.value).compareTo((BigDecimal)right.value);
                    }
                    return ((BigDecimal)this.value).compareTo(right.toBigDecimal());
                }
                case 11: {
                    String strright = right.vt == 11 ? (String)right.value : right.toString();
                    if (isIgnoreCase) {
                        return ((String)this.value).compareToIgnoreCase(strright);
                    }
                    return ((String)this.value).compareTo(strright);
                }
                case 12: {
                    Date dt = right.vt == 12 ? (Date)right.value : right.toDate();
                    if (((Date)this.value).before(dt)) {
                        return -1;
                    }
                    if (((Date)this.value).after(dt)) {
                        return 1;
                    }
                    return 0;
                }
                case 13: {
                    Calendar cldr = right.vt == 13 ? (Calendar)right.value : right.toCalendar();
                    if (((Calendar)this.value).before(cldr)) {
                        return -1;
                    }
                    if (((Calendar)this.value).after(cldr)) {
                        return 1;
                    }
                    return 0;
                }
                case 14: {
                    ExprError.goError(64L, "VT_CURRENCY\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301\u6bd4\u8f83");
                }
                case 15: {
                    return ((Variant)this.value).compareTo(right, isIgnoreCase);
                }
                case 16: {
                    ExprError.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301\u6bd4\u8f83");
                    return 0;
                }
                case 17: {
                    ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u6bd4\u8f83");
                    return 0;
                }
                case 0: {
                    if (right.vt == 0) {
                        return 0;
                    }
                    return -1;
                }
            }
            ExprError.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u6bd4\u8f83");
            return 0;
        }
        if (this.vt == 16384 && right.vt == 16384) {
            return 0;
        }
        if (this.vt == 8192 && right.vt == 8192) {
            return 0;
        }
        ExprError.goError(64L, "\u8be5\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301\u6bd4\u8f83");
        return 0;
    }

    public int compareTo(Variant right) throws SyntaxErrorException {
        return this.compareTo(right, false);
    }

    public int compareTo(Object right) {
        int ret = 0;
        Variant vright = null;
        if (right == this) {
            return 0;
        }
        vright = !(right instanceof Variant) ? new Variant(right) : (Variant)right;
        try {
            ret = this.compareTo(vright, false);
        }
        catch (SyntaxErrorException e) {
            return Integer.MIN_VALUE;
        }
        return ret;
    }

    public int compareToIgnoreCase(Variant right) throws SyntaxErrorException {
        return this.compareTo(right, true);
    }

    private boolean equals(Variant right, boolean isIgnoreCase) throws SyntaxErrorException {
        if (right == this) {
            return true;
        }
        if (right.vt == 15) {
            return this.equals((Variant)right.value, isIgnoreCase);
        }
        if (this.vt < 512) {
            if (this.vt < 7) {
                return this.doubleValue() == right.doubleValue();
            }
            switch (this.vt) {
                case 7: {
                    if (isIgnoreCase) {
                        if (right.vt == 7) {
                            char cright;
                            char cleft = Character.toUpperCase(((Character)this.value).charValue());
                            return cleft == (cright = Character.toUpperCase(((Character)right.value).charValue()));
                        }
                        if (right.vt == 11 && right.toString().length() == 1) {
                            char cright;
                            char cleft = Character.toUpperCase(((Character)this.value).charValue());
                            return cleft == (cright = Character.toUpperCase(((String)right.value).charAt(0)));
                        }
                        return ((Character)this.value).equals(right.value);
                    }
                    if (right.vt == 7) {
                        char cright;
                        char cleft = ((Character)this.value).charValue();
                        return cleft == (cright = ((Character)right.value).charValue());
                    }
                    if (right.vt == 11 && right.toString().length() == 1) {
                        char cright;
                        char cleft = ((Character)this.value).charValue();
                        return cleft == (cright = ((String)right.value).charAt(0));
                    }
                    return ((Character)this.value).equals(right.value);
                }
                case 8: {
                    return ((Boolean)this.value).booleanValue() == right.booleanValue();
                }
                case 9: {
                    if (right.vt == 9) {
                        return ((BigInteger)this.value).equals(right.value);
                    }
                    return ((BigInteger)this.value).equals(right.toBigInteger());
                }
                case 10: {
                    if (right.vt == 10) {
                        return ((BigDecimal)this.value).equals(right.value);
                    }
                    return ((BigDecimal)this.value).equals(right.toBigDecimal());
                }
                case 11: {
                    String strright = right.vt == 11 ? (String)right.value : right.toString();
                    if (isIgnoreCase) {
                        return ((String)this.value).equalsIgnoreCase(strright);
                    }
                    return ((String)this.value).equals(strright);
                }
                case 12: {
                    return ((Date)this.value).equals(right.value);
                }
                case 13: {
                    return ((Calendar)this.value).equals(right.value);
                }
                case 14: {
                    return ((Currency)this.value).equals(right.value);
                }
                case 15: {
                    return ((Variant)this.value).equals(right);
                }
                case 16: {
                    return ((SyntaxErrorException)this.value).equals(right.value);
                }
                case 17: {
                    return this.value.equals(right.value);
                }
                case 0: {
                    return right.vt == 0;
                }
            }
            return false;
        }
        if (this.vt == 16384 && right.vt == 16384) {
            return true;
        }
        if (this.vt == 8192 && right.vt == 8192) {
            return true;
        }
        if (this.value == null) {
            return right.value == null;
        }
        return this.value.equals(right.value);
    }

    public boolean equals(Variant right) throws SyntaxErrorException {
        boolean ret = false;
        try {
            ret = this.equals(right, false);
        }
        catch (SyntaxErrorException e) {
            ret = false;
        }
        return ret;
    }

    public boolean equals(Object right) {
        boolean ret = true;
        Variant vright = null;
        if (right == this) {
            return true;
        }
        vright = !(right instanceof Variant) ? new Variant(right) : (Variant)right;
        try {
            ret = this.equals(vright);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public boolean equalsIgnoreCase(Variant right) throws SyntaxErrorException {
        return this.equals(right, true);
    }

    public boolean lessThan(Variant right) throws SyntaxErrorException {
        return this.compareTo(right) < 0;
    }

    public boolean greaterThan(Variant right) throws SyntaxErrorException {
        return this.compareTo(right) > 0;
    }

    public boolean notLessThan(Variant right) throws SyntaxErrorException {
        return !this.lessThan(right);
    }

    public boolean notGreaterThan(Variant right) throws SyntaxErrorException {
        return !this.greaterThan(right);
    }

    private int setTypeAdvanced(Object obj, Class type) {
        this.vt = 16384;
        if (type == null) {
            type = obj.getClass();
        }
        if (type.isArray()) {
            for (int i = 0; i < arrayType.length; ++i) {
                if (!arrayType[i].isInstance(obj)) continue;
                this.vt = vt4ArrayType[i];
                break;
            }
        } else {
            this.vt = obj instanceof Exception ? 16 : (obj instanceof Date ? 12 : (obj instanceof Calendar ? 13 : (obj instanceof BigInteger ? 9 : (obj instanceof BigDecimal ? 10 : (obj instanceof Variant ? 15 : 17)))));
        }
        return this.vt;
    }

    private int setType(Object obj) {
        this.vt = 16384;
        Class<?> type = obj.getClass();
        int i = 0;
        for (i = 0; i < dataType.length; ++i) {
            if (dataType[i] != type) continue;
            this.vt = vt4DataType[i];
            break;
        }
        if (this.vt == 16384) {
            for (i = 0; i < arrayType.length; ++i) {
                if (arrayType[i] != type) continue;
                this.vt = vt4ArrayType[i];
                break;
            }
        }
        if (this.vt == 16384) {
            this.setTypeAdvanced(obj, type);
        }
        return this.vt;
    }

    private boolean isErrorType(Variant left, Variant right, Variant result) {
        if (left.vt == 16) {
            result.setVariant(left);
            return true;
        }
        if (right.vt == 16) {
            result.setVariant(right);
            return true;
        }
        return false;
    }

    private boolean isErrorType(Variant left, Variant result) {
        if (left.vt == 16) {
            result.setVariant(left);
            return true;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

