/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.database;

import com.kingdee.bos.ctrl.etl.database.BaseDatabaseMeta;
import com.kingdee.bos.ctrl.etl.database.DatabaseInterface;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.value.Value;

public class MSSQLServerDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    public MSSQLServerDatabaseMeta(String name, String access, String host, String db, int port, String user, String pass) {
        super(name, access, host, db, port, user, pass);
    }

    public MSSQLServerDatabaseMeta() {
    }

    @Override
    public String getDatabaseTypeDesc() {
        return "MSSQL";
    }

    @Override
    public String getDatabaseTypeDescLong() {
        return "MS SQL Server";
    }

    @Override
    public int getDatabaseType() {
        return 2;
    }

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1};
    }

    @Override
    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 1433;
        }
        return -1;
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "com.microsoft.jdbc.sqlserver.SQLServerDriver";
    }

    @Override
    public String getURL() {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + this.getDatabaseName();
        }
        return "jdbc:microsoft:sqlserver://" + this.getHostname() + ":" + this.getDatabasePortNumber() + ";databaseName=" + this.getDatabaseName();
    }

    @Override
    public String getSchemaTableCombination(String schema_name, String table_part) {
        return table_part;
    }

    @Override
    public boolean supportsBitmapIndex() {
        return false;
    }

    @Override
    public boolean supportsSynonyms() {
        return false;
    }

    @Override
    public String getAddColumnStatement(String tablename, Value v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, Value v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ALTER COLUMN " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getDropColumnStatement(String tablename, Value v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP COLUMN " + v.getName() + Const.CR;
    }

    @Override
    public String getFieldDefinition(Value v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "DATETIME";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (use_autoinc) {
                        retval = retval + "BIGINT PRIMARY KEY IDENTITY(0,1)";
                        break;
                    }
                    retval = retval + "BIGINT PRIMARY KEY";
                    break;
                }
                if (precision == 0) {
                    if (length > 18) {
                        retval = retval + "DECIMAL(" + length + ",0)";
                        break;
                    }
                    if (length > 9) {
                        retval = retval + "BIGINT";
                        break;
                    }
                    retval = retval + "INT";
                    break;
                }
                if (precision > 0) {
                    if (length <= 0) break;
                    retval = retval + "DECIMAL(" + length + "," + precision + ")";
                    break;
                }
                retval = retval + "FLOAT(53)";
                break;
            }
            case 2: {
                if (length < 8000) {
                    if (length > 0) {
                        retval = retval + "VARCHAR(" + length + ")";
                        break;
                    }
                    retval = retval + "VARCHAR(100)";
                    break;
                }
                retval = retval + "TEXT";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    @Override
    public String getSQLListOfProcedures() {
        return "select o.name from sysobjects o, sysusers u where  xtype in ( 'FN', 'P' ) and o.uid = u.uid and upper(u.name) = '" + this.getUsername().toUpperCase() + "'";
    }
}

