/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.job.entry;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryCopy;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryInterface;
import com.kingdee.bos.ctrl.etl.job.entry.eval.JobEntryEval_Javascript;
import com.kingdee.bos.ctrl.etl.job.entry.job.JobEntryJob;
import com.kingdee.bos.ctrl.etl.job.entry.special.JobEntrySpecial;
import com.kingdee.bos.ctrl.etl.job.entry.sql.JobEntrySQL;
import com.kingdee.bos.ctrl.etl.job.entry.trans.JobEntryTrans;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class JobEntryBase
implements Cloneable {
    private String name;
    private String description;
    private boolean changed;
    private int type;
    private long id;
    private Connection ctxConnection = null;

    public JobEntryBase() {
        this.name = null;
        this.description = null;
    }

    public JobEntryBase(String name, String description) {
        this.setName(name);
        this.setDescription(description);
        this.setID(-1L);
    }

    public JobEntryBase(JobEntryBase jeb) {
        this.setName(jeb.getName());
        this.setDescription(jeb.getDescription());
        this.setType(jeb.getType());
        this.setID(jeb.getID());
    }

    public void clear() {
        this.name = null;
        this.description = null;
        this.changed = false;
    }

    public void setID(long id) {
        this.id = id;
    }

    public long getID() {
        return this.id;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return JobEntryInterface.type_desc[this.type];
    }

    public static final String getTypeDesc(int type) {
        return JobEntryInterface.type_desc[type];
    }

    public static final int getType(String desc) {
        int i;
        String[] d = JobEntryInterface.type_desc;
        for (i = 1; i < d.length; ++i) {
            if (!d[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        d = JobEntryInterface.type_desc_long;
        for (i = 1; i < d.length; ++i) {
            if (!d[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String Description) {
        this.description = Description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public boolean isStart() {
        return false;
    }

    public boolean isDummy() {
        return false;
    }

    public boolean isEvaluation() {
        return this.getType() == 9;
    }

    public boolean isJob() {
        return this.getType() == 2;
    }

    public boolean isMail() {
        return this.getType() == 4;
    }

    public boolean isShell() {
        return this.getType() == 4;
    }

    public boolean isSpecial() {
        return this.getType() == 10;
    }

    public boolean isTransformation() {
        return this.getType() == 1;
    }

    public boolean isFTP() {
        return this.getType() == 6;
    }

    public boolean isSFTP() {
        return this.getType() == 11;
    }

    public boolean isHTTP() {
        return this.getType() == 12;
    }

    public String getXML() {
        String retval = "";
        retval = retval + "      " + XMLHandler.addTagValue("name", this.getName());
        retval = retval + "      " + XMLHandler.addTagValue("description", this.getDescription());
        retval = retval + "      " + XMLHandler.addTagValue("type", this.getTypeDesc());
        return retval;
    }

    protected Connection getCtxConnection() {
        return this.ctxConnection;
    }

    public void loadXML(Node entrynode, List databases, Connection ctxConnection) throws ETLXMLException {
        try {
            this.ctxConnection = ctxConnection;
            this.setName(XMLHandler.getTagValue(entrynode, "name"));
            this.setDescription(XMLHandler.getTagValue(entrynode, "description"));
            String stype = XMLHandler.getTagValue(entrynode, "type");
            this.setType(JobEntryCopy.getType(stype));
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load base info for job entry", e);
        }
    }

    public void parseRepositoryObjects(Repository rep) throws ETLException {
    }

    public void saveRep(Repository rep, long id_job) throws ETLException {
        try {
            this.setID(rep.insertJobEntry(id_job, this.getName(), this.getDescription(), this.getTypeDesc()));
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to save job entry base information to the repository for id_job=" + id_job, dbe);
        }
    }

    public void loadRep(Repository rep, long id_jobentry, List databases) throws ETLException {
        try {
            Row r = rep.getJobEntry(id_jobentry);
            if (r != null) {
                this.setName(r.searchValue("NAME").getString());
                this.setDescription(r.searchValue("DESCRIPTION").getString());
                int id_jobentry_type = (int)r.searchValue("ID_JobEntryType").getInteger();
                Row jetrow = rep.getJobEntryType(id_jobentry_type);
                if (jetrow != null) {
                    this.type = JobEntryCopy.getType(jetrow.searchValue("CODE").getString());
                }
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to load base job entry information from the repository for id_jobentry=" + id_jobentry, dbe);
        }
    }

    public static final JobEntryInterface newJobEntryInterface(int type) throws ETLException {
        JobEntryBase jei = null;
        switch (type) {
            case 9: {
                jei = new JobEntryEval_Javascript();
                break;
            }
            case 2: {
                jei = new JobEntryJob();
                break;
            }
            case 10: {
                jei = new JobEntrySpecial();
                break;
            }
            case 5: {
                jei = new JobEntrySQL();
                break;
            }
            case 1: {
                jei = new JobEntryTrans();
                break;
            }
            default: {
                throw new ETLException("Unknown job entry type : " + type);
            }
        }
        return jei;
    }

    public static final JobEntryInterface newJobEntryInterface(int type, Repository rep, long id_jobentry, ArrayList databases) throws ETLException {
        JobEntryInterface jei = JobEntryBase.newJobEntryInterface(type);
        jei.loadRep(rep, id_jobentry, databases);
        return jei;
    }

    public Object clone() {
        JobEntryBase je;
        try {
            je = (JobEntryBase)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
        return je;
    }

    public String toString() {
        return this.name;
    }

    public boolean evaluates() {
        return false;
    }

    public boolean isUnconditional() {
        return true;
    }
}

