/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.job.entry.special;

import com.kingdee.bos.ctrl.etl.base.Result;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryBase;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryInterface;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.sql.Connection;
import java.util.List;
import org.w3c.dom.Node;

public class JobEntrySpecial
extends JobEntryBase
implements JobEntryInterface {
    private boolean start;
    private boolean dummy;

    public JobEntrySpecial() {
        this(null, false, false);
    }

    public JobEntrySpecial(String name, boolean start, boolean dummy) {
        super(name, "");
        this.start = start;
        this.dummy = dummy;
        this.setType(10);
    }

    public JobEntrySpecial(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + super.getXML();
        retval = retval + "      " + XMLHandler.addTagValue("start", this.start);
        retval = retval + "      " + XMLHandler.addTagValue("dummy", this.dummy);
        return retval;
    }

    @Override
    public void loadXML(Node entrynode, List databases, Connection ctxConnection) throws ETLXMLException {
        try {
            super.loadXML(entrynode, databases, ctxConnection);
            this.start = "Y".equalsIgnoreCase(XMLHandler.getTagValue(entrynode, "start"));
            this.dummy = "Y".equalsIgnoreCase(XMLHandler.getTagValue(entrynode, "dummy"));
        }
        catch (ETLException e) {
            throw new ETLXMLException("Unable to load special job entry from XML node", e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List databases) throws ETLException {
        try {
            super.loadRep(rep, id_jobentry, databases);
            this.start = rep.getJobEntryAttributeBoolean(id_jobentry, "start");
            this.dummy = rep.getJobEntryAttributeBoolean(id_jobentry, "dummy");
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to load job entry of type special from the repository for id_jobentry=" + id_jobentry, dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws ETLException {
        super.saveRep(rep, id_job);
        try {
            rep.saveJobEntryAttribute(id_job, this.getID(), "start", this.start);
            rep.saveJobEntryAttribute(id_job, this.getID(), "dummy", this.dummy);
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to save job entry of type special to the repository with id_job=" + id_job, dbe);
        }
    }

    @Override
    public boolean isStart() {
        return this.start;
    }

    @Override
    public boolean isDummy() {
        return this.dummy;
    }

    @Override
    public Result execute(Result prev_result, int nr, Repository rep, Job parentJob) {
        Result result = prev_result;
        if (this.isStart()) {
            result = new Result(nr);
            result.setResult(true);
        } else if (this.isDummy()) {
            result = new Result(nr);
            result.setResult(prev_result.getResult());
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return false;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }
}

