/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.logging;

import com.kingdee.bos.ctrl.etl.util.Const;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jFileAppender
implements Appender {
    private Layout layout;
    private Filter filter;
    private File file;
    private String name;
    private FileOutputStream fileOutputStream;

    public Log4jFileAppender(File file) throws IOException {
        this.file = file;
        this.fileOutputStream = new FileOutputStream(file);
    }

    public void addFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void clearFilters() {
        this.filter = null;
    }

    public void close() {
        try {
            this.fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void doAppend(LoggingEvent event) {
        String line = this.layout.format(event) + Const.CR;
        try {
            this.fileOutputStream.write(line.getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public boolean requiresLayout() {
        return true;
    }

    public File getFile() {
        return this.file;
    }

    public void setFilename(File file) {
        this.file = file;
    }

    public FileOutputStream getFileOutputStream() {
        return this.fileOutputStream;
    }

    public void setFileOutputStream(FileOutputStream fileOutputStream) {
        this.fileOutputStream = fileOutputStream;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

