/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.logging;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.IProgressMonitor;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.sql.Connection;
import java.util.Date;

public class LogTable {
    private LogWriter log = null;
    private Database db = null;
    private static LogTable instance = new LogTable();
    private static final String[] logTableNames = new String[]{"T_ETL_JobAudit", "T_ETL_JobErrorLog"};

    public static LogTable getInstance(LogWriter log, Connection con) {
        instance.setLogWriter(log);
        instance.setDatabase(con);
        return instance;
    }

    public void buildLogTable() throws ETLDatabaseException {
        this.db.connect();
        this.dropLogTable();
        this.createLogTable(null);
        this.db.disconnect();
    }

    public boolean dropLogTable() throws ETLDatabaseException {
        for (int i = 0; i < logTableNames.length; ++i) {
            try {
                this.db.execStatement("DROP TABLE " + logTableNames[i]);
                this.log.logDetailed(this.toString(), "dropped table " + logTableNames[i]);
                continue;
            }
            catch (ETLDatabaseException dbe) {
                this.log.logDetailed(this.toString(), "Unable to drop table: " + logTableNames[i]);
            }
        }
        this.log.logBasic(this.toString(), "Dropped all " + logTableNames.length + " repository tables.");
        return true;
    }

    public void createLogTable(IProgressMonitor monitor) throws ETLDatabaseException {
        int KEY = 9;
        this.log.logBasic(this.toString(), "Starting to create the log tables...");
        if (monitor != null) {
            monitor.beginTask("Creating the ETL logTable...", 31);
        }
        Row table = new Row();
        String tablename = "T_ETL_JobAudit";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_JobAudit", 5, KEY, 0));
        table.addValue(new Value("JobName", 2, 255, 0));
        table.addValue(new Value("ScheduleName", 2, 255, 0));
        table.addValue(new Value("IsSuccess", 4, 1, 0));
        table.addValue(new Value("StartTime", 3, 1, 0));
        table.addValue(new Value("EndTime", 3, 1, 0));
        String sql = this.db.getDDL(tablename, table, null, false, "ID_JobAudit", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.db.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_JobErrorLog";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_JobErrorLog", 5, KEY, 0));
        table.addValue(new Value("JobName", 2, 255, 0));
        table.addValue(new Value("ScheduleName", 2, 255, 0));
        table.addValue(new Value("Description", 2, 200000, 0));
        table.addValue(new Value("OccuredTime", 3, 1, 0));
        sql = this.db.getDDL(tablename, table, null, false, "ID_JobErrorLog", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.db.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        this.log.logBasic(this.toString(), "Created " + logTableNames.length + " log tables.");
    }

    public void insertJobLog(String logAuditTable, String logErrorTable, String jobName, Date startDate, Date endDate, Date logDate, boolean isSuccess, String log_string, String scheduleName) throws ETLDatabaseException {
        this.insertJobAudit(logAuditTable, jobName, startDate, endDate, isSuccess, scheduleName);
        if (!isSuccess) {
            this.insertJobErrorLog(logErrorTable, jobName, log_string, logDate, scheduleName);
        }
    }

    private LogTable() {
    }

    private void setLogWriter(LogWriter log) {
        this.log = log;
    }

    private void setDatabase(Connection con) {
        DatabaseMeta dbMeta = new DatabaseMeta(con);
        this.db = new Database(dbMeta);
    }

    private long insertJobAudit(String logAuditTable, String jobName, Date startDate, Date endDate, boolean isSuccess, String scheduleName) throws ETLDatabaseException {
        long id = this.getNextJobAuditID();
        String tablename = logAuditTable;
        Row table = new Row();
        table.addValue(new Value("ID_JobAudit", id));
        table.addValue(new Value("JobName", jobName));
        table.addValue(new Value("ScheduleName", scheduleName));
        table.addValue(new Value("IsSuccess", isSuccess));
        table.addValue(new Value("StartTime", startDate));
        table.addValue(new Value("EndTime", endDate));
        this.db.prepareInsert(table, tablename);
        this.db.setValuesInsert(table);
        this.db.insertRow();
        this.db.closeInsert();
        return id;
    }

    private long insertJobErrorLog(String logErrorTable, String jobName, String description, Date occuredTime, String scheduleName) throws ETLDatabaseException {
        long id = this.getNextJobErrorLogID();
        String tablename = logErrorTable;
        Row table = new Row();
        table.addValue(new Value("ID_JobErrorLog", id));
        table.addValue(new Value("JobName", jobName));
        table.addValue(new Value("ScheduleName", scheduleName));
        table.addValue(new Value("Description", description));
        table.addValue(new Value("OccuredTime", occuredTime));
        this.db.prepareInsert(table, tablename);
        this.db.setValuesInsert(table);
        this.db.insertRow();
        this.db.closeInsert();
        return id;
    }

    private long getNextJobAuditID() throws ETLDatabaseException {
        return this.db.getNextID("T_ETL_JobAudit", "ID_JobAudit");
    }

    private long getNextJobErrorLogID() throws ETLDatabaseException {
        return this.db.getNextID("T_ETL_JobErrorLog", "ID_JobErrorLog");
    }
}

