/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.server.config.rep;

import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.job.JobFactory;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.repository.RepositoryFactory;
import com.kingdee.bos.ctrl.etl.schedule.Schedule;
import com.kingdee.bos.ctrl.etl.schedule.ScheduleFactory;
import com.kingdee.bos.ctrl.etl.server.config.ServerConfigBase;
import com.kingdee.bos.ctrl.etl.server.config.ServerConfigInterface;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.sql.Connection;
import java.util.List;
import org.w3c.dom.Node;

public class ServerConfigRep
extends ServerConfigBase
implements ServerConfigInterface {
    private Repository rep = null;

    @Override
    public Repository getRepository() {
        return this.rep;
    }

    @Override
    public void loadXML(LogWriter log, Node entrynode, List databases, Connection ctxConnection) throws ETLXMLException {
        super.loadXML(entrynode, databases);
        try {
            String user = XMLHandler.getTagValue(entrynode, "user");
            if (user.equalsIgnoreCase("")) {
                // empty if block
            }
            String password = XMLHandler.getTagValue(entrynode, "password");
            String repname = XMLHandler.getTagValue(entrynode, "repname");
            String repdesc = XMLHandler.getTagValue(entrynode, "repdesc");
            String dbname = XMLHandler.getTagValue(entrynode, "repconnection");
            DatabaseMeta connection = Const.findDatabase(databases, dbname);
            this.rep = RepositoryFactory.getRepository(log, repname, repdesc, connection, user, password, ctxConnection);
            long[] id_jobs = this.rep.getAllJobIDs();
            for (int i = 0; i < id_jobs.length; ++i) {
                Job job = JobFactory.createJob(this.rep, id_jobs[i]);
                this.addJob(job);
            }
            long[] id_schedules = this.rep.getAllScheduleIDs();
            for (int j = 0; j < id_schedules.length; ++j) {
                long id_job = this.rep.getJobID(id_schedules[j]);
                Job job = this.findJob(id_job);
                Schedule schedule = ScheduleFactory.createSchedule2(this.rep, id_schedules[j], job);
                this.addSchedule(schedule);
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load evaluation job entry from XML node", e);
        }
    }
}

