/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.server.config.xml;

import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.job.JobFactory;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.schedule.Schedule;
import com.kingdee.bos.ctrl.etl.schedule.ScheduleFactory;
import com.kingdee.bos.ctrl.etl.server.config.ServerConfigBase;
import com.kingdee.bos.ctrl.etl.server.config.ServerConfigInterface;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.sql.Connection;
import java.util.List;
import org.w3c.dom.Node;

public class ServerConfigXml
extends ServerConfigBase
implements ServerConfigInterface {
    @Override
    public void loadXML(LogWriter log, Node confignode, List databases, Connection ctxConnection) throws ETLXMLException {
        super.loadXML(confignode, databases);
        Node jobsnode = XMLHandler.getSubNode(confignode, "jobs");
        int tr = XMLHandler.countNodes(jobsnode, "job");
        for (int i = 0; i < tr; ++i) {
            Node jobnode = XMLHandler.getSubNodeByNr(jobsnode, "job", i);
            String jobfilename = XMLHandler.getTagValue(jobnode, "jobfilename");
            Job job = JobFactory.createJob(jobfilename, ctxConnection);
            if (job == null) continue;
            this.addJob(job);
            Node scheduleNode = XMLHandler.getSubNode(jobnode, "schedule");
            Schedule schedule = ScheduleFactory.createSchedule(scheduleNode, ctxConnection, job);
            this.addSchedule(schedule);
        }
    }

    @Override
    public Repository getRepository() {
        return null;
    }
}

