/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.value.Value;

public class DatabaseImpact {
    public static final int TYPE_IMPACT_NONE = 0;
    public static final int TYPE_IMPACT_READ = 1;
    public static final int TYPE_IMPACT_WRITE = 2;
    public static final int TYPE_IMPACT_READ_WRITE = 3;
    public static final int TYPE_IMPACT_TRUNCATE = 3;
    public static final String[] type_desc = new String[]{"none", "Read", "Write", "Read/Write", "Truncate"};
    private String transname;
    private String stepname;
    private String dbname;
    private String table;
    private String field;
    private String valuename;
    private String valueorigin;
    private String sql;
    private String remark;
    private int type;

    public DatabaseImpact(int type, String transname, String stepname, String dbname, String table, String field, String valuename, String valueorigin, String sql, String remark) {
        this.type = type;
        this.transname = transname;
        this.stepname = stepname;
        this.dbname = dbname;
        this.table = table;
        this.field = field;
        this.valuename = valuename;
        this.valueorigin = valueorigin;
        this.sql = sql;
        this.remark = remark;
    }

    public String getTransformationName() {
        return this.transname;
    }

    public String getStepName() {
        return this.stepname;
    }

    public String getValueOrigin() {
        return this.valueorigin;
    }

    public String getDatabaseName() {
        return this.dbname;
    }

    public String getTable() {
        return this.table;
    }

    public String getField() {
        return this.field;
    }

    public String getValue() {
        return this.valuename;
    }

    public String getSQL() {
        return this.sql;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getTypeDesc() {
        return type_desc[this.type];
    }

    public static final int getTypeDesc(String typedesc) {
        for (int i = 1; i < type_desc.length; ++i) {
            if (!type_desc[i].equalsIgnoreCase(typedesc)) continue;
            return i;
        }
        return 0;
    }

    public int getType() {
        return this.type;
    }

    public Row getRow() {
        Row r = new Row();
        r.addValue(new Value("Type", this.getTypeDesc()));
        r.addValue(new Value("Transformation", this.getTransformationName()));
        r.addValue(new Value("Step", this.getStepName()));
        r.addValue(new Value("Database", this.getDatabaseName()));
        r.addValue(new Value("Table", this.getTable()));
        r.addValue(new Value("Field", this.getField()));
        r.addValue(new Value("Value", this.getValue()));
        r.addValue(new Value("Value Origin", this.getValueOrigin()));
        r.addValue(new Value("SQL", this.getSQL()));
        r.addValue(new Value("Remarks", this.getRemark()));
        return r;
    }
}

