/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.util.XMLInterface;
import java.util.List;
import org.w3c.dom.Node;

public class TransHopMeta
implements Cloneable,
XMLInterface,
Comparable {
    private StepMeta from_step;
    private StepMeta to_step;
    private boolean enabled;
    public boolean split = false;
    private boolean changed;
    private long id;

    public TransHopMeta(StepMeta from, StepMeta to, boolean en) {
        this.from_step = from;
        this.to_step = to;
        this.enabled = en;
    }

    public TransHopMeta(StepMeta from, StepMeta to) {
        this.from_step = from;
        this.to_step = to;
        this.enabled = true;
    }

    public TransHopMeta() {
        this(null, null, false);
    }

    public TransHopMeta(Node hopnode, List steps) throws ETLXMLException {
        try {
            this.from_step = this.searchStep(steps, XMLHandler.getTagValue(hopnode, "from"));
            this.to_step = this.searchStep(steps, XMLHandler.getTagValue(hopnode, "to"));
            String en = XMLHandler.getTagValue(hopnode, "enabled");
            this.enabled = en == null ? true : en.equalsIgnoreCase("Y");
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load hop info from XML node", e);
        }
    }

    public void setFromStep(StepMeta from) {
        this.from_step = from;
    }

    public void setToStep(StepMeta to) {
        this.to_step = to;
    }

    public StepMeta getFromStep() {
        return this.from_step;
    }

    public StepMeta getToStep() {
        return this.to_step;
    }

    private StepMeta searchStep(List steps, String name) {
        for (int i = 0; i < steps.size(); ++i) {
            StepMeta stepMeta = (StepMeta)steps.get(i);
            if (!stepMeta.getName().equalsIgnoreCase(name)) continue;
            return stepMeta;
        }
        return null;
    }

    public TransHopMeta(Repository rep, long id_trans_hop, List steps) throws ETLException {
        try {
            this.setID(id_trans_hop);
            Row r = rep.getTransHop(id_trans_hop);
            long id_step_from = r.searchValue("ID_StepFrom").getInteger();
            long id_step_to = r.searchValue("ID_StepTo").getInteger();
            this.enabled = r.searchValue("Enabled").getBoolean();
            this.from_step = Const.findStep(steps, id_step_from);
            this.to_step = Const.findStep(steps, id_step_to);
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to load Transformation hop info from the repository with id_trans_hop=" + id_trans_hop, dbe);
        }
    }

    public void saveRep(Repository rep, long id_transformation) throws ETLException {
        try {
            long id_step_from = this.from_step == null ? -1L : this.from_step.getID();
            long id_step_to = this.to_step == null ? -1L : this.to_step.getID();
            this.setID(rep.insertTransHop(id_transformation, id_step_from, id_step_to, this.enabled));
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to save transformation hop info to the database for id_transformation=" + id_transformation, dbe);
        }
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        TransHopMeta other = (TransHopMeta)obj;
        if (this.from_step == null || this.to_step == null) {
            return false;
        }
        return this.from_step.equals(other.getFromStep()) && this.to_step.equals(other.getToStep());
    }

    public int compareTo(Object obj) {
        return this.toString().compareTo(((TransHopMeta)obj).toString());
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setEnabled() {
        this.setEnabled(true);
    }

    public void setEnabled(boolean en) {
        this.enabled = en;
        this.setChanged();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void flip() {
        StepMeta dummy = this.from_step;
        this.from_step = this.to_step;
        this.to_step = dummy;
    }

    public String toString() {
        String str_fr = this.from_step == null ? "(empty)" : this.from_step.getName();
        String str_to = this.to_step == null ? "(empty)" : this.to_step.getName();
        return str_fr + " --> " + str_to + " (" + (this.enabled ? "enabled" : "disabled") + ")";
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "  <hop> ";
        retval = retval + XMLHandler.addTagValue("from", this.from_step.getName(), false);
        retval = retval + XMLHandler.addTagValue("to", this.to_step.getName(), false);
        retval = retval + XMLHandler.addTagValue("enabled", this.enabled, false);
        retval = retval + " </hop>";
        return retval;
    }
}

