/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.aggregaterows;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.aggregaterows.AggregateRows;
import com.kingdee.bos.ctrl.etl.transformation.step.aggregaterows.AggregateRowsData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class AggregateRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final int TYPE_AGGREGATE_NONE = 0;
    public static final int TYPE_AGGREGATE_SUM = 1;
    public static final int TYPE_AGGREGATE_AVERAGE = 2;
    public static final int TYPE_AGGREGATE_COUNT = 3;
    public static final int TYPE_AGGREGATE_MIN = 4;
    public static final int TYPE_AGGREGATE_MAX = 5;
    public static final int TYPE_AGGREGATE_FIRST = 6;
    public static final int TYPE_AGGREGATE_LAST = 7;
    public static final String[] aggregateTypeDesc = new String[]{"NONE(=first value)", "SUM", "AVERAGE", "COUNT", "MIN", "MAX", "FIRST", "LAST"};
    private String[] fieldName;
    private String[] fieldNewName;
    private int[] aggregateType;

    public int[] getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(int[] aggregateType) {
        this.aggregateType = aggregateType;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getFieldNewName() {
        return this.fieldNewName;
    }

    public void setFieldNewName(String[] fieldNewName) {
        this.fieldNewName = fieldNewName;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.fieldNewName = new String[nrfields];
        this.aggregateType = new int[nrfields];
    }

    public static final String getTypeDesc(int t) {
        if (t < 0 || t >= aggregateTypeDesc.length) {
            return null;
        }
        return aggregateTypeDesc[t];
    }

    public static final int getType(String at) {
        for (int i = 0; i < aggregateTypeDesc.length; ++i) {
            if (!aggregateTypeDesc[i].equalsIgnoreCase(at)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public Object clone() {
        AggregateRowsMeta retval = (AggregateRowsMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldNewName[i] = this.fieldNewName[i];
            retval.aggregateType[i] = this.aggregateType[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            int nrfields = XMLHandler.countNodes(fields, "field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.fieldName[i] = XMLHandler.getTagValue(fnode, "name");
                this.fieldNewName[i] = XMLHandler.getTagValue(fnode, "rename");
                String type = XMLHandler.getTagValue(fnode, "type");
                this.aggregateType[i] = AggregateRowsMeta.getType(type);
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML node (Aggr.Rows)", e);
        }
    }

    @Override
    public void setDefault() {
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "fieldname";
            this.fieldNewName[i] = "new name";
            this.aggregateType[i] = 1;
        }
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        Value v;
        int i;
        Row row = r == null ? new Row() : r;
        int[] fieldnrs = new int[this.fieldName.length];
        Value[] values = new Value[this.fieldName.length];
        for (i = 0; i < this.fieldName.length; ++i) {
            fieldnrs[i] = row.searchValueIndex(this.fieldName[i]);
            v = row.getValue(fieldnrs[i]);
            values[i] = new Value(v);
            switch (this.aggregateType[i]) {
                case 1: 
                case 2: 
                case 3: {
                    values[i].setType(1);
                    values[i].setLength(-1, -1);
                }
            }
        }
        row.clear();
        for (i = 0; i < this.fieldName.length; ++i) {
            v = values[i];
            v.setName(this.fieldNewName[i]);
            v.setOrigin(name);
            row.addValue(v);
        }
        return row;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "    <fields>" + Const.CR;
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval = retval + "      <field>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", this.fieldName[i]);
            retval = retval + "        " + XMLHandler.addTagValue("rename", this.fieldNewName[i]);
            retval = retval + "        " + XMLHandler.addTagValue("type", AggregateRowsMeta.getTypeDesc(this.aggregateType[i]));
            retval = retval + "        </field>" + Const.CR;
        }
        retval = retval + "      </fields>" + Const.CR;
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldNewName[i] = rep.getStepAttributeString(id_step, i, "field_rename");
                this.aggregateType[i] = AggregateRowsMeta.getType(rep.getStepAttributeString(id_step, i, "field_type"));
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_rename", this.fieldNewName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", AggregateRowsMeta.getTypeDesc(this.aggregateType[i]));
            }
        }
        catch (ETLException e) {
            throw new ETLException("Unable to save step info to the repository for id_step = " + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        String message = "";
        if (this.fieldName.length > 0) {
            int i;
            boolean error_found = false;
            message = "The following fields are not found in the input stream: " + Const.CR;
            for (i = 0; i < this.fieldName.length; ++i) {
                if (prev.searchValueIndex(this.fieldName[i]) >= 0) continue;
                message = message + "  " + this.fieldName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                cr = new CheckResult(4, message, stepinfo);
            } else {
                message = "All fields are present in the input rows.";
                cr = new CheckResult(1, message, stepinfo);
            }
            remarks.add(cr);
            message = "The following fields from the input stream are ignored and dropped: " + Const.CR;
            error_found = false;
            for (i = 0; i < prev.size(); ++i) {
                Value v = prev.getValue(i);
                boolean value_found = false;
                for (int j = 0; j < this.fieldName.length && !value_found; ++j) {
                    if (!v.getName().equalsIgnoreCase(this.fieldName[j])) continue;
                    value_found = true;
                }
                if (value_found) continue;
                message = message + "  " + v.getName() + " (" + v.toStringMeta() + ")" + Const.CR;
                error_found = true;
            }
            if (error_found) {
                cr = new CheckResult(2, message, stepinfo);
            } else {
                message = "All fields from the input rows are used.";
                cr = new CheckResult(1, message, stepinfo);
            }
            remarks.add(cr);
        } else {
            message = "Nothing specified to aggregate: result is going to be empty";
            cr = new CheckResult(3, message, stepinfo);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepinfo);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new AggregateRows(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new AggregateRowsData();
    }
}

