/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.groupby;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.groupby.GroupBy;
import com.kingdee.bos.ctrl.etl.transformation.step.groupby.GroupByData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class GroupByMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final int TYPE_GROUP_NONE = 0;
    public static final int TYPE_GROUP_SUM = 1;
    public static final int TYPE_GROUP_AVERAGE = 2;
    public static final int TYPE_GROUP_MIN = 3;
    public static final int TYPE_GROUP_MAX = 4;
    public static final int TYPE_GROUP_COUNT_ALL = 5;
    public static final int TYPE_GROUP_CONCAT_COMMA = 6;
    public static final String[] type_group_desc = new String[]{"-", "SUM", "AVERAGE", "MIN", "MAX", "COUNT_ALL", "CONCAT_COMMA"};
    public static final String[] typeGroupLongDesc = new String[]{"-", "Sum", "Average", "Minimum", "Maximum", "Number of Values", "Concatinate strings separated by ,"};
    private boolean passAllRows;
    private String directory;
    private String prefix;
    private boolean aggregateIgnored;
    private String aggregateIgnoredField;
    private String[] groupField;
    private String[] aggregateField;
    private String[] subjectField;
    private int[] aggregateType;

    public String[] getAggregateField() {
        return this.aggregateField;
    }

    public void setAggregateField(String[] aggregateField) {
        this.aggregateField = aggregateField;
    }

    public boolean isAggregateIgnored() {
        return this.aggregateIgnored;
    }

    public void setAggregateIgnored(boolean aggregateIgnored) {
        this.aggregateIgnored = aggregateIgnored;
    }

    public String getAggregateIgnoredField() {
        return this.aggregateIgnoredField;
    }

    public void setAggregateIgnoredField(String aggregateIgnoredField) {
        this.aggregateIgnoredField = aggregateIgnoredField;
    }

    public int[] getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(int[] aggregateType) {
        this.aggregateType = aggregateType;
    }

    public String[] getGroupField() {
        return this.groupField;
    }

    public void setGroupField(String[] groupField) {
        this.groupField = groupField;
    }

    public boolean passAllRows() {
        return this.passAllRows;
    }

    public void setPassAllRows(boolean passAllRows) {
        this.passAllRows = passAllRows;
    }

    public String[] getSubjectField() {
        return this.subjectField;
    }

    public void setSubjectField(String[] subjectField) {
        this.subjectField = subjectField;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    public void allocate(int sizegroup, int nrfields) {
        this.groupField = new String[sizegroup];
        this.aggregateField = new String[nrfields];
        this.subjectField = new String[nrfields];
        this.aggregateType = new int[nrfields];
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            Node fnode;
            int i;
            this.passAllRows = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "all_rows"));
            this.aggregateIgnored = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "ignore_aggregate"));
            this.aggregateIgnoredField = XMLHandler.getTagValue(stepnode, "field_ignore");
            this.directory = XMLHandler.getTagValue(stepnode, "directory");
            this.prefix = XMLHandler.getTagValue(stepnode, "prefix");
            Node groupn = XMLHandler.getSubNode(stepnode, "group");
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            int sizegroup = XMLHandler.countNodes(groupn, "field");
            int nrfields = XMLHandler.countNodes(fields, "field");
            this.allocate(sizegroup, nrfields);
            for (i = 0; i < sizegroup; ++i) {
                fnode = XMLHandler.getSubNodeByNr(groupn, "field", i);
                this.groupField[i] = XMLHandler.getTagValue(fnode, "name");
            }
            for (i = 0; i < nrfields; ++i) {
                fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.aggregateField[i] = XMLHandler.getTagValue(fnode, "aggregate");
                this.subjectField[i] = XMLHandler.getTagValue(fnode, "subject");
                this.aggregateType[i] = GroupByMeta.getType(XMLHandler.getTagValue(fnode, "type"));
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    public static final int getType(String desc) {
        int i;
        for (i = 0; i < type_group_desc.length; ++i) {
            if (!type_group_desc[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        for (i = 0; i < typeGroupLongDesc.length; ++i) {
            if (!typeGroupLongDesc[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTypeDesc(int i) {
        if (i < 0 || i >= type_group_desc.length) {
            return null;
        }
        return type_group_desc[i];
    }

    public static final String getTypeDescLong(int i) {
        if (i < 0 || i >= typeGroupLongDesc.length) {
            return null;
        }
        return typeGroupLongDesc[i];
    }

    @Override
    public void setDefault() {
        this.directory = "%%java.io.tmpdir%%";
        this.prefix = "grp";
        this.passAllRows = false;
        this.aggregateIgnored = false;
        this.aggregateIgnoredField = null;
        int sizegroup = 0;
        int nrfields = 0;
        this.allocate(sizegroup, nrfields);
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        int i;
        Row row = new Row(r);
        if (!this.passAllRows) {
            for (i = r.size() - 1; i >= 0; --i) {
                String fieldName = row.getValue(i).getName();
                boolean found = false;
                for (int j = 0; j < this.groupField.length && !found; ++j) {
                    if (!fieldName.equalsIgnoreCase(this.groupField[j])) continue;
                    found = true;
                }
                if (found) continue;
                r.removeValue(i);
            }
        }
        for (i = 0; i < this.subjectField.length; ++i) {
            Value subj = row.searchValue(this.subjectField[i]);
            if (subj == null) continue;
            String value_name = this.aggregateField[i];
            int value_type = 0;
            int length = -1;
            int precision = -1;
            switch (this.aggregateType[i]) {
                case 1: 
                case 2: 
                case 5: {
                    value_type = 1;
                    break;
                }
                case 3: 
                case 4: {
                    value_type = subj.getType();
                    break;
                }
                case 6: {
                    value_type = 2;
                    break;
                }
            }
            if (this.aggregateType[i] != 5) {
                length = subj.getLength();
                precision = subj.getPrecision();
            }
            if (value_type == 0) continue;
            Value v = new Value(value_name, value_type);
            v.setOrigin(name);
            v.setLength(length, precision);
            r.addValue(v);
        }
        return row;
    }

    @Override
    public String getXML() {
        int i;
        String retval = "";
        retval = retval + "      " + XMLHandler.addTagValue("all_rows", this.passAllRows);
        retval = retval + "      " + XMLHandler.addTagValue("ignore_aggregate", this.aggregateIgnored);
        retval = retval + "      " + XMLHandler.addTagValue("field_ignore", this.aggregateIgnoredField);
        retval = retval + "      " + XMLHandler.addTagValue("directory", this.directory);
        retval = retval + "      " + XMLHandler.addTagValue("prefix", this.prefix);
        retval = retval + "      <group>" + Const.CR;
        for (i = 0; i < this.groupField.length; ++i) {
            retval = retval + "        <field>" + Const.CR;
            retval = retval + "          " + XMLHandler.addTagValue("name", this.groupField[i]);
            retval = retval + "          </field>" + Const.CR;
        }
        retval = retval + "        </group>" + Const.CR;
        retval = retval + "      <fields>" + Const.CR;
        for (i = 0; i < this.subjectField.length; ++i) {
            retval = retval + "        <field>" + Const.CR;
            retval = retval + "          " + XMLHandler.addTagValue("aggregate", this.aggregateField[i]);
            retval = retval + "          " + XMLHandler.addTagValue("subject", this.subjectField[i]);
            retval = retval + "          " + XMLHandler.addTagValue("type", GroupByMeta.getTypeDesc(this.aggregateType[i]));
            retval = retval + "          </field>" + Const.CR;
        }
        retval = retval + "        </fields>" + Const.CR;
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            int i;
            this.passAllRows = rep.getStepAttributeBoolean(id_step, "all_rows");
            this.aggregateIgnored = rep.getStepAttributeBoolean(id_step, "ignore_aggregate");
            this.aggregateIgnoredField = rep.getStepAttributeString(id_step, "field_ignore");
            this.directory = rep.getStepAttributeString(id_step, "directory");
            this.prefix = rep.getStepAttributeString(id_step, "prefix");
            int groupsize = rep.countNrStepAttributes(id_step, "group_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "aggregate_name");
            this.allocate(groupsize, nrvalues);
            for (i = 0; i < groupsize; ++i) {
                this.groupField[i] = rep.getStepAttributeString(id_step, i, "group_name");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.aggregateField[i] = rep.getStepAttributeString(id_step, i, "aggregate_name");
                this.subjectField[i] = rep.getStepAttributeString(id_step, i, "aggregate_subject");
                this.aggregateType[i] = GroupByMeta.getType(rep.getStepAttributeString(id_step, i, "aggregate_type"));
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "all_rows", this.passAllRows);
            rep.saveStepAttribute(id_transformation, id_step, "ignore_aggregate", this.aggregateIgnored);
            rep.saveStepAttribute(id_transformation, id_step, "field_ignore", this.aggregateIgnoredField);
            rep.saveStepAttribute(id_transformation, id_step, "directory", this.directory);
            rep.saveStepAttribute(id_transformation, id_step, "prefix", this.prefix);
            for (i = 0; i < this.groupField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "group_name", this.groupField[i]);
            }
            for (i = 0; i < this.subjectField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "aggregate_name", this.aggregateField[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "aggregate_subject", this.subjectField[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "aggregate_type", GroupByMeta.getTypeDesc(this.aggregateType[i]));
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, "Step is receiving info from other steps.", stepMeta);
            remarks.add(cr);
        } else {
            CheckResult cr = new CheckResult(4, "No input received from other steps!", stepMeta);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new GroupBy(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GroupByData();
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

