/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.rowgenerator;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.rowgenerator.RowGenerator;
import com.kingdee.bos.ctrl.etl.transformation.step.rowgenerator.RowGeneratorData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class RowGeneratorMeta
extends BaseStepMeta
implements StepMetaInterface {
    private long rowLimit;
    private String[] currency;
    private String[] decimal;
    private String[] group;
    private String[] value;
    private String[] fieldName;
    private String[] fieldType;
    private String[] fieldFormat;
    private int[] fieldLength;
    private int[] fieldPrecision;

    public String[] getCurrency() {
        return this.currency;
    }

    public void setCurrency(String[] currency) {
        this.currency = currency;
    }

    public String[] getDecimal() {
        return this.decimal;
    }

    public void setDecimal(String[] decimal) {
        this.decimal = decimal;
    }

    public String[] getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(String[] fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public String[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String[] fieldType) {
        this.fieldType = fieldType;
    }

    public String[] getGroup() {
        return this.group;
    }

    public void setGroup(String[] group) {
        this.group = group;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String[] getValue() {
        return this.value;
    }

    public void setValue(String[] value) {
        this.value = value;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.fieldType = new String[nrfields];
        this.fieldFormat = new String[nrfields];
        this.fieldLength = new int[nrfields];
        this.fieldPrecision = new int[nrfields];
        this.currency = new String[nrfields];
        this.decimal = new String[nrfields];
        this.group = new String[nrfields];
        this.value = new String[nrfields];
    }

    @Override
    public Object clone() {
        RowGeneratorMeta retval = (RowGeneratorMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldType[i] = this.fieldType[i];
            retval.fieldFormat[i] = this.fieldFormat[i];
            retval.currency[i] = this.currency[i];
            retval.decimal[i] = this.decimal[i];
            retval.group[i] = this.group[i];
            retval.value[i] = this.value[i];
            this.fieldLength[i] = this.fieldLength[i];
            this.fieldPrecision[i] = this.fieldPrecision[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            int nrfields = XMLHandler.countNodes(fields, "field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.fieldName[i] = XMLHandler.getTagValue(fnode, "name");
                this.fieldType[i] = XMLHandler.getTagValue(fnode, "type");
                this.fieldFormat[i] = XMLHandler.getTagValue(fnode, "format");
                this.currency[i] = XMLHandler.getTagValue(fnode, "currency");
                this.decimal[i] = XMLHandler.getTagValue(fnode, "decimal");
                this.group[i] = XMLHandler.getTagValue(fnode, "group");
                this.value[i] = XMLHandler.getTagValue(fnode, "nullif");
                String slength = XMLHandler.getTagValue(fnode, "length");
                String sprecision = XMLHandler.getTagValue(fnode, "precision");
                this.fieldLength[i] = Const.toInt(slength, -1);
                this.fieldPrecision[i] = Const.toInt(sprecision, -1);
            }
            String lim = XMLHandler.getTagValue(stepnode, "limit");
            this.rowLimit = Const.toLong(lim, 0L);
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldType[i] = "Number";
            this.fieldFormat[i] = "?0,000,000.00;?-0,000,000.00";
            this.fieldLength[i] = 9;
            this.fieldPrecision[i] = 2;
            this.currency[i] = "?";
            this.decimal[i] = ",";
            this.group[i] = ".";
            this.value[i] = "-";
        }
        this.rowLimit = 10L;
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        Row row = r == null ? new Row() : r;
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
            int type = Value.getType(this.fieldType[i]);
            if (type == 0) {
                type = 2;
            }
            Value v = new Value(this.fieldName[i], type);
            v.setLength(this.fieldLength[i], this.fieldPrecision[i]);
            v.setOrigin(name);
            row.addValue(v);
        }
        return row;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "    <fields>" + Const.CR;
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
            retval = retval + "      <field>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", this.fieldName[i]);
            retval = retval + "        " + XMLHandler.addTagValue("type", this.fieldType[i]);
            retval = retval + "        " + XMLHandler.addTagValue("format", this.fieldFormat[i]);
            retval = retval + "        " + XMLHandler.addTagValue("currency", this.currency[i]);
            retval = retval + "        " + XMLHandler.addTagValue("decimal", this.decimal[i]);
            retval = retval + "        " + XMLHandler.addTagValue("group", this.group[i]);
            retval = retval + "        " + XMLHandler.addTagValue("nullif", this.value[i]);
            retval = retval + "        " + XMLHandler.addTagValue("length", this.fieldLength[i]);
            retval = retval + "        " + XMLHandler.addTagValue("precision", this.fieldPrecision[i]);
            retval = retval + "        </field>" + Const.CR;
        }
        retval = retval + "      </fields>" + Const.CR;
        retval = retval + "    " + XMLHandler.addTagValue("limit", this.rowLimit);
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldType[i] = rep.getStepAttributeString(id_step, i, "field_type");
                this.fieldFormat[i] = rep.getStepAttributeString(id_step, i, "field_format");
                this.currency[i] = rep.getStepAttributeString(id_step, i, "field_currency");
                this.decimal[i] = rep.getStepAttributeString(id_step, i, "field_decimal");
                this.group[i] = rep.getStepAttributeString(id_step, i, "field_group");
                this.value[i] = rep.getStepAttributeString(id_step, i, "field_nullif");
                this.fieldLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.fieldPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
            }
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "limit");
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            for (int i = 0; i < this.fieldName.length; ++i) {
                if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", this.fieldType[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_format", this.fieldFormat[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_currency", this.currency[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_decimal", this.decimal[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_group", this.group[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_nullif", this.value[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", this.fieldLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", this.fieldPrecision[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(4, "This step type can't read from the input stream(s).", stepMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, "Step doesn't read from the input stream(s).", stepMeta);
            remarks.add(cr);
            if ((double)this.rowLimit == 0.0) {
                cr = new CheckResult(3, "Step will not return any rows.", stepMeta);
                remarks.add(cr);
            } else {
                cr = new CheckResult(1, "Step will return " + this.rowLimit + " rows", stepMeta);
                remarks.add(cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(4, "This is not expecting nor reading data from input steps", stepMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, "No input received from other steps.", stepMeta);
            remarks.add(cr);
        }
        RowGeneratorData data = new RowGeneratorData();
        RowGeneratorMeta meta = (RowGeneratorMeta)stepMeta.getStepMetaInterface();
        RowGenerator.buildRow(meta, data, remarks);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new RowGenerator(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new RowGeneratorData();
    }
}

