/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.streamlookup;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.streamlookup.StreamLookupData;
import com.kingdee.bos.ctrl.etl.transformation.step.streamlookup.StreamLookupMeta;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;

public class StreamLookup
extends BaseStep
implements StepInterface {
    private StreamLookupMeta meta;
    private StreamLookupData data;

    public StreamLookup(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private void handleNullIf() {
        this.data.nullIf = new Value[this.meta.getValue().length];
        block13: for (int i = 0; i < this.meta.getValue().length; ++i) {
            if (this.meta.getValueDefaultType()[i] < 0) {
                this.meta.getValueDefaultType()[i] = 2;
            }
            this.data.nullIf[i] = new Value(this.meta.getValueName()[i], this.meta.getValueDefaultType()[i]);
            switch (this.meta.getValueDefaultType()[i]) {
                case 2: {
                    this.data.nullIf[i].setValue(this.meta.getValueDefault()[i]);
                    continue block13;
                }
                case 3: {
                    try {
                        this.data.nullIf[i].setValue(DateFormat.getInstance().parse(this.meta.getValueDefault()[i]));
                    }
                    catch (Exception e) {
                        this.data.nullIf[i].setValue(new Date());
                        this.data.nullIf[i].setNull();
                    }
                    continue block13;
                }
                case 1: {
                    try {
                        this.data.nullIf[i].setValue(Double.parseDouble(this.meta.getValueDefault()[i]));
                    }
                    catch (Exception e) {
                        this.data.nullIf[i].setValue(0.0);
                        this.data.nullIf[i].setNull();
                    }
                    continue block13;
                }
                case 5: {
                    try {
                        this.data.nullIf[i].setValue(Long.parseLong(this.meta.getValueDefault()[i]));
                    }
                    catch (Exception e) {
                        this.data.nullIf[i].setValue(0L);
                        this.data.nullIf[i].setNull();
                    }
                    continue block13;
                }
                case 4: {
                    if ("TRUE".equalsIgnoreCase(this.meta.getValueDefault()[i]) || "Y".equalsIgnoreCase(this.meta.getValueDefault()[i])) {
                        this.data.nullIf[i].setValue(true);
                        continue block13;
                    }
                    this.data.nullIf[i].setValue(false);
                    continue block13;
                }
                default: {
                    this.data.nullIf[i].setNull();
                }
            }
        }
    }

    private boolean readLookupValues() throws ETLStepException {
        this.data.look = new Hashtable();
        this.data.firstrow = null;
        if (this.meta.getLookupFromStep() == null) {
            this.logError("No lookup step specified.");
            return false;
        }
        this.logDetailed("Reading from stream [" + this.meta.getLookupFromStep().getName() + "]");
        Row r = this.getRowFrom(this.meta.getLookupFromStep().getName());
        while (r != null) {
            this.logRowlevel("Read lookup row: " + r.toString());
            Row key_part = new Row();
            Row value_part = new Row();
            for (int i = 0; i < this.meta.getKeylookup().length; ++i) {
                Value keyValue = r.searchValue(this.meta.getKeylookup()[i]);
                if (keyValue == null) {
                    throw new ETLStepException("Unable to find field [" + this.meta.getKeylookup()[i] + "] in the source rows");
                }
                key_part.addValue(keyValue);
            }
            if (this.data.keyTypes == null) {
                this.data.keyTypes = new Row(key_part);
            }
            for (int v = 0; v < this.meta.getValue().length; ++v) {
                Value returnValue = r.searchValue(this.meta.getValue()[v]);
                if (returnValue == null) {
                    throw new ETLStepException("Unable to find field [" + this.meta.getValue()[v] + "] in the source rows");
                }
                value_part.addValue(returnValue);
            }
            this.data.look.put(key_part, value_part);
            if (this.data.firstrow == null) {
                this.data.firstrow = new Row(value_part);
            }
            r = this.getRowFrom(this.meta.getLookupFromStep().getName());
        }
        return true;
    }

    private boolean lookupValues(Row row) {
        int i;
        Row lu = new Row();
        Row add = null;
        this.debug = "start lookupValues";
        if (this.first) {
            this.debug = "First part";
            this.first = false;
            this.data.keynrs = new int[this.meta.getKeystream().length];
            for (int i2 = 0; i2 < this.meta.getKeystream().length; ++i2) {
                this.data.keynrs[i2] = row.searchValueIndex(this.meta.getKeystream()[i2]);
                if (this.data.keynrs[i2] < 0) {
                    this.logError("Field [" + this.meta.getKeystream()[i2] + "] not found in row [" + row + "]");
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                this.logDetailed("Field [" + this.meta.getKeystream()[i2] + "] has nr [" + this.data.keynrs[i2] + "]");
            }
            this.handleNullIf();
            this.debug = "first: do lookup";
            try {
                if (this.meta.getKeystream().length > 0) {
                    add = (Row)this.data.look.get(lu);
                } else {
                    add = this.data.firstrow;
                    this.logRowlevel("Got row without keys: " + add);
                }
            }
            catch (Exception e) {
                add = null;
            }
        }
        if (this.stopped) {
            return false;
        }
        this.debug = "Copy value references to lookup table";
        for (i = 0; i < this.meta.getKeystream().length; ++i) {
            int valueNr = this.data.keynrs[i];
            Value value = row.getValue(valueNr);
            lu.addValue(value);
        }
        this.debug = "Handle conflicting types";
        this.debug = "lookup size=" + lu.size();
        if (this.data.keyTypes != null) {
            for (i = 0; i < lu.size(); ++i) {
                Value inputValue = lu.getValue(i);
                Value lookupValue = this.data.keyTypes.getValue(i);
                if (inputValue.getType() == lookupValue.getType()) continue;
                Value newValue = new Value(inputValue);
                newValue.setType(lookupValue.getType());
                lu.setValue(i, newValue);
            }
        }
        try {
            this.debug = "do lookup";
            if (this.meta.getKeystream().length > 0) {
                add = (Row)this.data.look.get(lu);
            } else {
                add = this.data.firstrow;
                this.logRowlevel("Got row without keys: " + add);
            }
        }
        catch (Exception e) {
            add = null;
        }
        if (add == null) {
            this.debug = "add null values";
            add = new Row();
            for (int i3 = 0; i3 < this.meta.getValue().length; ++i3) {
                add.addValue(new Value(this.data.nullIf[i3]));
            }
        }
        this.debug = "add returned values";
        try {
            for (int i4 = 0; i4 < add.size(); ++i4) {
                Value v = add.getValue(i4);
                this.debug = "add returned value #" + i4 + " : " + v.toString() + " (" + v.toStringMeta() + ")";
                if (v.getType() != this.meta.getValueDefaultType()[i4]) {
                    v.setType(this.meta.getValueDefaultType()[i4]);
                }
                if (this.meta.getValueName()[i4] != null && this.meta.getValueName()[i4].length() > 0) {
                    v.setName(this.meta.getValueName()[i4]);
                }
                row.addValue(v);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.debug = "Finished lookupValues";
        return true;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        Row r;
        this.meta = (StreamLookupMeta)smi;
        this.data = (StreamLookupData)sdi;
        if (this.data.readLookupValues) {
            this.data.readLookupValues = false;
            this.logBasic("Reading lookup values from step [" + this.meta.getLookupFromStep() + "]");
            if (this.readLookupValues()) {
                this.logBasic("Read " + this.data.look.size() + " values in memory for lookup!");
            } else {
                this.logError("Unable to read data from lookup-stream.");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
        }
        if ((r = this.getRow()) == null) {
            this.logDetailed("Stopped processing with empty row after " + this.linesRead + " rows.");
            this.setOutputDone();
            return false;
        }
        boolean err = this.lookupValues(r);
        if (!err) {
            this.setOutputDone();
            return false;
        }
        this.putRow(r);
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("linenr " + this.linesRead);
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (StreamLookupMeta)smi;
        this.data = (StreamLookupData)sdi;
        if (super.init(smi, sdi)) {
            this.data.readLookupValues = true;
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        super.dispose(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

