/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.streamlookup;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.streamlookup.StreamLookup;
import com.kingdee.bos.ctrl.etl.transformation.step.streamlookup.StreamLookupData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class StreamLookupMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String[] keystream;
    private String[] keylookup;
    private String[] value;
    private String[] valueName;
    private String[] valueDefault;
    private int[] valueDefaultType;
    private boolean inputSorted;
    private StepMeta lookupFromStep;
    private String lookupFromStepname;

    public StepMeta getLookupFromStep() {
        return this.lookupFromStep;
    }

    public void setLookupFromStep(StepMeta lookupFromStep) {
        this.lookupFromStep = lookupFromStep;
    }

    public boolean isInputSorted() {
        return this.inputSorted;
    }

    public void setInputSorted(boolean inputSorted) {
        this.inputSorted = inputSorted;
    }

    public String[] getKeylookup() {
        return this.keylookup;
    }

    public void setKeylookup(String[] keylookup) {
        this.keylookup = keylookup;
    }

    public String[] getKeystream() {
        return this.keystream;
    }

    public void setKeystream(String[] keystream) {
        this.keystream = keystream;
    }

    public String[] getValue() {
        return this.value;
    }

    public void setValue(String[] value) {
        this.value = value;
    }

    public String[] getValueDefault() {
        return this.valueDefault;
    }

    public void setValueDefault(String[] valueDefault) {
        this.valueDefault = valueDefault;
    }

    public int[] getValueDefaultType() {
        return this.valueDefaultType;
    }

    public void setValueDefaultType(int[] valueDefaultType) {
        this.valueDefaultType = valueDefaultType;
    }

    public String[] getValueName() {
        return this.valueName;
    }

    public void setValueName(String[] valueName) {
        this.valueName = valueName;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrkeys, int nrvalues) {
        this.keystream = new String[nrkeys];
        this.keylookup = new String[nrkeys];
        this.value = new String[nrvalues];
        this.valueName = new String[nrvalues];
        this.valueDefault = new String[nrvalues];
        this.valueDefaultType = new int[nrvalues];
    }

    @Override
    public Object clone() {
        int i;
        StreamLookupMeta retval = (StreamLookupMeta)super.clone();
        int nrkeys = this.keystream.length;
        int nrvalues = this.value.length;
        retval.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            retval.keystream[i] = this.keystream[i];
            retval.keylookup[i] = this.keylookup[i];
        }
        for (i = 0; i < nrvalues; ++i) {
            retval.value[i] = this.value[i];
            retval.valueName[i] = this.valueName[i];
            retval.valueDefault[i] = this.valueDefault[i];
            retval.valueDefaultType[i] = this.valueDefaultType[i];
        }
        return retval;
    }

    @Override
    public String[] getInfoSteps() {
        if (this.getLookupStepname() != null) {
            return new String[]{this.getLookupStepname()};
        }
        return null;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            int i;
            this.lookupFromStepname = XMLHandler.getTagValue(stepnode, "from");
            this.lookupFromStep = null;
            this.inputSorted = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "input_sorted"));
            Node lookup = XMLHandler.getSubNode(stepnode, "lookup");
            int nrkeys = XMLHandler.countNodes(lookup, "key");
            int nrvalues = XMLHandler.countNodes(lookup, "value");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr(lookup, "key", i);
                this.keystream[i] = XMLHandler.getTagValue(knode, "name");
                this.keylookup[i] = XMLHandler.getTagValue(knode, "field");
            }
            for (i = 0; i < nrvalues; ++i) {
                Node vnode = XMLHandler.getSubNodeByNr(lookup, "value", i);
                this.value[i] = XMLHandler.getTagValue(vnode, "name");
                this.valueName[i] = XMLHandler.getTagValue(vnode, "rename");
                if (this.valueName[i] == null) {
                    this.valueName[i] = this.value[i];
                }
                this.valueDefault[i] = XMLHandler.getTagValue(vnode, "default");
                String dtype = XMLHandler.getTagValue(vnode, "type");
                this.valueDefaultType[i] = Value.getType(dtype);
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        int i;
        this.keystream = null;
        this.value = null;
        this.valueDefault = null;
        this.lookupFromStepname = null;
        this.lookupFromStep = null;
        int nrkeys = 0;
        int nrvalues = 0;
        this.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            this.keystream[i] = "key" + i;
            this.keylookup[i] = "keyfield" + i;
        }
        for (i = 0; i < nrvalues; ++i) {
            this.value[i] = "value" + i;
            this.valueName[i] = "valuename" + i;
            this.valueDefault[i] = "default" + i;
            this.valueDefaultType[i] = 1;
        }
    }

    @Override
    public Row getFields(Row r, String name, Row info) throws ETLStepException {
        Row row = r == null ? new Row() : r;
        if (info != null && info.size() != 0) {
            for (int i = 0; i < this.valueName.length; ++i) {
                Value v = info.searchValue(this.value[i]);
                if (v == null) {
                    throw new ETLStepException("Return value " + this.value[i] + " can't be found in the input row.");
                }
                v.setName(this.valueName[i]);
                v.setOrigin(name);
                row.addValue(v);
            }
        } else {
            for (int i = 0; i < this.valueName.length; ++i) {
                Value v = new Value(this.valueName[i], this.valueDefaultType[i]);
                v.setOrigin(name);
                row.addValue(v);
            }
        }
        return row;
    }

    @Override
    public String getXML() {
        int i;
        String retval = "";
        retval = retval + "    " + XMLHandler.addTagValue("from", this.lookupFromStep != null ? this.lookupFromStep.getName() : "");
        retval = retval + "    " + XMLHandler.addTagValue("input_sorted", this.inputSorted);
        retval = retval + "    <lookup>" + Const.CR;
        for (i = 0; i < this.keystream.length; ++i) {
            retval = retval + "      <key>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", this.keystream[i]);
            retval = retval + "        " + XMLHandler.addTagValue("field", this.keylookup[i]);
            retval = retval + "      </key>" + Const.CR;
        }
        for (i = 0; i < this.value.length; ++i) {
            retval = retval + "      <value>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", this.value[i]);
            retval = retval + "        " + XMLHandler.addTagValue("rename", this.valueName[i]);
            retval = retval + "        " + XMLHandler.addTagValue("default", this.valueDefault[i]);
            retval = retval + "        " + XMLHandler.addTagValue("type", Value.getTypeDesc(this.valueDefaultType[i]));
            retval = retval + "      </value>" + Const.CR;
        }
        retval = retval + "    </lookup>" + Const.CR;
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            int i;
            this.lookupFromStepname = rep.getStepAttributeString(id_step, "lookup_from_step");
            this.lookupFromStep = null;
            this.inputSorted = rep.getStepAttributeBoolean(id_step, "input_sorted");
            int nrkeys = rep.countNrStepAttributes(id_step, "lookup_key_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "return_value_name");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                this.keystream[i] = rep.getStepAttributeString(id_step, i, "lookup_key_name");
                this.keylookup[i] = rep.getStepAttributeString(id_step, i, "lookup_key_field");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.value[i] = rep.getStepAttributeString(id_step, i, "return_value_name");
                this.valueName[i] = rep.getStepAttributeString(id_step, i, "return_value_rename");
                this.valueDefault[i] = rep.getStepAttributeString(id_step, i, "return_value_default");
                this.valueDefaultType[i] = Value.getType(rep.getStepAttributeString(id_step, i, "return_value_type"));
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "lookup_from_step", this.lookupFromStep != null ? this.lookupFromStep.getName() : "");
            rep.saveStepAttribute(id_transformation, id_step, "input_sorted", this.inputSorted);
            for (i = 0; i < this.keystream.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "lookup_key_name", this.keystream[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "lookup_key_field", this.keylookup[i]);
            }
            for (i = 0; i < this.value.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "return_value_name", this.value[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "return_value_rename", this.valueName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "return_value_default", this.valueDefault[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "return_value_type", Value.getTypeDesc(this.valueDefaultType[i]));
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        int idx;
        int i;
        boolean error_found;
        String error_message;
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", stepMeta);
            remarks.add(cr);
            error_message = "";
            error_found = false;
            for (i = 0; i < this.keystream.length; ++i) {
                idx = prev.searchValueIndex(this.keystream[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.keystream[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = "Fields that were not found in input stream:" + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, stepMeta);
                remarks.add(cr);
            } else {
                cr = new CheckResult(1, "All fields are found in the input stream.", stepMeta);
                remarks.add(cr);
            }
        } else {
            cr = new CheckResult(4, "Couldn't find fields from previous steps, check the hops...!", stepMeta);
            remarks.add(cr);
        }
        if (info != null && info.size() > 0) {
            cr = new CheckResult(1, "Step is receiving lookup data to other step, receiving " + info.size() + " fields", stepMeta);
            remarks.add(cr);
            error_message = "";
            error_found = false;
            for (i = 0; i < this.keylookup.length; ++i) {
                idx = info.searchValueIndex(this.keylookup[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.keylookup[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = "Fields that were not found in lookup stream:" + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, stepMeta);
                remarks.add(cr);
            } else {
                cr = new CheckResult(1, "All fields are found in the lookup stream.", stepMeta);
                remarks.add(cr);
            }
            for (i = 0; i < this.value.length; ++i) {
                idx = info.searchValueIndex(this.value[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.value[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = "Fields to retrieve that were not found in lookup stream:" + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, stepMeta);
                remarks.add(cr);
            } else {
                cr = new CheckResult(1, "All fields to retrieve are found in the input lookup stream.", stepMeta);
                remarks.add(cr);
            }
        } else {
            cr = new CheckResult(4, "Couldn't find fields from lookup steps, check the hops...!", stepMeta);
            remarks.add(cr);
        }
        if (this.lookupFromStep == null) {
            cr = new CheckResult(4, "Source step is not selected!", stepMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, "Source step is selected.", stepMeta);
            remarks.add(cr);
            if (info != null) {
                cr = new CheckResult(1, "Source step [" + this.lookupFromStep + "] exist!", stepMeta);
                remarks.add(cr);
            } else {
                cr = new CheckResult(4, "Source step [" + this.lookupFromStep + "] doesn't exist!", stepMeta);
                remarks.add(cr);
            }
        }
        if (input.length >= 2) {
            cr = new CheckResult(1, "Step is receiving info from " + input.length + " input steps.", stepMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "We need at least 2 input streams:" + Const.CR + "  1 (or more) input stream for the data" + Const.CR + " 1 input stream for the lookup data", stepMeta);
            remarks.add(cr);
        }
    }

    public StepMeta getLookupStep() {
        return this.lookupFromStep;
    }

    public String getLookupStepname() {
        if (this.lookupFromStep != null && this.lookupFromStep.getName() != null && this.lookupFromStep.getName().length() > 0) {
            return this.lookupFromStep.getName();
        }
        return null;
    }

    @Override
    public void searchInfoAndTargetSteps(List steps) {
        this.lookupFromStep = TransMeta.findStep(steps, this.lookupFromStepname);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new StreamLookup(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new StreamLookupData();
    }
}

