/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.textfileinput;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLValueException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileinput.TextFileFilter;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileinput.TextFileInputData;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileinput.TextFileInputField;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileinput.TextFileInputMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;

public class TextFileInput
extends BaseStep
implements StepInterface {
    private TextFileInputMeta meta;
    private TextFileInputData data;

    public TextFileInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public static final String getLine(LogWriter log, InputStreamReader reader, String format) {
        StringBuffer line = new StringBuffer();
        int c = 0;
        try {
            while (c >= 0) {
                c = reader.read();
                if (c == 10 || c == 13) {
                    if (format.equalsIgnoreCase("DOS")) {
                        c = reader.read();
                    }
                    return line.toString();
                }
                if (c < 0) continue;
                line.append((char)c);
            }
        }
        catch (Exception e) {
            if (line.length() == 0) {
                log.logError("get line", "Exception reading line: " + e.toString());
                return null;
            }
            return line.toString();
        }
        if (line.length() > 0) {
            return line.toString();
        }
        return null;
    }

    public static final ArrayList convertLineToStrings(LogWriter log, String line, TextFileInputMeta inf) throws ETLException {
        ArrayList<String> strings = new ArrayList<String>();
        String debug = "convertLineToStrings start";
        try {
            if (line == null) {
                return null;
            }
            if (inf.getFileType().equalsIgnoreCase("CSV")) {
                int fieldnr = 0;
                int pos = 0;
                int length = line.length();
                boolean dencl = false;
                while (pos < length) {
                    String pol;
                    int next;
                    boolean encl_found;
                    debug = "convertLineToStrings while start";
                    int from = pos;
                    int len_encl = inf.getEnclosure() == null ? 0 : inf.getEnclosure().length();
                    int len_esc = inf.getEscapeCharacter() == null ? 0 : inf.getEscapeCharacter().length();
                    boolean contains_escaped_enclosures = false;
                    boolean contains_escaped_separators = false;
                    if (len_encl > 0 && line.substring(from, from + len_encl).equalsIgnoreCase(inf.getEnclosure())) {
                        String strnext;
                        debug = "convertLineToStrings if start";
                        log.logRowlevel("convert line to row", "encl substring=[" + line.substring(from, from + len_encl) + "]");
                        encl_found = true;
                        int p = from + len_encl;
                        boolean is_enclosure = p + len_encl < length && line.substring(p, p + len_encl).equalsIgnoreCase(inf.getEnclosure());
                        boolean is_escape = p + len_esc < length && line.substring(p, p + len_esc).equalsIgnoreCase(inf.getEscapeCharacter());
                        boolean enclosure_after = false;
                        if ((is_enclosure || is_escape) && p < length - 1 && (strnext = line.substring(p + len_encl, p + 2 * len_encl)).equalsIgnoreCase(inf.getEnclosure())) {
                            ++p;
                            enclosure_after = true;
                            dencl = true;
                            if (is_escape) {
                                contains_escaped_enclosures = true;
                            }
                        }
                        while ((!is_enclosure || enclosure_after) && p < line.length()) {
                            debug = "convertLineToStrings start while enclosure (p=" + p + ")";
                            enclosure_after = false;
                            is_enclosure = len_encl > 0 && ++p + len_encl < length && line.substring(p, p + len_encl).equals(inf.getEnclosure());
                            boolean bl = is_escape = len_esc > 0 && p + len_esc < length && line.substring(p, p + len_esc).equals(inf.getEscapeCharacter());
                            if (!is_enclosure && !is_escape || p >= length - 1 || !(strnext = line.substring(p + len_encl, p + 2 * len_encl)).equals(inf.getEnclosure())) continue;
                            ++p;
                            enclosure_after = true;
                            dencl = true;
                            if (!is_escape) continue;
                            contains_escaped_enclosures = true;
                        }
                        next = p >= length ? p : p + len_encl;
                        log.logRowlevel("convert line to row", "End of enclosure @ position " + p);
                        debug = "convertLineToStrings end of enclosure";
                    } else {
                        encl_found = false;
                        boolean found = false;
                        int startpoint = from;
                        int tries = 1;
                        do {
                            next = line.indexOf(inf.getSeparator(), startpoint);
                            if (len_esc > 0 && next - len_esc > 0) {
                                String before = line.substring(next - len_esc, next);
                                if (inf.getEscapeCharacter().equals(before)) {
                                    startpoint = next + 1;
                                    ++tries;
                                    contains_escaped_separators = true;
                                    continue;
                                }
                                found = true;
                                continue;
                            }
                            found = true;
                        } while (!found && next >= 0);
                    }
                    if (next == -1) {
                        next = length;
                    }
                    if (encl_found) {
                        pol = line.substring(from + len_encl, next - len_encl);
                        log.logRowlevel("convert line to row", "Enclosed field found: [" + pol + "]");
                    } else {
                        debug = "convertLineToStrings get substring";
                        pol = line.substring(from, next);
                        log.logRowlevel("convert line to row", "Normal field found: [" + pol + "]");
                    }
                    if (dencl) {
                        debug = "convertLineToStrings dencl";
                        StringBuffer sbpol = new StringBuffer(pol);
                        int idx = sbpol.indexOf(inf.getEnclosure() + inf.getEnclosure());
                        while (idx >= 0) {
                            sbpol.delete(idx, idx + inf.getEnclosure().length());
                            idx = sbpol.indexOf(inf.getEnclosure() + inf.getEnclosure());
                        }
                        pol = sbpol.toString();
                    }
                    if (contains_escaped_enclosures) {
                        String replace = inf.getEscapeCharacter() + inf.getEnclosure();
                        String replaceWith = inf.getEnclosure();
                        pol = Const.replace(pol, replace, replaceWith);
                    }
                    if (contains_escaped_separators) {
                        String replace = inf.getEscapeCharacter() + inf.getSeparator();
                        String replaceWith = inf.getSeparator();
                        pol = Const.replace(pol, replace, replaceWith);
                    }
                    debug = "convertLineToStrings add pol";
                    strings.add(pol);
                    pos = next + 1;
                    ++fieldnr;
                }
            } else {
                debug = "convertLineToStrings : Fixed";
                for (int i = 0; i < inf.getInputFields().length; ++i) {
                    TextFileInputField field = inf.getInputFields()[i];
                    debug = "convertLineToStrings : Fixed, field [" + field.getName() + "]";
                    int length = line.length();
                    if (field.getPosition() + field.getLength() <= length) {
                        strings.add(line.substring(field.getPosition(), field.getPosition() + field.getLength()));
                        continue;
                    }
                    if (field.getPosition() < length) {
                        strings.add(line.substring(field.getPosition()));
                        continue;
                    }
                    strings.add("");
                }
            }
        }
        catch (Exception e) {
            throw new ETLException("Error converting line : " + e.toString() + " in part: " + debug, e);
        }
        debug = "end of convertLineToStrings";
        return strings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Row convertLineToRow(LogWriter log, String line, TextFileInputMeta info, DecimalFormat ldf, DecimalFormatSymbols ldfs, SimpleDateFormat ldaf, DateFormatSymbols ldafs, String fname, long linenr) throws ETLException {
        Value inc;
        if (line == null || line.length() == 0) {
            return null;
        }
        Row r = new Row();
        Value errorCount = null;
        if (info.isErrorIgnored() && info.getErrorCountField() != null && info.getErrorCountField().length() > 0) {
            errorCount = new Value(info.getErrorCountField(), 0L);
        }
        Value errorFields = null;
        if (info.isErrorIgnored() && info.getErrorFieldsField() != null && info.getErrorFieldsField().length() > 0) {
            errorFields = new Value(info.getErrorFieldsField(), "");
        }
        Value errorText = null;
        if (info.isErrorIgnored() && info.getErrorTextField() != null && info.getErrorTextField().length() > 0) {
            errorText = new Value(info.getErrorTextField(), "");
        }
        int nrfields = info.getInputFields().length;
        try {
            Value value;
            int fieldnr;
            ArrayList strings = TextFileInput.convertLineToStrings(log, line, info);
            for (fieldnr = 0; fieldnr < nrfields; ++fieldnr) {
                block23: {
                    int trim_type;
                    TextFileInputField f = info.getInputFields()[fieldnr];
                    String field = fieldnr < nrfields ? f.getName() : "empty" + fieldnr;
                    int type = fieldnr < nrfields ? f.getType() : 2;
                    String format = fieldnr < nrfields ? f.getFormat() : "";
                    int length = fieldnr < nrfields ? f.getLength() : -1;
                    int precision = fieldnr < nrfields ? f.getPrecision() : -1;
                    String group = fieldnr < nrfields ? f.getGroupSymbol() : "";
                    String decimal = fieldnr < nrfields ? f.getDecimalSymbol() : "";
                    String currency = fieldnr < nrfields ? f.getCurrencySymbol() : "";
                    String nullif = fieldnr < nrfields ? f.getNullString() : "";
                    int n = trim_type = fieldnr < nrfields ? f.getTrimType() : 0;
                    if (fieldnr < strings.size()) {
                        String pol = (String)strings.get(fieldnr);
                        try {
                            value = TextFileInput.convertValue(pol, field, type, format, length, precision, group, decimal, currency, nullif, trim_type, ldf, ldfs, ldaf, ldafs);
                        }
                        catch (Exception e) {
                            StringBuffer sb;
                            if (!info.isErrorIgnored()) {
                                throw new ETLException("Couldn't parse field [" + f.getName() + "] with value [" + pol + "]", e);
                            }
                            String message = "Couldn't parse field [" + field + "] with value [" + pol + "] : " + e.getMessage();
                            log.logBasic(fname, "WARNING: " + message);
                            value = new Value(field, type);
                            value.setNull();
                            if (errorCount != null) {
                                errorCount.plus(1L);
                            }
                            if (errorFields != null) {
                                sb = new StringBuffer(errorFields.getString());
                                if (sb.length() > 0) {
                                    sb.append(", ");
                                }
                                sb.append(field);
                                errorFields.setValue(sb);
                            }
                            if (errorText != null) {
                                sb = new StringBuffer(errorText.getString());
                                if (sb.length() > 0) {
                                    sb.append(Const.CR);
                                }
                                sb.append(message);
                                errorText.setValue(sb);
                            }
                            break block23;
                        }
                    }
                    value = new Value(field, type);
                    value.setNull();
                }
                r.addValue(value);
            }
            if (errorCount != null) {
                r.addValue(errorCount);
            }
            if (errorFields != null) {
                r.addValue(errorFields);
            }
            if (errorText != null) {
                r.addValue(errorText);
            }
            if (fieldnr < info.getInputFields().length) {
                for (int i = fieldnr; i < info.getInputFields().length; ++i) {
                    TextFileInputField f = info.getInputFields()[i];
                    value = new Value(f.getName(), f.getType());
                    value.setLength(f.getLength(), f.getPrecision());
                    value.setNull();
                    r.addValue(value);
                }
            }
        }
        catch (Exception e) {
            throw new ETLException("Error converting line", e);
        }
        if (info.includeFilename() && r != null) {
            inc = new Value(info.getFilenameField(), fname);
            inc.setLength(100);
            r.addValue(inc);
        }
        if (info.includeRowNumber() && r != null) {
            inc = new Value(info.getRowNumberField(), 5);
            inc.setValue(linenr);
            inc.setLength(9);
            r.addValue(inc);
        }
        return r;
    }

    public static final Value convertValue(String pol, String field_name, int field_type, String field_format, int field_length, int field_precision, String num_group, String num_decimal, String num_currency, String nullif, int trim_type, DecimalFormat ldf, DecimalFormatSymbols ldfs, SimpleDateFormat ldaf, DateFormatSymbols ldafs) throws Exception {
        Value value = new Value(field_name, field_type);
        String null_value = nullif;
        if (null_value == null) {
            switch (field_type) {
                case 4: {
                    null_value = "";
                    break;
                }
                case 2: {
                    null_value = "";
                    break;
                }
                case 6: {
                    null_value = "";
                    break;
                }
                case 1: {
                    null_value = "";
                    break;
                }
                case 5: {
                    null_value = "";
                    break;
                }
                case 3: {
                    null_value = "";
                    break;
                }
                default: {
                    null_value = "";
                }
            }
        }
        String null_cmp = Const.rightPad(new StringBuffer(null_value), pol.length());
        if (pol == null || pol.length() == 0 || pol.equalsIgnoreCase(null_cmp)) {
            value.setNull();
        } else if (value.isNumeric()) {
            StringBuffer strpol = new StringBuffer(pol);
            switch (trim_type) {
                case 1: {
                    while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                        strpol.deleteCharAt(0);
                    }
                    break;
                }
                case 2: {
                    while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                        strpol.deleteCharAt(strpol.length() - 1);
                    }
                    break;
                }
                case 3: {
                    while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                        strpol.deleteCharAt(0);
                    }
                    while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                        strpol.deleteCharAt(strpol.length() - 1);
                    }
                    break;
                }
            }
            pol = strpol.toString();
            if (value.isNumber()) {
                if (field_format != null) {
                    ldf.applyPattern(field_format);
                    if (num_decimal != null && num_decimal.length() >= 1) {
                        ldfs.setDecimalSeparator(num_decimal.charAt(0));
                    }
                    if (num_group != null && num_group.length() >= 1) {
                        ldfs.setGroupingSeparator(num_group.charAt(0));
                    }
                    if (num_currency != null && num_currency.length() >= 1) {
                        ldfs.setCurrencySymbol(num_currency);
                    }
                    ldf.setDecimalFormatSymbols(ldfs);
                }
                value.setValue(ldf.parse(pol).doubleValue());
            }
            if (value.isInteger()) {
                value.setValue(Long.parseLong(pol));
            }
            if (value.isBigNumber()) {
                value.setValue(new BigDecimal(pol));
            }
            throw new ETLValueException("Unknown numeric type: contact vendor!");
        } else if (value.isString()) {
            value.setValue(pol);
            switch (trim_type) {
                case 1: {
                    value.ltrim();
                    break;
                }
                case 2: {
                    value.rtrim();
                    break;
                }
                case 3: {
                    value.trim();
                    break;
                }
            }
            if (pol.length() == 0) {
                value.setNull();
            }
        } else if (value.isDate()) {
            if (field_format != null) {
                ldaf.applyPattern(field_format);
                ldaf.setDateFormatSymbols(ldafs);
            }
            value.setValue(ldaf.parse(pol));
        }
        value.setLength(field_length, field_precision);
        return value;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        String extra;
        int i;
        Row r = null;
        boolean retval = true;
        boolean putrow = false;
        this.debug = "start of readRowOfData";
        if (this.first) {
            this.debug = "first";
            this.first = false;
            if (!this.openNextFile()) {
                this.closeLastFile();
                this.setOutputDone();
                return false;
            }
            this.debug = "first repeat fields";
            for (int i2 = 0; i2 < this.meta.getInputFields().length; ++i2) {
                if (!this.meta.getInputFields()[i2].isRepeated()) continue;
                ++this.data.nr_repeats;
            }
        } else if (!this.data.doneReading) {
            int repeats = 1;
            if (this.meta.isLineWrapped()) {
                repeats = this.meta.getNrWraps() > 0 ? this.meta.getNrWraps() : repeats;
            }
            for (i = 0; i < repeats && !this.data.doneReading; ++i) {
                this.debug = "get a new line of data";
                String line = TextFileInput.getLine(this.log, this.data.isr, this.meta.getFileFormat());
                if (line != null) {
                    ++this.linesInput;
                    boolean filterOK = true;
                    for (int f = 0; f < this.meta.getFilter().length && filterOK; ++f) {
                        TextFileFilter filter = this.meta.getFilter()[f];
                        if (filter.getFilterString() == null || filter.getFilterString().length() <= 0) continue;
                        int from = filter.getFilterPosition();
                        if (from >= 0) {
                            String sub;
                            int to = from + filter.getFilterString().length();
                            this.debug = "verify filter : get substring(" + from + ", " + to + ") line length=" + line.length();
                            if (line.length() >= from && line.length() >= to && (sub = line.substring(filter.getFilterPosition(), to)).equalsIgnoreCase(filter.getFilterString())) {
                                filterOK = false;
                            }
                        } else {
                            int idx = line.indexOf(filter.getFilterString());
                            if (idx >= 0) {
                                filterOK = false;
                            }
                        }
                        if (filterOK) continue;
                        if (filter.isFilterLastLine()) {
                            this.data.doneReading = true;
                        }
                        ++repeats;
                    }
                    if (!filterOK) continue;
                    this.data.lineBuffer.add(line);
                    continue;
                }
                this.data.doneReading = true;
            }
        }
        while (this.data.lineBuffer.size() == 0) {
            this.debug = "empty buffer: open next file";
            if (this.openNextFile()) continue;
            this.debug = "empty buffer: close last file";
            this.closeLastFile();
            this.setOutputDone();
            return false;
        }
        this.debug = "take first line of buffer";
        String line = (String)this.data.lineBuffer.get(0);
        this.debug = "remove first line of buffer";
        this.data.lineBuffer.remove(0);
        if (this.meta.isLayoutPaged()) {
            this.debug = "paged layout";
            if (!this.data.doneWithHeader && this.data.pageLinesRead == 0) {
                this.debug = "paged layout : header line " + this.data.headerLinesRead;
                this.logRowlevel("P-HEADER (" + this.data.headerLinesRead + ") : " + line);
                ++this.data.headerLinesRead;
                if (this.data.headerLinesRead >= this.meta.getNrHeaderLines()) {
                    this.data.doneWithHeader = true;
                }
            } else {
                this.debug = "paged layout : data or footer";
                if (this.data.pageLinesRead < this.meta.getNrLinesPerPage()) {
                    if (this.meta.isLineWrapped()) {
                        for (i = 0; i < this.meta.getNrWraps(); ++i) {
                            extra = "";
                            if (this.data.lineBuffer.size() > 0) {
                                extra = (String)this.data.lineBuffer.get(0);
                                this.data.lineBuffer.remove(0);
                            }
                            line = line + extra;
                        }
                    }
                    this.debug = "paged layout : data line";
                    this.logRowlevel("P-DATA: " + line);
                    ++this.data.pageLinesRead;
                    r = TextFileInput.convertLineToRow(this.log, line, this.meta, this.data.df, this.data.dfs, this.data.daf, this.data.dafs, this.data.filename, this.linesWritten + 1L);
                    if (r != null) {
                        putrow = true;
                    }
                } else {
                    this.debug = "paged layout : footer line";
                    if (this.meta.hasFooter() && this.data.footerLinesRead < this.meta.getNrFooterLines()) {
                        this.logRowlevel("P-FOOTER: " + line);
                        ++this.data.footerLinesRead;
                    }
                    if (!this.meta.hasFooter() || this.data.footerLinesRead >= this.meta.getNrFooterLines()) {
                        this.debug = "paged layout : end of page: restart";
                        this.data.doneWithHeader = false;
                        this.data.headerLinesRead = 0;
                        this.data.pageLinesRead = 0;
                        this.data.footerLinesRead = 0;
                        this.logRowlevel("RESTART PAGE");
                    }
                }
            }
        } else {
            this.debug = "normal";
            if (!this.data.doneWithHeader) {
                this.debug = "normal : header line";
                ++this.data.headerLinesRead;
                if (this.data.headerLinesRead >= this.meta.getNrHeaderLines()) {
                    this.data.doneWithHeader = true;
                }
            } else {
                this.debug = "normal : data and footer";
                if (this.data.doneReading && this.meta.hasFooter() && this.data.lineBuffer.size() <= this.meta.getNrFooterLines()) {
                    this.debug = "normal : footer";
                    this.data.lineBuffer.clear();
                } else {
                    if (this.meta.isLineWrapped()) {
                        for (i = 0; i < this.meta.getNrWraps(); ++i) {
                            extra = "";
                            if (this.data.lineBuffer.size() > 0) {
                                extra = (String)this.data.lineBuffer.get(0);
                                this.data.lineBuffer.remove(0);
                            }
                            line = line + extra;
                        }
                    }
                    this.debug = "normal : data";
                    r = TextFileInput.convertLineToRow(this.log, line, this.meta, this.data.df, this.data.dfs, this.data.daf, this.data.dafs, this.data.filename, this.linesWritten + 1L);
                    if (r != null) {
                        putrow = true;
                    }
                }
            }
        }
        if (putrow && r != null && !r.isIgnored()) {
            if (this.data.nr_repeats > 0) {
                this.debug = "repeats";
                if (this.data.previous_row == null) {
                    this.debug = "init repeats";
                    this.data.previous_row = new Row();
                    for (i = 0; i < this.meta.getInputFields().length; ++i) {
                        if (!this.meta.getInputFields()[i].isRepeated()) continue;
                        Value value = r.getValue(i);
                        this.data.previous_row.addValue(new Value(value));
                    }
                } else {
                    this.debug = "check repeats";
                    int repnr = 0;
                    for (int i3 = 0; i3 < this.meta.getInputFields().length; ++i3) {
                        if (!this.meta.getInputFields()[i3].isRepeated()) continue;
                        Value value = r.getValue(i3);
                        if (value.isNull()) {
                            Value prev = this.data.previous_row.getValue(repnr);
                            r.removeValue(i3);
                            r.addValue(i3, prev);
                        } else {
                            this.data.previous_row.removeValue(repnr);
                            this.data.previous_row.addValue(repnr, new Value(value));
                        }
                        ++repnr;
                    }
                }
            }
            this.logRowlevel("Putting row: " + r.toString());
            this.putRow(r);
        }
        if (this.linesInput > 0L && this.linesInput % 5000L == 0L) {
            this.logBasic("linenr " + this.linesInput);
        }
        this.debug = "end of readRowOfData";
        return retval;
    }

    private boolean closeLastFile() {
        try {
            this.debug = "closeLastFile: close";
            if (this.data.filename != null) {
                if (this.meta.isZipped()) {
                    this.data.zi.closeEntry();
                    this.data.zi.close();
                }
                this.data.fr.close();
                this.data.isr.close();
                this.data.filename = null;
            }
        }
        catch (Exception e) {
            this.logError("Couldn't close file : " + this.data.filename + " --> " + e.toString());
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        this.debug = "closeLastFile: end.";
        return !this.data.isLastFile;
    }

    private boolean openNextFile() {
        try {
            this.debug = "openNextFile : close last file";
            if (!this.closeLastFile()) {
                return false;
            }
            this.data.isLastFile = this.data.filenr == this.data.files.length - 1;
            this.data.filename = this.data.files[this.data.filenr];
            this.debug = "openNextFile : open file";
            this.logBasic("Opening file: " + this.data.filename);
            this.data.fr = new FileInputStream(new File(FilenameUtils.normalize((String)this.data.filename)));
            if (this.meta.isZipped()) {
                this.data.zi = new ZipInputStream(this.data.fr);
                this.data.zi.getNextEntry();
                this.data.isr = this.meta.getEncoding() != null && this.meta.getEnclosure().length() > 0 ? new InputStreamReader((InputStream)new BufferedInputStream(this.data.zi), this.meta.getEncoding()) : new InputStreamReader(new BufferedInputStream(this.data.zi));
            } else {
                this.data.isr = this.meta.getEncoding() != null && this.meta.getEnclosure().length() > 0 ? new InputStreamReader((InputStream)new BufferedInputStream(this.data.fr), this.meta.getEncoding()) : new InputStreamReader(new BufferedInputStream(this.data.fr));
            }
            this.debug = "openNextFile : set all kinds of parameters";
            ++this.data.filenr;
            this.data.doneReading = false;
            int bufferSize = 1;
            bufferSize += this.meta.hasHeader() ? this.meta.getNrHeaderLines() : 0;
            bufferSize += this.meta.isLayoutPaged() ? this.meta.getNrLinesPerPage() : 0;
            bufferSize += this.meta.hasFooter() ? this.meta.getNrFooterLines() : 0;
            if (this.meta.isLayoutPaged()) {
                for (int i = 0; i < this.meta.getNrLinesDocHeader(); ++i) {
                    TextFileInput.getLine(this.log, this.data.isr, this.meta.getFileFormat());
                }
            }
            for (int i = 0; i < bufferSize && !this.data.doneReading; ++i) {
                String line = TextFileInput.getLine(this.log, this.data.isr, this.meta.getFileFormat());
                if (line != null) {
                    ++this.linesInput;
                    this.data.lineBuffer.add(line);
                    continue;
                }
                this.data.doneReading = true;
            }
            this.data.headerLinesRead = 0;
            this.data.footerLinesRead = 0;
            this.data.pageLinesRead = 0;
            this.data.doneWithHeader = !this.meta.hasHeader();
        }
        catch (Exception e) {
            this.logError("Couldn't open file #" + this.data.filenr + " : " + this.data.filename + " (" + this.debug + ") --> " + e.toString());
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TextFileInputMeta)smi;
        this.data = (TextFileInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.files = this.meta.getFiles();
            if (this.data.files == null || this.data.files.length == 0) {
                this.logError("No file(s) specified! Stop processing.");
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TextFileInputMeta)smi;
        this.data = (TextFileInputData)sdi;
        super.dispose(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

