/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.textfileoutput;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileoutput.TextFileField;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileoutput.TextFileOutputData;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileoutput.TextFileOutputMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.value.Value;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;

public class TextFileOutput
extends BaseStep
implements StepInterface {
    private TextFileOutputMeta meta;
    private TextFileOutputData data;

    public TextFileOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (TextFileOutputMeta)smi;
        this.data = (TextFileOutputData)sdi;
        boolean result = true;
        Row r = this.getRow();
        if (r == null && this.data.headerrow != null && this.meta.isFooterEnabled() || r != null && this.linesOutput > 0L && this.meta.getSplitEvery() > 0 && this.linesOutput % (long)this.meta.getSplitEvery() == 0L) {
            if (this.writeHeader()) {
                ++this.linesOutput;
            }
            this.closeFile();
            if (r != null) {
                if (!this.openNewFile()) {
                    this.logError("Unable to open new file (split #" + this.data.splitnr + "...");
                    this.setErrors(1L);
                    return false;
                }
                if (this.meta.isHeaderEnabled() && this.data.headerrow != null && this.writeHeader()) {
                    ++this.linesOutput;
                }
            }
        }
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        result = this.writeRowToFile(r);
        if (!result) {
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
        this.putRow(r);
        if (this.linesOutput > 0L && this.linesOutput % 5000L == 0L) {
            this.logBasic("linenr " + this.linesOutput);
        }
        return result;
    }

    private boolean writeRowToFile(Row r) {
        this.debug = "row to file";
        try {
            int i;
            this.debug = "Start";
            if (this.first) {
                this.first = false;
                if (!this.meta.isFileAppended() && (this.meta.isHeaderEnabled() || this.meta.isFooterEnabled())) {
                    this.data.headerrow = new Row(r);
                    if (this.meta.isHeaderEnabled() && this.writeHeader()) {
                        return false;
                    }
                }
                this.data.fieldnrs = new int[this.meta.getOutputFields().length];
                this.debug = "Get fieldnrs... field_name.length=" + this.meta.getOutputFields().length;
                for (i = 0; i < this.meta.getOutputFields().length; ++i) {
                    this.data.fieldnrs[i] = r.searchValueIndex(this.meta.getOutputFields()[i].getName());
                    if (this.data.fieldnrs[i] >= 0) continue;
                    this.logError("Field [" + this.meta.getOutputFields()[i].getName() + "] couldn't be found in the input stream!");
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
            if (this.meta.getOutputFields() == null || this.meta.getOutputFields().length == 0) {
                this.debug = "Loop fields 0.." + r.size();
                for (i = 0; i < r.size(); ++i) {
                    this.debug = "start for loop";
                    if (i > 0) {
                        this.data.writer.write(this.meta.getSeparator().toCharArray());
                    }
                    this.debug = "Get value " + i + " of " + r.size();
                    Value v = r.getValue(i);
                    this.debug = "Write field to output stream: [" + v.toString() + "] of type [" + v.toStringMeta() + "]";
                    this.writeField(v, -1);
                }
                this.data.writer.write(this.meta.getNewline().toCharArray());
            } else {
                this.debug = "Loop fields 0.." + this.meta.getOutputFields().length;
                for (i = 0; i < this.meta.getOutputFields().length; ++i) {
                    this.debug = "start for loop";
                    if (i > 0) {
                        this.data.writer.write(this.meta.getSeparator().toCharArray());
                    }
                    this.debug = "Get value " + this.data.fieldnrs[i] + " of row ";
                    Value v = r.getValue(this.data.fieldnrs[i]);
                    v.setLength(this.meta.getOutputFields()[i].getLength(), this.meta.getOutputFields()[i].getPrecision());
                    this.writeField(v, i);
                }
                this.data.writer.write(this.meta.getNewline().toCharArray());
            }
        }
        catch (Exception e) {
            this.logError("Error writing line in [" + this.debug + "] :" + e.toString());
            return false;
        }
        ++this.linesOutput;
        return true;
    }

    private String formatField(Value v, int idx) {
        String retval = "";
        TextFileField field = null;
        if (idx >= 0) {
            field = this.meta.getOutputFields()[idx];
        }
        if (v.isBigNumber()) {
            retval = retval + v.getString();
        } else if (v.isNumeric()) {
            this.debug = "Number is formatted?";
            if (idx >= 0 && field != null && field.getFormat() != null) {
                if (v.isNull()) {
                    if (field.getNullString() != null) {
                        retval = field.getNullString();
                    }
                } else {
                    this.debug = "Formatted number pattern, field=" + v.getName() + ", idx=" + idx;
                    this.data.df.applyPattern(field.getFormat());
                    if (field.getDecimalSymbol() != null && field.getDecimalSymbol().length() > 0) {
                        this.data.dfs.setDecimalSeparator(field.getDecimalSymbol().charAt(0));
                    }
                    if (field.getGroupingSymbol() != null && field.getGroupingSymbol().length() > 0) {
                        this.data.dfs.setGroupingSeparator(field.getGroupingSymbol().charAt(0));
                    }
                    if (field.getCurrencySymbol() != null) {
                        this.data.dfs.setCurrencySymbol(field.getCurrencySymbol());
                    }
                    this.data.df.setDecimalFormatSymbols(this.data.dfs);
                    retval = this.data.df.format(v.getNumber());
                }
            } else {
                this.debug = "Not formatted number";
                if (v.isNull()) {
                    if (idx >= 0 && field != null && field.getNullString() != null) {
                        retval = field.getNullString();
                    }
                } else {
                    retval = v.toString();
                }
            }
        } else if (v.isDate()) {
            this.debug = "Date is formatted?";
            if (idx >= 0 && field != null && field.getFormat() != null && v.getDate() != null) {
                this.debug = "Formatted date pattern, field=" + v.getName() + ", idx=" + idx;
                this.data.daf.applyPattern(field.getFormat());
                this.data.daf.setDateFormatSymbols(this.data.dafs);
                retval = this.data.daf.format(v.getDate());
            } else if (v.isNull() || v.getDate() == null) {
                if (idx >= 0 && field != null && field.getNullString() != null) {
                    retval = field.getNullString();
                }
            } else {
                retval = v.toString();
            }
        } else if (v.isString()) {
            this.debug = "String length=" + v.getLength() + ", value=" + v.toString();
            if (v.isNull() || v.getString() == null) {
                if (idx >= 0 && field != null && field.getNullString() != null) {
                    retval = field.getNullString();
                }
            } else {
                int seppos = v.toString().indexOf(this.meta.getSeparator());
                retval = seppos < 0 ? v.toString() : this.meta.getEnclosure() + v.toString() + this.meta.getEnclosure();
            }
        } else {
            this.debug = "Boolean: " + v.getBoolean();
            if (v.isNull()) {
                if (idx >= 0 && field != null && field.getNullString() != null) {
                    retval = field.getNullString();
                }
            } else {
                retval = v.toString();
            }
        }
        if (this.meta.isPadded()) {
            int precision;
            int length;
            if (idx < 0 || field == null) {
                length = v.getLength() < 0 ? 0 : v.getLength();
                precision = v.getPrecision() < 0 ? 0 : v.getPrecision();
            } else {
                length = field.getLength() < 0 ? 0 : field.getLength();
                int n = precision = field.getPrecision() < 0 ? 0 : field.getPrecision();
            }
            if (v.isNumber()) {
                ++length;
                if (precision > 0) {
                    ++length;
                }
            }
            if (v.isDate()) {
                length = 23;
                precision = 0;
            }
            if (v.isBoolean()) {
                length = 5;
                precision = 0;
            }
            retval = Const.rightPad(new StringBuffer(retval), length + precision);
        }
        this.debug = "end of formatField";
        return retval;
    }

    private boolean writeField(Value v, int idx) {
        try {
            String str = this.formatField(v, idx);
            if (str != null) {
                this.data.writer.write(str.toCharArray());
            }
            this.debug = "end of writeField";
        }
        catch (Exception e) {
            this.logError("Error writing line in [" + this.debug + "] :" + e.toString());
            return false;
        }
        return true;
    }

    private boolean writeHeader() {
        this.debug = "header";
        boolean retval = false;
        Row r = this.data.headerrow;
        try {
            if (this.meta.getOutputFields() != null && this.meta.getOutputFields().length > 0) {
                String header = "";
                for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                    if (i > 0 && this.meta.getSeparator() != null && this.meta.getSeparator().length() > 0) {
                        header = header + this.meta.getSeparator();
                    }
                    header = header + this.meta.getOutputFields()[i].getName();
                }
                header = header + this.meta.getNewline();
                this.data.writer.write(header.toCharArray());
            } else if (r != null) {
                for (int i = 0; i < r.size(); ++i) {
                    if (i > 0) {
                        this.data.writer.write(this.meta.getSeparator().toCharArray());
                    }
                    Value v = r.getValue(i);
                    Value header_value = new Value(v.getName(), 2);
                    header_value.setValue(v.getName());
                    int idx = -1;
                    for (int x = 0; x < this.meta.getOutputFields().length && idx < 0; ++x) {
                        if (!this.meta.getOutputFields()[x].getName().equalsIgnoreCase(v.getName())) continue;
                        idx = x;
                    }
                    switch (v.getType()) {
                        case 3: {
                            v.setValue(new Date());
                            break;
                        }
                        case 2: {
                            v.setValue("a");
                            break;
                        }
                    }
                    this.data.writer.write(header_value.toString().toCharArray());
                }
                this.data.writer.write(this.meta.getNewline().toCharArray());
            } else {
                this.data.writer.write(("no rows selected" + Const.CR).toCharArray());
            }
        }
        catch (Exception e) {
            this.logError("Error writing header line: " + e.toString());
            e.printStackTrace();
            retval = true;
        }
        ++this.linesOutput;
        return retval;
    }

    public String buildFilename(boolean ziparchive) {
        return this.meta.buildFilename(this.getCopy(), this.data.splitnr, ziparchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openNewFile() {
        boolean retval = false;
        this.data.writer = null;
        FileOutputStream fos = null;
        OutputStream outputStream = null;
        try {
            File file = new File(FilenameUtils.normalize((String)this.buildFilename(true)));
            if (this.meta.isZipped()) {
                fos = new FileOutputStream(file, this.meta.isFileAppended());
                this.data.zip = new ZipOutputStream(fos);
                File entry = new File(FilenameUtils.normalize((String)this.buildFilename(false)));
                ZipEntry zipentry = new ZipEntry(entry.getName());
                zipentry.setComment("Compressed by Kettle");
                this.data.zip.putNextEntry(zipentry);
                outputStream = this.data.zip;
            } else {
                outputStream = fos = new FileOutputStream(file, this.meta.isFileAppended());
            }
            if (this.meta.getEncoding() != null && this.meta.getEncoding().length() > 0) {
                this.log.logBasic(this.toString(), "Opening output stream in encoding: " + this.meta.getEncoding());
                this.data.writer = new OutputStreamWriter(outputStream, this.meta.getEncoding());
            } else {
                this.log.logBasic(this.toString(), "Opening output stream in default encoding");
                this.data.writer = new OutputStreamWriter(outputStream);
            }
            retval = true;
        }
        catch (Exception e) {
            try {
                this.logError("Error opening new file : " + e.toString());
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{outputStream, fos});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{outputStream, fos});
        }
        CloseUtil.close((Closeable[])new Closeable[]{outputStream, fos});
        ++this.data.splitnr;
        return retval;
    }

    private boolean closeFile() {
        boolean retval = false;
        try {
            if (this.meta.isZipped()) {
                this.data.zip.closeEntry();
                this.data.zip.finish();
                this.data.zip.close();
            } else {
                this.data.writer.close();
            }
            retval = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TextFileOutputMeta)smi;
        this.data = (TextFileOutputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.splitnr = 0;
            if (this.openNewFile()) {
                this.debug = "start";
                return true;
            }
            this.logError("Couldn't open file " + this.meta.getFileName() + " [" + this.debug + "]");
            this.setErrors(1L);
            this.stopAll();
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TextFileOutputMeta)smi;
        this.data = (TextFileOutputData)sdi;
        super.dispose(smi, sdi);
        this.closeFile();
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

