/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.xmlinput;

import com.kingdee.bos.ctrl.etl.exception.ETLValueException;
import com.kingdee.bos.ctrl.etl.util.Const;
import java.util.ArrayList;

public class XMLInputFieldPosition {
    public static final int XML_ELEMENT = 1;
    public static final int XML_ATTRIBUTE = 2;
    public static final String NR_MARKER = "/";
    private String name;
    private int type;
    private int elementNr;

    public XMLInputFieldPosition(String name, int type) {
        this.name = name;
        this.type = type;
        this.elementNr = 1;
    }

    public XMLInputFieldPosition(String name, int type, int elementNr) {
        this.name = name;
        this.type = type;
        this.elementNr = elementNr;
    }

    public String toString() {
        String enc = "";
        enc = this.type == 1 ? enc + "E=" : enc + "A=";
        enc = enc + this.name;
        enc = enc + NR_MARKER + (this.elementNr <= 0 ? 1 : this.elementNr);
        return enc;
    }

    public XMLInputFieldPosition(String encoded) throws ETLValueException {
        String nameAndNumber;
        int equalIndex = encoded.indexOf("=");
        if (equalIndex < 0) {
            throw new ETLValueException("Sorry, this is not a valid XML Field Position (no equal sign in code: '" + encoded + "')");
        }
        String positionType = Const.trim(encoded.substring(0, equalIndex));
        String positionName = nameAndNumber = Const.trim(encoded.substring(equalIndex + 1));
        int semiIndex = nameAndNumber.indexOf(NR_MARKER);
        if (semiIndex >= 0) {
            this.elementNr = Const.toInt(nameAndNumber.substring(semiIndex + 1), 1);
            positionName = nameAndNumber.substring(0, semiIndex);
        } else {
            this.elementNr = 1;
        }
        if (positionType.equalsIgnoreCase("E")) {
            this.type = 1;
            this.name = positionName;
        } else if (positionType.equalsIgnoreCase("A")) {
            this.type = 2;
            this.name = positionName;
        } else {
            throw new ETLValueException("Sorry, the position type can either be E (element) or A (attribute), you specified " + positionType);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getElementNr() {
        return this.elementNr;
    }

    public void setElementNr(int elementNr) {
        this.elementNr = elementNr;
    }

    public static final String encodePath(ArrayList path) {
        String encoded = "";
        for (int p = 0; p < path.size(); ++p) {
            XMLInputFieldPosition pos = (XMLInputFieldPosition)path.get(p);
            String elementName = pos.toString();
            if (p > 0) {
                encoded = encoded + ",";
            }
            encoded = encoded + elementName;
        }
        return encoded;
    }
}

