/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERObjectIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.DERSequence;
import com.kingdee.bos.ctrl.cipher.asn1.isismtt.x509.AdmissionSyntax;
import com.kingdee.bos.ctrl.cipher.asn1.isismtt.x509.Admissions;
import com.kingdee.bos.ctrl.cipher.asn1.isismtt.x509.NamingAuthority;
import com.kingdee.bos.ctrl.cipher.asn1.isismtt.x509.ProfessionInfo;
import com.kingdee.bos.ctrl.cipher.asn1.test.ASN1UnitTest;
import com.kingdee.bos.ctrl.cipher.asn1.x500.DirectoryString;
import com.kingdee.bos.ctrl.cipher.asn1.x509.GeneralName;
import com.kingdee.bos.ctrl.cipher.asn1.x509.X509Name;
import java.io.IOException;

public class AdmissionSyntaxUnitTest
extends ASN1UnitTest {
    @Override
    public String getName() {
        return "AdmissionSyntax";
    }

    @Override
    public void performTest() throws Exception {
        GeneralName name = new GeneralName(new X509Name("CN=hello world"));
        DERSequence admissions = new DERSequence(new Admissions(name, new NamingAuthority(new DERObjectIdentifier("1.2.3"), "url", new DirectoryString("fred")), new ProfessionInfo[0]));
        AdmissionSyntax syntax = new AdmissionSyntax(name, admissions);
        this.checkConstruction(syntax, name, admissions);
        syntax = AdmissionSyntax.getInstance(null);
        if (syntax != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            AdmissionSyntax.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(AdmissionSyntax syntax, GeneralName authority, ASN1Sequence admissions) throws IOException {
        this.checkValues(syntax, authority, admissions);
        syntax = AdmissionSyntax.getInstance(syntax);
        this.checkValues(syntax, authority, admissions);
        ASN1InputStream aIn = new ASN1InputStream(syntax.toASN1Object().getEncoded());
        ASN1Sequence info = (ASN1Sequence)aIn.readObject();
        syntax = AdmissionSyntax.getInstance(info);
        this.checkValues(syntax, authority, admissions);
    }

    private void checkValues(AdmissionSyntax syntax, GeneralName authority, ASN1Sequence admissions) {
        this.checkMandatoryField("admissionAuthority", authority, syntax.getAdmissionAuthority());
        Admissions[] adm = syntax.getContentsOfAdmissions();
        if (adm.length != 1 || !adm[0].equals(admissions.getObjectAt(0))) {
            this.fail("admissions check failed");
        }
    }

    public static void main(String[] args) {
        AdmissionSyntaxUnitTest.runTest(new AdmissionSyntaxUnitTest());
    }
}

