/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.DERObject;
import com.kingdee.bos.ctrl.cipher.asn1.x509.qualified.Iso4217CurrencyCode;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;

public class Iso4217CurrencyCodeUnitTest
extends SimpleTest {
    private static final String ALPHABETIC_CURRENCY_CODE = "AUD";
    private static final int NUMERIC_CURRENCY_CODE = 1;

    @Override
    public String getName() {
        return "Iso4217CurrencyCode";
    }

    @Override
    public void performTest() throws Exception {
        Iso4217CurrencyCode cc = new Iso4217CurrencyCode(ALPHABETIC_CURRENCY_CODE);
        this.checkNumeric(cc, ALPHABETIC_CURRENCY_CODE);
        cc = Iso4217CurrencyCode.getInstance(cc);
        this.checkNumeric(cc, ALPHABETIC_CURRENCY_CODE);
        DERObject obj = cc.toASN1Object();
        cc = Iso4217CurrencyCode.getInstance(obj);
        this.checkNumeric(cc, ALPHABETIC_CURRENCY_CODE);
        cc = new Iso4217CurrencyCode(1);
        this.checkNumeric(cc, 1);
        cc = Iso4217CurrencyCode.getInstance(cc);
        this.checkNumeric(cc, 1);
        obj = cc.toASN1Object();
        cc = Iso4217CurrencyCode.getInstance(obj);
        this.checkNumeric(cc, 1);
        cc = Iso4217CurrencyCode.getInstance(null);
        if (cc != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            Iso4217CurrencyCode.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new Iso4217CurrencyCode("ABCD");
            this.fail("constructor failed to detect out of range currencycode.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new Iso4217CurrencyCode(0);
            this.fail("constructor failed to detect out of range small numeric code.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new Iso4217CurrencyCode(1000);
            this.fail("constructor failed to detect out of range large numeric code.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkNumeric(Iso4217CurrencyCode cc, String code) {
        if (!cc.isAlphabetic()) {
            this.fail("non-alphabetic code found when one expected.");
        }
        if (!cc.getAlphabetic().equals(code)) {
            this.fail("string codes don't match.");
        }
    }

    private void checkNumeric(Iso4217CurrencyCode cc, int code) {
        if (cc.isAlphabetic()) {
            this.fail("alphabetic code found when one not expected.");
        }
        if (cc.getNumeric() != code) {
            this.fail("numeric codes don't match.");
        }
    }

    public static void main(String[] args) {
        Iso4217CurrencyCodeUnitTest.runTest(new Iso4217CurrencyCodeUnitTest());
    }
}

