/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.DERObject;
import com.kingdee.bos.ctrl.cipher.asn1.DERObjectIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.x509.qualified.TypeOfBiometricData;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;
import java.io.IOException;

public class TypeOfBiometricDataUnitTest
extends SimpleTest {
    @Override
    public String getName() {
        return "TypeOfBiometricData";
    }

    @Override
    public void performTest() throws Exception {
        this.checkPredefinedType(0);
        this.checkPredefinedType(1);
        DERObjectIdentifier localType = new DERObjectIdentifier("1.1");
        TypeOfBiometricData type = new TypeOfBiometricData(localType);
        this.checkNonPredefined(type, localType);
        type = TypeOfBiometricData.getInstance(type);
        this.checkNonPredefined(type, localType);
        DERObject obj = type.toASN1Object();
        type = TypeOfBiometricData.getInstance(obj);
        this.checkNonPredefined(type, localType);
        type = TypeOfBiometricData.getInstance(null);
        if (type != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            TypeOfBiometricData.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new TypeOfBiometricData(100);
            this.fail("constructor failed to detect bad predefined type.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkPredefinedType(int predefinedType) throws IOException {
        TypeOfBiometricData type = new TypeOfBiometricData(predefinedType);
        this.checkPredefined(type, predefinedType);
        type = TypeOfBiometricData.getInstance(type);
        this.checkPredefined(type, predefinedType);
        ASN1InputStream aIn = new ASN1InputStream(type.toASN1Object().getEncoded());
        DERObject obj = aIn.readObject();
        type = TypeOfBiometricData.getInstance(obj);
        this.checkPredefined(type, predefinedType);
    }

    private void checkPredefined(TypeOfBiometricData type, int value) {
        if (!type.isPredefined()) {
            this.fail("predefined type expected but not found.");
        }
        if (type.getPredefinedBiometricType() != value) {
            this.fail("predefined type does not match.");
        }
    }

    private void checkNonPredefined(TypeOfBiometricData type, DERObjectIdentifier value) {
        if (type.isPredefined()) {
            this.fail("predefined type found when not expected.");
        }
        if (!type.getBiometricDataOid().equals(value)) {
            this.fail("data oid does not match.");
        }
    }

    public static void main(String[] args) {
        TypeOfBiometricDataUnitTest.runTest(new TypeOfBiometricDataUnitTest());
    }
}

