/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.test;

import com.kingdee.bos.ctrl.cipher.crypto.BlockCipher;
import com.kingdee.bos.ctrl.cipher.crypto.BufferedBlockCipher;
import com.kingdee.bos.ctrl.cipher.crypto.CipherParameters;
import com.kingdee.bos.ctrl.cipher.crypto.engines.DESEngine;
import com.kingdee.bos.ctrl.cipher.crypto.engines.SkipjackEngine;
import com.kingdee.bos.ctrl.cipher.crypto.modes.CBCBlockCipher;
import com.kingdee.bos.ctrl.cipher.crypto.modes.CTSBlockCipher;
import com.kingdee.bos.ctrl.cipher.crypto.params.KeyParameter;
import com.kingdee.bos.ctrl.cipher.crypto.params.ParametersWithIV;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;

public class CTSTest
extends SimpleTest {
    static byte[] in1 = Hex.decode("4e6f7720697320746865207420");
    static byte[] in2 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f0aaa");
    static byte[] out1 = Hex.decode("9952f131588465033fa40e8a98");
    static byte[] out2 = Hex.decode("358f84d01eb42988dc34efb994");
    static byte[] out3 = Hex.decode("170171cfad3f04530c509b0c1f0be0aefbd45a8e3755a873bff5ea198504b71683c6");

    private void testCTS(int id, BlockCipher cipher, CipherParameters params, byte[] input, byte[] output) throws Exception {
        byte[] out = new byte[input.length];
        CTSBlockCipher engine = new CTSBlockCipher(cipher);
        engine.init(true, params);
        int len = ((BufferedBlockCipher)engine).processBytes(input, 0, input.length, out, 0);
        ((BufferedBlockCipher)engine).doFinal(out, len);
        if (!this.areEqual(output, out)) {
            this.fail("failed encryption expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
        engine.init(false, params);
        len = ((BufferedBlockCipher)engine).processBytes(output, 0, output.length, out, 0);
        ((BufferedBlockCipher)engine).doFinal(out, len);
        if (!this.areEqual(input, out)) {
            this.fail("failed encryption expected " + new String(Hex.encode(input)) + " got " + new String(Hex.encode(out)));
        }
    }

    @Override
    public String getName() {
        return "CTS";
    }

    @Override
    public void performTest() throws Exception {
        byte[] key1 = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        byte[] key2 = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -18, -1};
        byte[] iv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        this.testCTS(1, new DESEngine(), new KeyParameter(key1), in1, out1);
        this.testCTS(2, new CBCBlockCipher(new DESEngine()), new ParametersWithIV(new KeyParameter(key1), iv), in1, out2);
        this.testCTS(3, new CBCBlockCipher(new SkipjackEngine()), new ParametersWithIV(new KeyParameter(key2), iv), in2, out3);
    }

    public static void main(String[] args) {
        CTSTest.runTest(new CTSTest());
    }
}

