/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.test;

import com.kingdee.bos.ctrl.cipher.crypto.Digest;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;

public abstract class DigestTest
extends SimpleTest {
    private Digest digest;
    private String[] input;
    private String[] results;

    DigestTest(Digest digest, String[] input, String[] results) {
        this.digest = digest;
        this.input = input;
        this.results = results;
    }

    @Override
    public String getName() {
        return this.digest.getAlgorithmName();
    }

    @Override
    public void performTest() {
        byte[] resBuf = new byte[this.digest.getDigestSize()];
        for (int i = 0; i < this.input.length - 1; ++i) {
            byte[] m = this.toByteArray(this.input[i]);
            this.vectorTest(this.digest, i, resBuf, m, Hex.decode(this.results[i]));
        }
        byte[] lastV = this.toByteArray(this.input[this.input.length - 1]);
        byte[] lastDigest = Hex.decode(this.results[this.input.length - 1]);
        this.vectorTest(this.digest, this.input.length - 1, resBuf, lastV, Hex.decode(this.results[this.input.length - 1]));
        this.digest.update(lastV, 0, lastV.length / 2);
        Digest d = this.cloneDigest(this.digest);
        this.digest.update(lastV, lastV.length / 2, lastV.length - lastV.length / 2);
        this.digest.doFinal(resBuf, 0);
        if (!this.areEqual(lastDigest, resBuf)) {
            this.fail("failing clone vector test", this.results[this.results.length - 1], new String(Hex.encode(resBuf)));
        }
        d.update(lastV, lastV.length / 2, lastV.length - lastV.length / 2);
        d.doFinal(resBuf, 0);
        if (!this.areEqual(lastDigest, resBuf)) {
            this.fail("failing second clone vector test", this.results[this.results.length - 1], new String(Hex.encode(resBuf)));
        }
    }

    private byte[] toByteArray(String input) {
        byte[] bytes = new byte[input.length()];
        for (int i = 0; i != bytes.length; ++i) {
            bytes[i] = (byte)input.charAt(i);
        }
        return bytes;
    }

    private void vectorTest(Digest digest, int count, byte[] resBuf, byte[] input, byte[] expected) {
        digest.update(input, 0, input.length);
        digest.doFinal(resBuf, 0);
        if (!this.areEqual(resBuf, expected)) {
            System.out.println(new String(Hex.decode(input)));
            this.fail("Vector " + count + " failed got " + new String(Hex.encode(resBuf)));
        }
    }

    protected abstract Digest cloneDigest(Digest var1);

    protected void millionATest(String expected) {
        byte[] resBuf = new byte[this.digest.getDigestSize()];
        for (int i = 0; i < 1000000; ++i) {
            this.digest.update((byte)97);
        }
        this.digest.doFinal(resBuf, 0);
        if (!this.areEqual(resBuf, Hex.decode(expected))) {
            this.fail("Million a's failed");
        }
    }

    protected void sixtyFourKTest(String expected) {
        byte[] resBuf = new byte[this.digest.getDigestSize()];
        for (int i = 0; i < 65536; ++i) {
            this.digest.update((byte)(i & 0xFF));
        }
        this.digest.doFinal(resBuf, 0);
        if (!this.areEqual(resBuf, Hex.decode(expected))) {
            this.fail("64k test failed");
        }
    }
}

