/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.test;

import com.kingdee.bos.ctrl.cipher.crypto.engines.DESEngine;
import com.kingdee.bos.ctrl.cipher.crypto.macs.ISO9797Alg3Mac;
import com.kingdee.bos.ctrl.cipher.crypto.params.KeyParameter;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;

public class ISO9797Alg3MacTest
extends SimpleTest {
    static byte[] keyBytes = Hex.decode("7CA110454A1A6E570131D9619DC1376E");
    static byte[] ivBytes = Hex.decode("0000000000000000");
    static byte[] input1 = "Hello World !!!!".getBytes();
    static byte[] output1 = Hex.decode("F09B856213BAB83B");

    @Override
    public void performTest() {
        KeyParameter key = new KeyParameter(keyBytes);
        DESEngine cipher = new DESEngine();
        ISO9797Alg3Mac mac = new ISO9797Alg3Mac(cipher);
        mac.init(key);
        mac.update(input1, 0, input1.length);
        byte[] out = new byte[8];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output1)) {
            this.fail("Failed - expected " + new String(Hex.encode(output1)) + " got " + new String(Hex.encode(out)));
        }
        mac.reset();
        mac.init(key);
        for (int i = 0; i != input1.length / 2; ++i) {
            mac.update(input1[i]);
        }
        mac.update(input1, input1.length / 2, input1.length - input1.length / 2);
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output1)) {
            this.fail("Reset failed - expected " + new String(Hex.encode(output1)) + " got " + new String(Hex.encode(out)));
        }
    }

    @Override
    public String getName() {
        return "ISO9797Alg3Mac";
    }

    public static void main(String[] args) {
        ISO9797Alg3MacTest.runTest(new ISO9797Alg3MacTest());
    }
}

