/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.test;

import com.kingdee.bos.ctrl.cipher.crypto.DataLengthException;
import com.kingdee.bos.ctrl.cipher.crypto.engines.NullEngine;
import com.kingdee.bos.ctrl.cipher.crypto.params.KeyParameter;
import com.kingdee.bos.ctrl.cipher.crypto.test.BlockCipherVectorTest;
import com.kingdee.bos.ctrl.cipher.crypto.test.CipherTest;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;

public class NullTest
extends CipherTest {
    static SimpleTest[] tests = new SimpleTest[]{new BlockCipherVectorTest(0, new NullEngine(), new KeyParameter(Hex.decode("00")), "00", "00")};

    NullTest() {
        super(tests, new NullEngine(), new KeyParameter(new byte[2]));
    }

    @Override
    public String getName() {
        return "Null";
    }

    @Override
    public void performTest() throws Exception {
        super.performTest();
        NullEngine engine = new NullEngine();
        engine.init(true, null);
        byte[] buf = new byte[1];
        engine.processBlock(buf, 0, buf, 0);
        if (buf[0] != 0) {
            this.fail("NullCipher changed data!");
        }
        byte[] shortBuf = new byte[]{};
        try {
            engine.processBlock(shortBuf, 0, buf, 0);
            this.fail("failed short input check");
        }
        catch (DataLengthException dataLengthException) {
            // empty catch block
        }
        try {
            engine.processBlock(buf, 0, shortBuf, 0);
            this.fail("failed short output check");
        }
        catch (DataLengthException dataLengthException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        NullTest.runTest(new NullTest());
    }
}

