/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.test;

import com.kingdee.bos.ctrl.cipher.crypto.CipherParameters;
import com.kingdee.bos.ctrl.cipher.crypto.PBEParametersGenerator;
import com.kingdee.bos.ctrl.cipher.crypto.digests.SHA1Digest;
import com.kingdee.bos.ctrl.cipher.crypto.generators.PKCS12ParametersGenerator;
import com.kingdee.bos.ctrl.cipher.crypto.params.KeyParameter;
import com.kingdee.bos.ctrl.cipher.crypto.params.ParametersWithIV;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTestResult;
import com.kingdee.bos.ctrl.cipher.util.test.Test;
import com.kingdee.bos.ctrl.cipher.util.test.TestResult;

public class PKCS12Test
implements Test {
    char[] secretCode1 = new char[]{'s', 'm', 'e', 'g'};
    char[] secretCode2 = new char[]{'q', 'u', 'e', 'e', 'g'};

    private boolean isEqual(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i != a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private TestResult run1(int id, char[] password, byte[] salt, int iCount, byte[] result) {
        PKCS12ParametersGenerator generator = new PKCS12ParametersGenerator(new SHA1Digest());
        generator.init(PBEParametersGenerator.PKCS12PasswordToBytes(password), salt, iCount);
        CipherParameters key = ((PBEParametersGenerator)generator).generateDerivedParameters(192);
        if (this.isEqual(result, ((KeyParameter)key).getKey())) {
            return new SimpleTestResult(true, "PKCS12Test: Okay");
        }
        return new SimpleTestResult(false, "PKCS12Test: id " + id + " Failed");
    }

    private TestResult run2(int id, char[] password, byte[] salt, int iCount, byte[] result) {
        PKCS12ParametersGenerator generator = new PKCS12ParametersGenerator(new SHA1Digest());
        generator.init(PBEParametersGenerator.PKCS12PasswordToBytes(password), salt, iCount);
        ParametersWithIV params = (ParametersWithIV)((PBEParametersGenerator)generator).generateDerivedParameters(64, 64);
        if (this.isEqual(result, params.getIV())) {
            return new SimpleTestResult(true, "PKCS12Test: Okay");
        }
        return new SimpleTestResult(false, "PKCS12Test: id " + id + " Failed");
    }

    private TestResult run3(int id, char[] password, byte[] salt, int iCount, byte[] result) {
        PKCS12ParametersGenerator generator = new PKCS12ParametersGenerator(new SHA1Digest());
        generator.init(PBEParametersGenerator.PKCS12PasswordToBytes(password), salt, iCount);
        CipherParameters key = ((PBEParametersGenerator)generator).generateDerivedMacParameters(160);
        if (this.isEqual(result, ((KeyParameter)key).getKey())) {
            return new SimpleTestResult(true, "PKCS12Test: Okay");
        }
        return new SimpleTestResult(false, "PKCS12Test: id " + id + " Failed");
    }

    @Override
    public String getName() {
        return "PKCS12Test";
    }

    @Override
    public TestResult perform() {
        TestResult result = this.run1(1, this.secretCode1, Hex.decode("0A58CF64530D823F"), 1, Hex.decode("8AAAE6297B6CB04642AB5B077851284EB7128F1A2A7FBCA3"));
        if (result.isSuccessful()) {
            result = this.run2(2, this.secretCode1, Hex.decode("0A58CF64530D823F"), 1, Hex.decode("79993DFE048D3B76"));
        }
        if (result.isSuccessful()) {
            result = this.run1(3, this.secretCode1, Hex.decode("642B99AB44FB4B1F"), 1, Hex.decode("F3A95FEC48D7711E985CFE67908C5AB79FA3D7C5CAA5D966"));
        }
        if (result.isSuccessful()) {
            result = this.run2(4, this.secretCode1, Hex.decode("642B99AB44FB4B1F"), 1, Hex.decode("C0A38D64A79BEA1D"));
        }
        if (result.isSuccessful()) {
            result = this.run3(5, this.secretCode1, Hex.decode("3D83C0E4546AC140"), 1, Hex.decode("8D967D88F6CAA9D714800AB3D48051D63F73A312"));
        }
        if (result.isSuccessful()) {
            result = this.run1(6, this.secretCode2, Hex.decode("05DEC959ACFF72F7"), 1000, Hex.decode("ED2034E36328830FF09DF1E1A07DD357185DAC0D4F9EB3D4"));
        }
        if (result.isSuccessful()) {
            result = this.run2(7, this.secretCode2, Hex.decode("05DEC959ACFF72F7"), 1000, Hex.decode("11DEDAD7758D4860"));
        }
        if (result.isSuccessful()) {
            result = this.run1(8, this.secretCode2, Hex.decode("1682C0FC5B3F7EC5"), 1000, Hex.decode("483DD6E919D7DE2E8E648BA8F862F3FBFBDC2BCB2C02957F"));
        }
        if (result.isSuccessful()) {
            result = this.run2(9, this.secretCode2, Hex.decode("1682C0FC5B3F7EC5"), 1000, Hex.decode("9D461D1B00355C50"));
        }
        if (result.isSuccessful()) {
            result = this.run3(10, this.secretCode2, Hex.decode("263216FCC2FAB31C"), 1000, Hex.decode("5EC4C7A80DF652294C3925B6489A7AB857C83476"));
        }
        return result;
    }

    public static void main(String[] args) {
        PKCS12Test test = new PKCS12Test();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

