/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.math.ec.test;

import com.kingdee.bos.ctrl.cipher.asn1.sec.SECNamedCurves;
import com.kingdee.bos.ctrl.cipher.asn1.x9.X9ECParameters;
import com.kingdee.bos.ctrl.cipher.math.ec.ECFieldElement;
import com.kingdee.bos.ctrl.cipher.math.ec.ECPoint;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.Set;

public class F2mProofer {
    private static final int NUM_SAMPLES = 1000;
    private static final String PATH = "crypto/test/src/org/bouncycastle/math/ec/test/samples/";
    private static final String INPUT_FILE_NAME_PREFIX = "Input_";
    private static final String RESULT_FILE_NAME_PREFIX = "Output_";
    public static final String[] CURVES = new String[]{"sect163r2", "sect233r1", "sect283r1", "sect409r1", "sect571r1"};

    private String pointToString(ECPoint.F2m p) {
        ECFieldElement.F2m x = (ECFieldElement.F2m)p.getX();
        ECFieldElement.F2m y = (ECFieldElement.F2m)p.getY();
        int m = x.getM();
        int len = m / 2 + 5;
        StringBuffer sb = new StringBuffer(len);
        sb.append('(');
        sb.append(x.toBigInteger().toString(16));
        sb.append(", ");
        sb.append(y.toBigInteger().toString(16));
        sb.append(')');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateRandomInput(X9ECParameters x9ECParameters) throws NoSuchAlgorithmException, IOException {
        ECPoint.F2m g = (ECPoint.F2m)x9ECParameters.getG();
        int m = ((ECFieldElement.F2m)g.getX()).getM();
        SecureRandom secRand = SecureRandom.getInstance("SHA1PRNG");
        Properties inputProps = new Properties();
        for (int i = 0; i < 1000; ++i) {
            BigInteger rand = new BigInteger(m, secRand);
            inputProps.put(Integer.toString(i), rand.toString(16));
        }
        String bits = Integer.toString(m);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream("crypto/test/src/org/bouncycastle/math/ec/test/samples/Input_" + bits + ".properties");
            inputProps.store(fos, "Input Samples of length" + bits);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fos});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fos});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void multiplyPoints(X9ECParameters x9ECParameters, String classPrefix) throws IOException {
        ECPoint.F2m g = (ECPoint.F2m)x9ECParameters.getG();
        int m = ((ECFieldElement.F2m)g.getX()).getM();
        String inputFileName = "crypto/test/src/org/bouncycastle/math/ec/test/samples/Input_" + m + ".properties";
        Properties inputProps = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(inputFileName);
            inputProps.load(fis);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fis});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
        Properties outputProps = new Properties();
        for (int i = 0; i < 1000; ++i) {
            BigInteger rand = new BigInteger(inputProps.getProperty(Integer.toString(i)), 16);
            ECPoint.F2m result = (ECPoint.F2m)g.multiply(rand);
            String resultStr = this.pointToString(result);
            outputProps.setProperty(Integer.toString(i), resultStr);
        }
        String outputFileName = "crypto/test/src/org/bouncycastle/math/ec/test/samples/Output_" + classPrefix + "_" + m + ".properties";
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFileName);
            outputProps.store(fos, "Output Samples of length" + m);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fos});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fos});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadResults(String classPrefix, int m) throws IOException {
        Properties res = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("crypto/test/src/org/bouncycastle/math/ec/test/samples/Output_" + classPrefix + "_" + m + ".properties");
            res.load(fis);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fis});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
        return res;
    }

    private void compareResult(X9ECParameters x9ECParameters, String classPrefix1, String classPrefix2) throws IOException {
        ECPoint.F2m g = (ECPoint.F2m)x9ECParameters.getG();
        int m = ((ECFieldElement.F2m)g.getX()).getM();
        Properties res1 = this.loadResults(classPrefix1, m);
        Properties res2 = this.loadResults(classPrefix2, m);
        Set<Object> keys = res1.keySet();
        for (String string : keys) {
            String result2;
            String result1 = res1.getProperty(string);
            if (result1.equals(result2 = res2.getProperty(string))) continue;
            System.err.println("Difference found: m = " + m + ", " + result1 + " does not equal " + result2);
        }
    }

    private static void usage() {
        System.err.println("Usage: F2mProofer [-init | -multiply <className> | -compare <className1> <className2>]");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            F2mProofer.usage();
            return;
        }
        F2mProofer proofer = new F2mProofer();
        if (args[0].equals("-init")) {
            System.out.println("Generating random input...");
            for (int i = 0; i < CURVES.length; ++i) {
                X9ECParameters x9ECParameters = SECNamedCurves.getByName(CURVES[i]);
                proofer.generateRandomInput(x9ECParameters);
            }
            System.out.println("Successfully generated random input in crypto/test/src/org/bouncycastle/math/ec/test/samples/");
        } else if (args[0].equals("-compare")) {
            if (args.length < 3) {
                F2mProofer.usage();
                return;
            }
            String classPrefix1 = args[1];
            String classPrefix2 = args[2];
            System.out.println("Comparing results...");
            for (int i = 0; i < CURVES.length; ++i) {
                X9ECParameters x9ECParameters = SECNamedCurves.getByName(CURVES[i]);
                proofer.compareResult(x9ECParameters, classPrefix1, classPrefix2);
            }
            System.out.println("Successfully compared results in crypto/test/src/org/bouncycastle/math/ec/test/samples/");
        } else if (args[0].equals("-multiply")) {
            if (args.length < 2) {
                F2mProofer.usage();
                return;
            }
            String classPrefix = args[1];
            System.out.println("Multiplying points...");
            for (int i = 0; i < CURVES.length; ++i) {
                X9ECParameters x9ECParameters = SECNamedCurves.getByName(CURVES[i]);
                proofer.multiplyPoints(x9ECParameters, classPrefix);
            }
            System.out.println("Successfully generated multiplied points in crypto/test/src/org/bouncycastle/math/ec/test/samples/");
        } else {
            F2mProofer.usage();
        }
    }
}

