/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.util.encoders.test;

import com.kingdee.bos.ctrl.cipher.util.encoders.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;

public abstract class AbstractCoderTest
extends TestCase {
    private static final int[] SIZES_TO_CHECK = new int[]{64, 128, 1024, 1025, 1026, 2048, 2049, 2050, 4096, 4097, 4098, 8192, 8193, 8194};
    protected Encoder enc;
    private Random r;

    AbstractCoderTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.r = new Random();
    }

    private void checkArrayOfSize(int size) throws IOException {
        byte[] original = new byte[size];
        this.r.nextBytes(original);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.enc.encode(original, 0, original.length, bOut);
        byte[] encoded = bOut.toByteArray();
        AbstractCoderTest.assertTrue((encoded.length > original.length ? 1 : 0) != 0);
        AbstractCoderTest.assertTrue((encoded.length <= original.length * 2 ? 1 : 0) != 0);
        this.checkEncoding(encoded);
        this.checkSimpleDecode(original, encoded);
        this.checkStringDecode(original, encoded);
        this.checkOutputStreamDecode(original, encoded);
        int offset = this.r.nextInt(20);
        byte[] offsetEncoded = new byte[offset + encoded.length];
        System.arraycopy(encoded, 0, offsetEncoded, offset, encoded.length);
        this.checkOffsetDecode(original, offsetEncoded, offset, encoded.length);
        offset = this.r.nextInt(20);
        byte[] offsetOriginal = new byte[offset + original.length];
        System.arraycopy(original, 0, offsetOriginal, offset, original.length);
        this.checkOffsetEncode(original, offsetOriginal, offset, original.length);
        byte[] encodedWithSpace = this.addWhitespace(encoded);
        this.checkSimpleDecode(original, encodedWithSpace);
        this.checkStringDecode(original, encodedWithSpace);
        this.checkOutputStreamDecode(original, encodedWithSpace);
    }

    public void testEncode() throws IOException {
        for (int i = 0; i < SIZES_TO_CHECK.length; ++i) {
            this.checkArrayOfSize(SIZES_TO_CHECK[i]);
        }
    }

    private void checkEncoding(byte[] encoded) {
        String encString = this.convertBytesToString(encoded);
        for (int i = 0; i < encString.length(); ++i) {
            char c = encString.charAt(i);
            if (c == this.paddingChar()) {
                AbstractCoderTest.assertTrue((i > encString.length() - 3 ? 1 : 0) != 0);
                continue;
            }
            if (this.isEncodedChar(c)) continue;
            AbstractCoderTest.fail((String)("Unexpected encoded character " + c));
        }
    }

    private void checkOutputStreamDecode(byte[] original, byte[] encoded) {
        String encString = this.convertBytesToString(encoded);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            AbstractCoderTest.assertEquals((int)original.length, (int)this.enc.decode(encString, out));
            AbstractCoderTest.assertTrue((boolean)Arrays.equals(original, out.toByteArray()));
        }
        catch (IOException e) {
            AbstractCoderTest.fail((String)"This shouldn't happen");
        }
    }

    private void checkSimpleDecode(byte[] original, byte[] encoded) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.enc.decode(encoded, 0, encoded.length, bOut);
        AbstractCoderTest.assertTrue((boolean)Arrays.equals(original, bOut.toByteArray()));
    }

    private void checkOffsetEncode(byte[] original, byte[] offsetOriginal, int off, int length) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.enc.encode(offsetOriginal, off, length, bOut);
        byte[] encoded = bOut.toByteArray();
        bOut.reset();
        this.enc.decode(encoded, 0, encoded.length, bOut);
        AbstractCoderTest.assertTrue((boolean)Arrays.equals(original, bOut.toByteArray()));
    }

    private void checkOffsetDecode(byte[] original, byte[] encoded, int off, int length) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.enc.decode(encoded, off, length, bOut);
        AbstractCoderTest.assertTrue((boolean)Arrays.equals(original, bOut.toByteArray()));
    }

    private void checkStringDecode(byte[] original, byte[] encoded) throws IOException {
        String encString = this.convertBytesToString(encoded);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.enc.decode(encString, bOut);
        AbstractCoderTest.assertTrue((boolean)Arrays.equals(original, bOut.toByteArray()));
    }

    private byte[] addWhitespace(byte[] encoded) {
        int i;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.addSpace(out);
        for (i = 0; i < encoded.length - 5; ++i) {
            out.write(encoded, i, 1);
            if (this.r.nextInt(100) >= 5) continue;
            this.addSpace(out);
        }
        for (i = encoded.length - 5; i < encoded.length; ++i) {
            out.write(encoded, i, 1);
        }
        this.addSpace(out);
        return out.toByteArray();
    }

    private void addSpace(ByteArrayOutputStream out) {
        do {
            switch (this.r.nextInt(3)) {
                case 0: {
                    out.write(10);
                    break;
                }
                case 1: {
                    out.write(13);
                    break;
                }
                case 2: {
                    out.write(9);
                    break;
                }
                case 3: {
                    out.write(32);
                }
            }
        } while (this.r.nextBoolean());
    }

    private String convertBytesToString(byte[] encoded) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i != encoded.length; ++i) {
            b.append((char)(encoded[i] & 0xFF));
        }
        return b.toString();
    }

    protected abstract char paddingChar();

    protected abstract boolean isEncodedChar(char var1);
}

