/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.pe.beans.editor.extend;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.pe.beans.editor.formula.FormulaComposer;
import com.kingdee.bos.ctrl.kds.expans.model.IPreCondition;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class HyperlinkBehaviorAssembler
extends KDPanel {
    private static final long serialVersionUID = 1L;
    private FormulaComposer _conditionComposer;
    private KDTextArea _informationArea;
    private KDComboColor _colorEditor;

    public HyperlinkBehaviorAssembler() {
        this.init();
    }

    private void init() {
        this.initComponents();
    }

    private void initComponents() {
        this.setCustomInsets(new Insets(5, 8, 5, 8));
        TableLayout2 layout = new TableLayout2(3, 2);
        layout.setFixedHeight(0, 20);
        layout.setFixedHeight(1, 20);
        layout.setRatableHeight(2, 1);
        layout.setRowSpacing(0, 8);
        layout.setRowSpacing(1, 8);
        layout.setColSpacing(0, 20);
        layout.setRatableWidth(0, 2);
        layout.setRatableWidth(1, 1);
        this.setLayout((LayoutManager)layout);
        this._conditionComposer = new FormulaComposer();
        this._conditionComposer.setPreferredSize(new Dimension(100, 20));
        KDLabelContainer selectorContainer = new KDLabelContainer();
        selectorContainer.setBoundLabelUnderline(true);
        selectorContainer.setBoundLabelLength(40);
        selectorContainer.setBoundLabelText("\u6761\u4ef6");
        selectorContainer.setBoundEditor((JComponent)((Object)this._conditionComposer));
        KDLabelContainer colorContainer = new KDLabelContainer();
        colorContainer.setBoundLabelUnderline(true);
        colorContainer.setBoundLabelLength(40);
        colorContainer.setBoundLabelText("\u989c\u8272");
        this._colorEditor = new KDComboColor();
        colorContainer.setBoundEditor((JComponent)this._colorEditor);
        this._informationArea = new KDTextArea();
        this._informationArea.setBorder(null);
        this._informationArea.setWrapStyleWord(true);
        this._informationArea.setEditable(false);
        KDPanel panelDesc = new KDPanel();
        panelDesc.setLayout((LayoutManager)new BorderLayout());
        panelDesc.setBorder((Border)new TitledBorder("\u8bf4\u660e"));
        panelDesc.add((Component)this._informationArea, (Object)"Center");
        this.add((Component)selectorContainer, TableLayout2.param((int)0, (int)0, (int)0, (int)1));
        this.add((Component)colorContainer, TableLayout2.param((int)1, (int)0, (int)1, (int)1));
        this.add((Component)panelDesc, TableLayout2.param((int)2, (int)0, (int)2, (int)1));
    }

    public void commit(Object[] targets, Cell cell) {
        if (targets == null) {
            return;
        }
        int lenTar = targets.length;
        if (lenTar == 0) {
            return;
        }
        String text = this._conditionComposer.getFormula();
        if (StringUtil.isEmptyString((String)text)) {
            return;
        }
        for (int i = 0; i < lenTar; ++i) {
            IPreCondition condition = (IPreCondition)targets[i];
            if (condition == null) continue;
            Sheet sheet = cell.getSheet();
            condition.setBehaviorAction(sheet.getExpr(cell, text));
            condition.setBehaviorFontColor(this._colorEditor.getColor());
        }
    }

    public void syncSettings(Object[] targets, Cell cell) {
        if (targets == null) {
            return;
        }
        int lenTar = targets.length;
        if (lenTar == 0) {
            return;
        }
        String text = null;
        for (int i = 0; i < lenTar; ++i) {
            Expr non;
            IPreCondition condition = (IPreCondition)targets[i];
            if (condition == null || (non = condition.getBehaviorAction()) == null || StringUtil.isEmptyString((String)(text = non.decode(cell.getSheet().getDeps().getExprContext(), cell)))) continue;
            this._conditionComposer.setFormula(text);
            Color color = condition.getBehaviorFontColor();
            if (color == null) break;
            this._colorEditor.setColor(color);
            break;
        }
    }

    public void setDescription(String text) {
        this._informationArea.setText("\u6761\u4ef6\uff1a\u8bbe\u7f6e\u662f\u5426\u542f\u7528" + text + "\u7684\u524d\u7f6e\u516c\u5f0f\uff0c\u5f53\u516c\u5f0f\u7684\u6267\u884c\u7ed3\u679c\u4e3atrue\u7684\u65f6\u5019\u5c06\u542f\u7528\u5355\u5143\u683c\u7684" + text + "\uff0c\u5426\u5219\u7981\u7528\u3002\n\u989c\u8272\uff1a\u5f53\u7981\u7528\u5355\u5143\u683c\u7684" + text + "\u65f6\uff0c\u5355\u5143\u683c\u7684\u5b57\u4f53\u989c\u8272\u3002");
    }
}

