/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.pe.beans.renderer;

import com.kingdee.bos.ctrl.ext.pe.beans.value.VFPair;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;

public class DefaultCellRenderer
extends DefaultTableCellRenderer
implements ListCellRenderer {
    private Color oddBackgroundColor = SystemColor.window;
    private Color evenBackgroundColor = SystemColor.window;
    private boolean showOddAndEvenRows = true;

    public void setOddBackgroundColor(Color c) {
        this.oddBackgroundColor = c;
    }

    public void setEvenBackgroundColor(Color c) {
        this.evenBackgroundColor = c;
    }

    public void setShowOddAndEvenRows(boolean b) {
        this.showOddAndEvenRows = b;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setBorder(null);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setValue(value);
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.showOddAndEvenRows && !isSelected) {
            if (row % 2 == 0) {
                this.setBackground(this.oddBackgroundColor);
            } else {
                this.setBackground(this.evenBackgroundColor);
            }
        }
        this.setValue(value);
        return this;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof VFPair) || !((VFPair)value).hasFormula()) {
            String text = this.convertToString(value);
            Icon icon = this.convertToIcon(value);
            this.setText(text == null ? "" : text);
            this.setIcon(icon);
            this.setDisabledIcon(icon);
        } else {
            this.setIcon(null);
            this.setText(((VFPair)value).getFormula());
        }
    }

    protected String convertToString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    protected Icon convertToIcon(Object value) {
        return null;
    }
}

